/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.jdt;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FileASTRequestor;
import tools.mdsd.jamopp.model.java.JavaClasspath;
import tools.mdsd.jamopp.model.java.containers.ContainersFactory;
import tools.mdsd.jamopp.model.java.containers.EmptyModel;
import tools.mdsd.jamopp.model.java.containers.JavaRoot;
import tools.mdsd.jamopp.parser.api.JaMoPPParserAPI;
import tools.mdsd.jamopp.parser.jdt.JDTResolverUtility;
import tools.mdsd.jamopp.parser.jdt.OrdinaryCompilationUnitJDTASTVisitorAndConverter;
import tools.mdsd.jamopp.parser.jdt.TypeInstructionSeparationUtility;

public class JaMoPPJDTParser
implements JaMoPPParserAPI {
    private final String DEFAULT_ENCODING = StandardCharsets.UTF_8.toString();
    private ResourceSet resourceSet;

    public JavaRoot parse(String fileName, InputStream input) {
        EmptyModel model = this.createEmptyModel();
        this.resourceSet = null;
        return model;
    }

    private ASTNode parseFileWithJDT(String fileContent, String fileName) {
        ASTParser parser = this.setUpParser();
        parser.setUnitName(fileName);
        parser.setEnvironment(new String[0], new String[0], new String[0], true);
        parser.setSource(fileContent.toCharArray());
        return parser.createAST(null);
    }

    public Resource parseFile(Path file) {
        EmptyModel model = this.createEmptyModel();
        this.resourceSet = null;
        return model.eResource();
    }

    public ResourceSet parseDirectory(Path dir) {
        this.createEmptyModel();
        ResourceSet result = this.resourceSet;
        this.resourceSet = null;
        return result;
    }

    private List<JavaRoot> parseFilesWithJDT(String[] classpathEntries, String[] sources, String[] encodings) {
        final ArrayList<JavaRoot> result = new ArrayList<JavaRoot>();
        ASTParser parser = this.setUpParser();
        parser.setEnvironment(classpathEntries, new String[0], new String[0], true);
        final OrdinaryCompilationUnitJDTASTVisitorAndConverter converter = new OrdinaryCompilationUnitJDTASTVisitorAndConverter();
        parser.createASTs(sources, encodings, new String[0], new FileASTRequestor(){

            public void acceptAST(String sourceFilePath, CompilationUnit node) {
                node.accept((ASTVisitor)converter);
                JavaRoot root = converter.getConvertedElement();
                if (root.eResource() == null) {
                    Resource newResource = JaMoPPJDTParser.this.resourceSet.createResource(URI.createFileURI((String)sourceFilePath));
                    newResource.getContents().add((Object)root);
                    JavaClasspath.get((ResourceSet)JaMoPPJDTParser.this.resourceSet).registerJavaRoot(root, newResource.getURI());
                } else {
                    Resource newResource = root.eResource();
                    if (!newResource.getURI().toFileString().equals(sourceFilePath)) {
                        newResource.setURI(URI.createFileURI((String)sourceFilePath));
                        JavaClasspath.get((ResourceSet)JaMoPPJDTParser.this.resourceSet).registerJavaRoot(root, newResource.getURI());
                    }
                }
                result.add(root);
            }
        }, null);
        TypeInstructionSeparationUtility.convertAll();
        JDTResolverUtility.completeResolution();
        for (Resource res : new ArrayList(this.resourceSet.getResources())) {
            if (!res.getContents().isEmpty()) continue;
            try {
                res.delete(this.resourceSet.getLoadOptions());
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    private EmptyModel createEmptyModel() {
        this.setUpResourceSet();
        Resource container = this.resourceSet.createResource(URI.createURI((String)"model://empty.java"));
        EmptyModel model = ContainersFactory.eINSTANCE.createEmptyModel();
        container.getContents().add((Object)model);
        return model;
    }

    private void setUpResourceSet() {
        if (this.resourceSet == null) {
            this.resourceSet = new ResourceSetImpl();
        }
        JDTResolverUtility.setResourceSet(this.resourceSet);
    }

    private ASTParser setUpParser() {
        ASTParser parser = ASTParser.newParser((int)14);
        parser.setResolveBindings(true);
        parser.setBindingsRecovery(true);
        parser.setStatementsRecovery(true);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("org.eclipse.jdt.core.compiler.source", "14");
        options.put("org.eclipse.jdt.core.compiler.compliance", "14");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "14");
        parser.setCompilerOptions(options);
        return parser;
    }

    public void setResourceSet(ResourceSet set) {
        this.resourceSet = set;
    }
}

