/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.jdt;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IModuleBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import tools.mdsd.jamopp.model.java.JavaClasspath;
import tools.mdsd.jamopp.model.java.classifiers.Annotation;
import tools.mdsd.jamopp.model.java.classifiers.AnonymousClass;
import tools.mdsd.jamopp.model.java.classifiers.Class;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.classifiers.ClassifiersFactory;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Enumeration;
import tools.mdsd.jamopp.model.java.classifiers.Interface;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.containers.CompilationUnit;
import tools.mdsd.jamopp.model.java.containers.ContainersFactory;
import tools.mdsd.jamopp.model.java.containers.Module;
import tools.mdsd.jamopp.model.java.containers.Package;
import tools.mdsd.jamopp.model.java.generics.GenericsFactory;
import tools.mdsd.jamopp.model.java.generics.TypeParameter;
import tools.mdsd.jamopp.model.java.members.AdditionalField;
import tools.mdsd.jamopp.model.java.members.ClassMethod;
import tools.mdsd.jamopp.model.java.members.Constructor;
import tools.mdsd.jamopp.model.java.members.EnumConstant;
import tools.mdsd.jamopp.model.java.members.Field;
import tools.mdsd.jamopp.model.java.members.InterfaceMethod;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.members.MembersFactory;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.parameters.CatchParameter;
import tools.mdsd.jamopp.model.java.parameters.OrdinaryParameter;
import tools.mdsd.jamopp.model.java.parameters.Parameter;
import tools.mdsd.jamopp.model.java.parameters.ParametersFactory;
import tools.mdsd.jamopp.model.java.parameters.ReceiverParameter;
import tools.mdsd.jamopp.model.java.parameters.VariableLengthParameter;
import tools.mdsd.jamopp.model.java.references.ReferenceableElement;
import tools.mdsd.jamopp.model.java.statements.Block;
import tools.mdsd.jamopp.model.java.statements.Statement;
import tools.mdsd.jamopp.model.java.statements.StatementsFactory;
import tools.mdsd.jamopp.model.java.types.Boolean;
import tools.mdsd.jamopp.model.java.types.Byte;
import tools.mdsd.jamopp.model.java.types.Char;
import tools.mdsd.jamopp.model.java.types.ClassifierReference;
import tools.mdsd.jamopp.model.java.types.Double;
import tools.mdsd.jamopp.model.java.types.Float;
import tools.mdsd.jamopp.model.java.types.InferableType;
import tools.mdsd.jamopp.model.java.types.Int;
import tools.mdsd.jamopp.model.java.types.Long;
import tools.mdsd.jamopp.model.java.types.NamespaceClassifierReference;
import tools.mdsd.jamopp.model.java.types.Short;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.model.java.types.TypesFactory;
import tools.mdsd.jamopp.model.java.variables.AdditionalLocalVariable;
import tools.mdsd.jamopp.model.java.variables.LocalVariable;
import tools.mdsd.jamopp.model.java.variables.Variable;
import tools.mdsd.jamopp.model.java.variables.VariablesFactory;
import tools.mdsd.jamopp.parser.jdt.JDTBindingConverterUtility;

public class JDTResolverUtility {
    private static ResourceSet resourceSet;
    private static HashMap<String, Module> modBindToMod;
    private static HashMap<String, Package> nameToPackage;
    private static HashMap<String, Annotation> typeBindToAnnot;
    private static HashMap<String, Enumeration> typeBindToEnum;
    private static HashMap<String, Interface> typeBindToInterface;
    private static HashMap<String, Class> typeBindToClass;
    private static HashMap<String, TypeParameter> typeBindToTP;
    private static HashMap<String, InterfaceMethod> methBindToInter;
    private static HashMap<String, ClassMethod> methBindToCM;
    private static HashMap<String, Constructor> methBindToConstr;
    private static HashMap<String, Field> nameToField;
    private static HashMap<String, AdditionalField> nameToAddField;
    private static HashMap<String, LocalVariable> nameToLocVar;
    private static HashMap<String, AdditionalLocalVariable> nameToAddLocVar;
    private static HashMap<String, EnumConstant> nameToEnumConst;
    private static HashMap<String, VariableLengthParameter> nameToVarLenParam;
    private static HashMap<String, OrdinaryParameter> nameToOrdParam;
    private static HashMap<String, CatchParameter> nameToCatchParam;
    private static HashMap<String, AnonymousClass> nameToAnonymousClass;
    private static HashSet<IModuleBinding> moduleBindings;
    private static HashSet<IPackageBinding> packageBindings;
    private static HashSet<ITypeBinding> typeBindings;
    private static HashSet<IMethodBinding> methodBindings;
    private static HashSet<IVariableBinding> variableBindings;
    private static int uid;
    private static HashMap<IVariableBinding, Integer> varBindToUid;
    private static HashSet<EObject> objVisited;
    private static HashMap<IBinding, String> nameCache;
    private static final String SYNTH_CLASS = "SyntheticContainerClass";
    private static final boolean extractAdditionalInformationFromTypeBindings = true;

    static void setResourceSet(ResourceSet set) {
        resourceSet = set;
    }

    static Module getModule(IModuleBinding binding) {
        moduleBindings.add(binding);
        return JDTResolverUtility.getModule(binding.getName());
    }

    static Module getModule(String modName) {
        if (modBindToMod.containsKey(modName)) {
            return modBindToMod.get(modName);
        }
        Module result = JavaClasspath.get().getModule(modName);
        if (result == null) {
            result = ContainersFactory.eINSTANCE.createModule();
        }
        modBindToMod.put(modName, result);
        return result;
    }

    static Package getPackage(IPackageBinding binding) {
        packageBindings.add(binding);
        return JDTResolverUtility.getPackage(binding.getName());
    }

    private static Package getPackage(String packageName) {
        if (nameToPackage.containsKey(packageName)) {
            return nameToPackage.get(packageName);
        }
        Package result = JavaClasspath.get().getPackage(packageName);
        if (result == null) {
            result = ContainersFactory.eINSTANCE.createPackage();
        }
        nameToPackage.put(packageName, result);
        return result;
    }

    private static String convertToTypeName(ITypeBinding binding) {
        Object qualifiedName;
        if (binding == null) {
            return "";
        }
        if (binding.isTypeVariable()) {
            return binding.getName();
        }
        if (nameCache.containsKey(binding)) {
            return nameCache.get(binding);
        }
        if (binding.isMember()) {
            qualifiedName = JDTResolverUtility.convertToTypeName(binding.getDeclaringClass()) + "." + binding.getName();
        } else {
            if (binding.isLocal()) {
                IBinding b = binding.getDeclaringMember();
                Object qualifiedName2 = b instanceof IMethodBinding ? JDTResolverUtility.convertToMethodName((IMethodBinding)b) + "." + binding.getKey() : (b instanceof IVariableBinding ? JDTResolverUtility.convertToFieldName((IVariableBinding)b) + "." + binding.getKey() : binding.getKey());
                nameCache.put((IBinding)binding, (String)qualifiedName2);
                return qualifiedName2;
            }
            qualifiedName = binding.getQualifiedName();
        }
        if (((String)qualifiedName).contains("<")) {
            qualifiedName = ((String)qualifiedName).substring(0, ((String)qualifiedName).indexOf("<"));
        }
        nameCache.put((IBinding)binding, (String)qualifiedName);
        return qualifiedName;
    }

    static Annotation getAnnotation(ITypeBinding binding) {
        typeBindings.add(binding);
        return JDTResolverUtility.getAnnotation(JDTResolverUtility.convertToTypeName(binding));
    }

    static Annotation getAnnotation(String annotName) {
        if (typeBindToAnnot.containsKey(annotName)) {
            return typeBindToAnnot.get(annotName);
        }
        ConcreteClassifier potClass = JavaClasspath.get().getConcreteClassifier(annotName);
        Annotation result = potClass instanceof Annotation ? (Annotation)potClass : ClassifiersFactory.eINSTANCE.createAnnotation();
        typeBindToAnnot.put(annotName, result);
        return result;
    }

    static Enumeration getEnumeration(ITypeBinding binding) {
        String enumName = JDTResolverUtility.convertToTypeName(binding);
        if (typeBindToEnum.containsKey(enumName)) {
            return typeBindToEnum.get(enumName);
        }
        typeBindings.add(binding);
        ConcreteClassifier classifier = JavaClasspath.get().getConcreteClassifier(enumName);
        Enumeration result = classifier != null && classifier instanceof Enumeration ? (Enumeration)classifier : ClassifiersFactory.eINSTANCE.createEnumeration();
        typeBindToEnum.put(enumName, result);
        return result;
    }

    static Class getClass(ITypeBinding binding) {
        typeBindings.add(binding);
        return JDTResolverUtility.getClass(JDTResolverUtility.convertToTypeName(binding));
    }

    static Interface getInterface(ITypeBinding binding) {
        String interName = JDTResolverUtility.convertToTypeName(binding);
        if (typeBindToInterface.containsKey(interName)) {
            return typeBindToInterface.get(interName);
        }
        typeBindings.add(binding);
        ConcreteClassifier classifier = JavaClasspath.get().getConcreteClassifier(interName);
        Interface result = classifier != null && classifier instanceof Interface ? (Interface)classifier : ClassifiersFactory.eINSTANCE.createInterface();
        typeBindToInterface.put(interName, result);
        return result;
    }

    private static String convertToTypeParameterName(ITypeBinding binding) {
        if (binding == null) {
            return "";
        }
        if (nameCache.containsKey(binding)) {
            return nameCache.get(binding);
        }
        Object name = "";
        if (binding.getDeclaringClass() != null) {
            name = (String)name + JDTResolverUtility.convertToTypeName(binding.getDeclaringClass());
        } else if (binding.getDeclaringMethod() != null) {
            name = (String)name + JDTResolverUtility.convertToMethodName(binding.getDeclaringMethod());
        }
        name = (String)name + "." + binding.getName();
        nameCache.put((IBinding)binding, (String)name);
        return name;
    }

    static TypeParameter getTypeParameter(ITypeBinding binding) {
        String paramName = JDTResolverUtility.convertToTypeParameterName(binding);
        if (typeBindToTP.containsKey(paramName)) {
            return typeBindToTP.get(paramName);
        }
        typeBindings.add(binding);
        TypeParameter result = GenericsFactory.eINSTANCE.createTypeParameter();
        typeBindToTP.put(paramName, result);
        return result;
    }

    static Classifier getClassifier(ITypeBinding binding) {
        String typeName = JDTResolverUtility.convertToTypeName(binding);
        ConcreteClassifier potClass = JavaClasspath.get().getConcreteClassifier(typeName);
        if (potClass != null) {
            return potClass;
        }
        if (binding.isAnonymous() || binding.isLocal() && binding.getDeclaringMember() == null || nameToAnonymousClass.containsKey(JDTResolverUtility.convertToTypeName(binding))) {
            return null;
        }
        if (binding.isAnnotation()) {
            return JDTResolverUtility.getAnnotation(binding);
        }
        if (binding.isInterface()) {
            return JDTResolverUtility.getInterface(binding);
        }
        if (binding.isEnum()) {
            return JDTResolverUtility.getEnumeration(binding);
        }
        if (binding.isClass()) {
            return JDTResolverUtility.getClass(binding);
        }
        if (binding.isTypeVariable()) {
            return JDTResolverUtility.getTypeParameter(binding);
        }
        if (binding.isArray()) {
            return JDTResolverUtility.getClassifier(binding.getElementType());
        }
        return null;
    }

    private static String convertToMethodName(IMethodBinding binding) {
        if (binding == null) {
            return "";
        }
        if (nameCache.containsKey(binding)) {
            return nameCache.get(binding);
        }
        binding = binding.getMethodDeclaration();
        StringBuilder builder = new StringBuilder();
        builder.append(JDTResolverUtility.convertToTypeName(binding.getDeclaringClass()));
        builder.append("::");
        builder.append(binding.getName());
        builder.append("(");
        for (ITypeBinding p : binding.getParameterTypes()) {
            builder.append(JDTResolverUtility.convertToTypeName(p));
            for (int i = 0; i < p.getDimensions(); ++i) {
                builder.append("[]");
            }
        }
        builder.append(")");
        if (builder.toString().equals("java.lang.Object::clone()") && binding.getReturnType().isArray()) {
            builder.append("java.lang.Object");
        } else {
            builder.append(JDTResolverUtility.convertToTypeName(binding.getReturnType()));
        }
        String name = builder.toString();
        nameCache.put((IBinding)binding, name);
        return name;
    }

    static InterfaceMethod getInterfaceMethod(String methodName) {
        if (methBindToInter.containsKey(methodName)) {
            return methBindToInter.get(methodName);
        }
        InterfaceMethod result = JDTResolverUtility.createNewInterfaceMethod();
        methBindToInter.put(methodName, result);
        return result;
    }

    private static InterfaceMethod createNewInterfaceMethod() {
        InterfaceMethod result = MembersFactory.eINSTANCE.createInterfaceMethod();
        result.setTypeReference((TypeReference)TypesFactory.eINSTANCE.createVoid());
        result.setStatement((Statement)StatementsFactory.eINSTANCE.createEmptyStatement());
        return result;
    }

    static InterfaceMethod getInterfaceMethod(IMethodBinding binding) {
        binding = binding.getMethodDeclaration();
        methodBindings.add(binding);
        String methName = JDTResolverUtility.convertToMethodName(binding);
        if (methBindToInter.containsKey(methName)) {
            return methBindToInter.get(methName);
        }
        ConcreteClassifier classifier = (ConcreteClassifier)JDTResolverUtility.getClassifier(binding.getDeclaringClass());
        InterfaceMethod result = null;
        if (classifier != null) {
            Member mem;
            Iterator iterator = classifier.getMembers().iterator();
            while (iterator.hasNext() && (!((mem = (Member)iterator.next()) instanceof InterfaceMethod) || (result = (InterfaceMethod)JDTResolverUtility.checkMethod((Method)mem, binding)) == null)) {
            }
        }
        if (result == null) {
            result = JDTResolverUtility.createNewInterfaceMethod();
        }
        methBindToInter.put(methName, result);
        return result;
    }

    static ClassMethod getClassMethod(String methodName) {
        if (methBindToCM.containsKey(methodName)) {
            return methBindToCM.get(methodName);
        }
        ClassMethod result = JDTResolverUtility.createNewClassMethod();
        methBindToCM.put(methodName, result);
        return result;
    }

    private static ClassMethod createNewClassMethod() {
        ClassMethod result = MembersFactory.eINSTANCE.createClassMethod();
        result.setTypeReference((TypeReference)TypesFactory.eINSTANCE.createVoid());
        Block block = StatementsFactory.eINSTANCE.createBlock();
        block.setName("");
        result.setStatement((Statement)block);
        return result;
    }

    static ClassMethod getClassMethod(IMethodBinding binding) {
        binding = binding.getMethodDeclaration();
        methodBindings.add(binding);
        String methName = JDTResolverUtility.convertToMethodName(binding);
        if (methBindToCM.containsKey(methName)) {
            return methBindToCM.get(methName);
        }
        ConcreteClassifier classifier = (ConcreteClassifier)JDTResolverUtility.getClassifier(binding.getDeclaringClass());
        ClassMethod result = null;
        if (classifier != null) {
            Member mem;
            Iterator iterator = classifier.getMembers().iterator();
            while (iterator.hasNext() && (!((mem = (Member)iterator.next()) instanceof ClassMethod) || (result = (ClassMethod)JDTResolverUtility.checkMethod((Method)mem, binding)) == null)) {
            }
        }
        if (result == null) {
            result = JDTResolverUtility.createNewClassMethod();
        }
        methBindToCM.put(methName, result);
        return result;
    }

    private static <T extends Method> T checkMethod(Method mem, IMethodBinding binding) {
        if (mem.getName().equals(binding.getName())) {
            Method meth = mem;
            if (meth.getName().equals("clone")) {
                return (T)meth;
            }
            int receiveOffset = 0;
            if (binding.getDeclaredReceiverType() != null) {
                receiveOffset = 1;
            }
            if (binding.getParameterTypes().length + receiveOffset == meth.getParameters().size()) {
                if (!(receiveOffset != 1 || meth.getParameters().get(0) instanceof ReceiverParameter && JDTResolverUtility.convertToTypeName(binding.getDeclaredReceiverType()).equals(JDTResolverUtility.convertToTypeName(((Parameter)meth.getParameters().get(0)).getTypeReference())))) {
                    return null;
                }
                if (!JDTResolverUtility.convertToTypeName(binding.getReturnType()).equals(JDTResolverUtility.convertToTypeName(meth.getTypeReference()))) {
                    return null;
                }
                for (int i = 0; i < binding.getParameterTypes().length; ++i) {
                    ITypeBinding currentParamType = binding.getParameterTypes()[i];
                    Parameter currentParam = (Parameter)meth.getParameters().get(i + receiveOffset);
                    if (JDTResolverUtility.convertToTypeName(currentParamType).equals(JDTResolverUtility.convertToTypeName(currentParam.getTypeReference())) && (long)currentParamType.getDimensions() == currentParam.getTypeReference().getArrayDimension()) continue;
                    return null;
                }
                return (T)meth;
            }
        }
        return null;
    }

    private static String convertToTypeName(TypeReference ref) {
        if (ref instanceof ClassifierReference) {
            ClassifierReference convRef = (ClassifierReference)ref;
            if (convRef.getTarget() instanceof ConcreteClassifier) {
                return ((ConcreteClassifier)convRef.getTarget()).getQualifiedName();
            }
            if (convRef.getTarget() instanceof InferableType) {
                return "var";
            }
            return ((TypeParameter)convRef.getTarget()).getName();
        }
        if (ref instanceof NamespaceClassifierReference) {
            NamespaceClassifierReference nRef = (NamespaceClassifierReference)ref;
            if (nRef.getClassifierReferences().size() > 0) {
                return JDTResolverUtility.convertToTypeName((TypeReference)nRef.getClassifierReferences().get(nRef.getClassifierReferences().size() - 1));
            }
            return nRef.getNamespacesAsString();
        }
        if (ref instanceof Boolean) {
            return "boolean";
        }
        if (ref instanceof Byte) {
            return "byte";
        }
        if (ref instanceof Char) {
            return "char";
        }
        if (ref instanceof Double) {
            return "double";
        }
        if (ref instanceof Float) {
            return "float";
        }
        if (ref instanceof Int) {
            return "int";
        }
        if (ref instanceof Long) {
            return "long";
        }
        if (ref instanceof Short) {
            return "short";
        }
        return "void";
    }

    static Constructor getConstructor(IMethodBinding binding) {
        String methName = JDTResolverUtility.convertToMethodName(binding);
        if (methBindToConstr.containsKey(methName)) {
            return methBindToConstr.get(methName);
        }
        methodBindings.add(binding);
        Constructor result = null;
        ConcreteClassifier potClass = (ConcreteClassifier)JDTResolverUtility.getClassifier(binding.getDeclaringClass());
        if (potClass != null) {
            block0: for (Member mem : potClass.getMembers()) {
                if (!(mem instanceof Constructor) || !mem.getName().equals(binding.getName())) continue;
                Constructor con = (Constructor)mem;
                int receiveOffset = 0;
                if (binding.getDeclaredReceiverType() != null) {
                    receiveOffset = 1;
                }
                if (con.getParameters().size() != binding.getParameterTypes().length + receiveOffset || receiveOffset == 1 && (!(con.getParameters().get(0) instanceof ReceiverParameter) || !JDTResolverUtility.convertToTypeName(binding.getDeclaredReceiverType()).equals(JDTResolverUtility.convertToTypeName(((Parameter)con.getParameters().get(0)).getTypeReference())))) continue;
                for (int i = 0; i < binding.getParameterTypes().length; ++i) {
                    ITypeBinding currentType = binding.getParameterTypes()[i];
                    Parameter currentParam = (Parameter)con.getParameters().get(i + receiveOffset);
                    if (!JDTResolverUtility.convertToTypeName(currentType).equals(JDTResolverUtility.convertToTypeName(currentParam.getTypeReference())) || (long)currentType.getDimensions() != currentParam.getTypeReference().getArrayDimension()) continue block0;
                }
                result = con;
                break;
            }
        }
        if (result == null) {
            result = MembersFactory.eINSTANCE.createConstructor();
            Block block = StatementsFactory.eINSTANCE.createBlock();
            block.setName("");
            result.setBlock(block);
        }
        methBindToConstr.put(methName, result);
        return result;
    }

    static Constructor getConstructor(String methName) {
        if (methBindToConstr.containsKey(methName)) {
            return methBindToConstr.get(methName);
        }
        Constructor result = MembersFactory.eINSTANCE.createConstructor();
        Block block = StatementsFactory.eINSTANCE.createBlock();
        block.setName("");
        result.setBlock(block);
        methBindToConstr.put(methName, result);
        return result;
    }

    static Method getMethod(IMethodBinding binding) {
        if (binding.getDeclaringClass().isInterface()) {
            return JDTResolverUtility.getInterfaceMethod(binding);
        }
        return JDTResolverUtility.getClassMethod(binding);
    }

    static Class getClass(String typeName) {
        if (typeBindToClass.containsKey(typeName)) {
            return typeBindToClass.get(typeName);
        }
        ConcreteClassifier potClass = JavaClasspath.get().getConcreteClassifier(typeName);
        Class result = potClass instanceof Class ? (Class)potClass : ClassifiersFactory.eINSTANCE.createClass();
        typeBindToClass.put(typeName, result);
        return result;
    }

    static AnonymousClass getAnonymousClass(String typeName) {
        if (nameToAnonymousClass.containsKey(typeName)) {
            return nameToAnonymousClass.get(typeName);
        }
        AnonymousClass result = ClassifiersFactory.eINSTANCE.createAnonymousClass();
        nameToAnonymousClass.put(typeName, result);
        return result;
    }

    static AnonymousClass getAnonymousClass(ITypeBinding binding) {
        String typeName = JDTResolverUtility.convertToTypeName(binding);
        return JDTResolverUtility.getAnonymousClass(typeName);
    }

    private static String convertToFieldName(IVariableBinding binding) {
        if (binding == null || !binding.isField()) {
            return "";
        }
        if (nameCache.containsKey(binding)) {
            return nameCache.get(binding);
        }
        String name = JDTResolverUtility.convertToTypeName(binding.getDeclaringClass()) + "::" + binding.getName();
        nameCache.put((IBinding)binding, name);
        return name;
    }

    static Field getField(String name) {
        if (nameToField.containsKey(name)) {
            return nameToField.get(name);
        }
        Field result = MembersFactory.eINSTANCE.createField();
        nameToField.put(name, result);
        return result;
    }

    static Field getField(IVariableBinding binding) {
        String varName = JDTResolverUtility.convertToFieldName(binding);
        if (nameToField.containsKey(varName)) {
            return nameToField.get(varName);
        }
        variableBindings.add(binding);
        ConcreteClassifier potClass = null;
        if (binding.getDeclaringClass() != null) {
            potClass = (ConcreteClassifier)JDTResolverUtility.getClassifier(binding.getDeclaringClass());
        }
        Field result = null;
        if (potClass != null) {
            for (Member mem : potClass.getMembers()) {
                if (!(mem instanceof Field) || !mem.getName().equals(binding.getName())) continue;
                result = (Field)mem;
                break;
            }
        }
        if (result == null) {
            result = MembersFactory.eINSTANCE.createField();
            result.setTypeReference((TypeReference)TypesFactory.eINSTANCE.createInt());
        }
        nameToField.put(varName, result);
        return result;
    }

    static EnumConstant getEnumConstant(IVariableBinding binding) {
        String enumCN = JDTResolverUtility.convertToFieldName(binding);
        if (nameToEnumConst.containsKey(enumCN)) {
            return nameToEnumConst.get(enumCN);
        }
        variableBindings.add(binding);
        Enumeration potPar = JDTResolverUtility.getEnumeration(binding.getDeclaringClass());
        EnumConstant result = null;
        if (potPar != null) {
            for (EnumConstant con : potPar.getConstants()) {
                if (!con.getName().equals(binding.getName())) continue;
                result = con;
                break;
            }
        }
        if (result == null) {
            result = MembersFactory.eINSTANCE.createEnumConstant();
        }
        nameToEnumConst.put(enumCN, result);
        return result;
    }

    static EnumConstant getEnumConstant(String enumCN) {
        if (nameToEnumConst.containsKey(enumCN)) {
            return nameToEnumConst.get(enumCN);
        }
        EnumConstant result = MembersFactory.eINSTANCE.createEnumConstant();
        nameToEnumConst.put(enumCN, result);
        return result;
    }

    static AdditionalField getAdditionalField(String name) {
        if (nameToAddField.containsKey(name)) {
            return nameToAddField.get(name);
        }
        AdditionalField result = MembersFactory.eINSTANCE.createAdditionalField();
        nameToAddField.put(name, result);
        return result;
    }

    static AdditionalField getAdditionalField(IVariableBinding binding) {
        String varName = JDTResolverUtility.convertToFieldName(binding);
        if (nameToAddField.containsKey(varName)) {
            return nameToAddField.get(varName);
        }
        variableBindings.add(binding);
        AdditionalField result = null;
        ConcreteClassifier potClass = (ConcreteClassifier)JDTResolverUtility.getClassifier(binding.getDeclaringClass());
        if (potClass != null) {
            block0: for (Member mem : potClass.getMembers()) {
                if (!(mem instanceof Field)) continue;
                Field field = (Field)mem;
                for (AdditionalField af : field.getAdditionalFields()) {
                    if (!af.getName().equals(binding.getName())) continue;
                    result = af;
                    break block0;
                }
            }
        }
        if (result == null) {
            result = MembersFactory.eINSTANCE.createAdditionalField();
        }
        nameToAddField.put(varName, result);
        return result;
    }

    private static String convertToParameterName(IVariableBinding binding, boolean register) {
        if (binding == null) {
            return "";
        }
        if (nameCache.containsKey(binding)) {
            return nameCache.get(binding);
        }
        Object prefix = "";
        if (binding.getDeclaringMethod() != null) {
            prefix = JDTResolverUtility.convertToMethodName(binding.getDeclaringMethod());
        } else if (varBindToUid.containsKey(binding)) {
            prefix = String.valueOf(varBindToUid.get(binding));
        } else {
            prefix = "" + uid;
            if (register) {
                varBindToUid.put(binding, uid);
            }
        }
        String name = (String)prefix + "::" + binding.getName() + "::" + binding.getVariableId() + binding.hashCode();
        nameCache.put((IBinding)binding, name);
        return name;
    }

    static LocalVariable getLocalVariable(IVariableBinding binding) {
        variableBindings.add(binding);
        return JDTResolverUtility.getLocalVariable(JDTResolverUtility.convertToParameterName(binding, true));
    }

    static LocalVariable getLocalVariable(String varName) {
        if (nameToLocVar.containsKey(varName)) {
            return nameToLocVar.get(varName);
        }
        LocalVariable result = VariablesFactory.eINSTANCE.createLocalVariable();
        nameToLocVar.put(varName, result);
        return result;
    }

    static AdditionalLocalVariable getAdditionalLocalVariable(IVariableBinding binding) {
        variableBindings.add(binding);
        return JDTResolverUtility.getAdditionalLocalVariable(JDTResolverUtility.convertToParameterName(binding, true));
    }

    static AdditionalLocalVariable getAdditionalLocalVariable(String varName) {
        if (nameToAddLocVar.containsKey(varName)) {
            return nameToAddLocVar.get(varName);
        }
        AdditionalLocalVariable result = VariablesFactory.eINSTANCE.createAdditionalLocalVariable();
        nameToAddLocVar.put(varName, result);
        return result;
    }

    static OrdinaryParameter getOrdinaryParameter(IVariableBinding binding) {
        variableBindings.add(binding);
        String paramName = JDTResolverUtility.convertToParameterName(binding, true);
        return JDTResolverUtility.getOrdinaryParameter(paramName);
    }

    static OrdinaryParameter getOrdinaryParameter(String paramName) {
        if (nameToOrdParam.containsKey(paramName)) {
            return nameToOrdParam.get(paramName);
        }
        OrdinaryParameter result = ParametersFactory.eINSTANCE.createOrdinaryParameter();
        nameToOrdParam.put(paramName, result);
        return result;
    }

    static VariableLengthParameter getVariableLengthParameter(IVariableBinding binding) {
        String paramName = JDTResolverUtility.convertToParameterName(binding, true);
        if (nameToVarLenParam.containsKey(paramName)) {
            return nameToVarLenParam.get(paramName);
        }
        variableBindings.add(binding);
        VariableLengthParameter result = ParametersFactory.eINSTANCE.createVariableLengthParameter();
        nameToVarLenParam.put(paramName, result);
        return result;
    }

    static CatchParameter getCatchParameter(IVariableBinding binding) {
        variableBindings.add(binding);
        return JDTResolverUtility.getCatchParameter(JDTResolverUtility.convertToParameterName(binding, true));
    }

    static CatchParameter getCatchParameter(String paramName) {
        if (nameToCatchParam.containsKey(paramName)) {
            return nameToCatchParam.get(paramName);
        }
        CatchParameter result = ParametersFactory.eINSTANCE.createCatchParameter();
        nameToCatchParam.put(paramName, result);
        return result;
    }

    static void prepareNextUid() {
        ++uid;
    }

    static ReferenceableElement getReferencableElement(IVariableBinding binding) {
        if (binding.isEnumConstant()) {
            return JDTResolverUtility.getEnumConstant(binding);
        }
        if (binding.isField()) {
            String fieldName = JDTResolverUtility.convertToFieldName(binding);
            if (nameToField.containsKey(fieldName)) {
                return (ReferenceableElement)nameToField.get(fieldName);
            }
            if (nameToAddField.containsKey(fieldName)) {
                return (ReferenceableElement)nameToAddField.get(fieldName);
            }
            return JDTResolverUtility.getField(binding);
        }
        if (binding.isParameter()) {
            String paramName = JDTResolverUtility.convertToParameterName(binding, false);
            if (nameToOrdParam.containsKey(paramName)) {
                return (ReferenceableElement)nameToOrdParam.get(paramName);
            }
            if (nameToVarLenParam.containsKey(paramName)) {
                return (ReferenceableElement)nameToVarLenParam.get(paramName);
            }
            return JDTResolverUtility.getOrdinaryParameter(binding);
        }
        String paramName = JDTResolverUtility.convertToParameterName(binding, false);
        if (nameToCatchParam.containsKey(paramName)) {
            return (ReferenceableElement)nameToCatchParam.get(paramName);
        }
        if (nameToLocVar.containsKey(paramName)) {
            return (ReferenceableElement)nameToLocVar.get(paramName);
        }
        if (nameToAddLocVar.containsKey(paramName)) {
            return (ReferenceableElement)nameToAddLocVar.get(paramName);
        }
        if (nameToOrdParam.containsKey(paramName)) {
            return (ReferenceableElement)nameToOrdParam.get(paramName);
        }
        return JDTResolverUtility.getLocalVariable(binding);
    }

    static ReferenceableElement getReferenceableElementByNameMatching(String name) {
        IVariableBinding vBinding = variableBindings.stream().filter(var -> var != null && var.getName().equals(name)).findFirst().orElse(null);
        if (vBinding != null) {
            return JDTResolverUtility.getReferencableElement(vBinding);
        }
        IMethodBinding mBinding = methodBindings.stream().filter(meth -> !meth.isConstructor() && meth.getName().equals(name)).findFirst().orElse(null);
        if (mBinding != null) {
            return JDTResolverUtility.getMethod(mBinding);
        }
        ITypeBinding tBinding = typeBindings.stream().filter(type -> type != null && type.getName().equals(name)).findFirst().orElse(null);
        if (tBinding != null) {
            return JDTResolverUtility.getClassifier(tBinding);
        }
        Variable par = nameToCatchParam.values().stream().filter(param -> param.getName().equals(name)).findFirst().orElse(null);
        if (par != null) {
            return par;
        }
        par = nameToLocVar.values().stream().filter(param -> param.getName().equals(name)).findFirst().orElse(null);
        if (par != null) {
            return par;
        }
        AdditionalLocalVariable addLocVar = nameToAddLocVar.values().stream().filter(param -> param.getName().equals(name)).findFirst().orElse(null);
        if (addLocVar != null) {
            return addLocVar;
        }
        par = nameToVarLenParam.values().stream().filter(param -> param.getName().equals(name)).findFirst().orElse(null);
        if (par != null) {
            return par;
        }
        par = nameToOrdParam.values().stream().filter(param -> param.getName().equals(name)).findFirst().orElse(null);
        if (par != null) {
            return par;
        }
        EnumConstant enumConst = nameToEnumConst.values().stream().filter(param -> param.getName().equals(name)).findFirst().orElse(null);
        if (enumConst != null) {
            return enumConst;
        }
        Field field = nameToField.values().stream().filter(param -> param != null && param.getName().equals(name)).findFirst().orElse(null);
        if (field != null) {
            return field;
        }
        AdditionalField addField = nameToAddField.values().stream().filter(param -> param.getName().equals(name)).findFirst().orElse(null);
        if (addField != null) {
            return addField;
        }
        Method meth2 = methBindToCM.values().stream().filter(param -> param.getName().equals(name)).findFirst().orElse(null);
        if (meth2 != null) {
            return meth2;
        }
        meth2 = methBindToInter.values().stream().filter(param -> param.getName().equals(name)).findFirst().orElse(null);
        if (meth2 != null) {
            return meth2;
        }
        Classifier c = typeBindToTP.values().stream().filter(param -> param.getName().equals(name)).findFirst().orElse(null);
        if (c != null) {
            return c;
        }
        c = typeBindToEnum.values().stream().filter(param -> name.equals(param.getName())).findFirst().orElse(null);
        if (c != null) {
            return c;
        }
        c = typeBindToAnnot.values().stream().filter(param -> name.equals(param.getName())).findFirst().orElse(null);
        if (c != null) {
            return c;
        }
        c = typeBindToClass.values().stream().filter(param -> name.equals(param.getName())).findFirst().orElse(null);
        if (c != null) {
            return c;
        }
        c = typeBindToInterface.values().stream().filter(param -> name.equals(param.getName())).findFirst().orElse(null);
        if (c != null) {
            return c;
        }
        return JDTResolverUtility.getClass(name);
    }

    static void completeResolution() {
        nameToEnumConst.forEach((constName, enConst) -> {
            IVariableBinding varBind;
            if (enConst.eContainer() == null && !(varBind = variableBindings.stream().filter(var -> var != null && constName.equals(JDTResolverUtility.convertToFieldName(var))).findFirst().get()).getDeclaringClass().isAnonymous()) {
                Enumeration enumeration = JDTResolverUtility.getEnumeration(varBind.getDeclaringClass());
            }
        });
        nameToField.forEach((fieldName, field) -> {
            if (field.eContainer() == null) {
                IVariableBinding varBind = variableBindings.stream().filter(var -> var != null && fieldName.equals(JDTResolverUtility.convertToFieldName(var))).findFirst().orElse(null);
                if (varBind == null || varBind.getDeclaringClass() == null) {
                    JDTResolverUtility.addToSyntheticClass((Member)field);
                } else {
                    Classifier cla = JDTResolverUtility.getClassifier(varBind.getDeclaringClass());
                    if (cla == null) {
                        String typeName = JDTResolverUtility.convertToTypeName(varBind.getDeclaringClass());
                        if (nameToAnonymousClass.containsKey(typeName)) {
                            AnonymousClass anonClass = nameToAnonymousClass.get(typeName);
                            if (!anonClass.getMembers().contains(field)) {
                                anonClass.getMembers().add(field);
                            }
                        } else {
                            JDTResolverUtility.addToSyntheticClass((Member)field);
                        }
                    }
                }
            }
        });
        methBindToConstr.forEach(JDTResolverUtility::completeMethod);
        methBindToInter.forEach(JDTResolverUtility::completeMethod);
        methBindToCM.forEach(JDTResolverUtility::completeMethod);
        JDTResolverUtility.convertPureTypeBindings();
        JDTResolverUtility.escapeAllIdentifiers();
        modBindToMod.clear();
        nameToPackage.clear();
        typeBindToAnnot.clear();
        typeBindToEnum.clear();
        typeBindToInterface.clear();
        typeBindToClass.clear();
        typeBindToTP.clear();
        methBindToInter.clear();
        methBindToCM.clear();
        methBindToConstr.clear();
        nameToField.clear();
        nameToAddField.clear();
        nameToLocVar.clear();
        nameToAddLocVar.clear();
        nameToEnumConst.clear();
        nameToVarLenParam.clear();
        nameToOrdParam.clear();
        nameToCatchParam.clear();
        moduleBindings.clear();
        packageBindings.clear();
        typeBindings.clear();
        methodBindings.clear();
        variableBindings.clear();
        uid = 0;
        varBindToUid.clear();
        objVisited.clear();
        nameCache.clear();
        nameToAnonymousClass.clear();
    }

    private static void completeMethod(String methodName, Member method) {
        if (method.eContainer() == null) {
            IMethodBinding methBind = methodBindings.stream().filter(meth -> methodName.equals(JDTResolverUtility.convertToMethodName(meth))).findFirst().orElse(null);
            if (methBind != null) {
                Classifier cla = JDTResolverUtility.getClassifier(methBind.getDeclaringClass());
                if (cla == null) {
                    String typeName = JDTResolverUtility.convertToTypeName(methBind.getDeclaringClass());
                    if (nameToAnonymousClass.containsKey(typeName)) {
                        AnonymousClass anonClass = nameToAnonymousClass.get(typeName);
                        if (!anonClass.getMembers().contains((Object)method)) {
                            anonClass.getMembers().add((Object)method);
                        }
                    } else {
                        JDTResolverUtility.addToSyntheticClass(method);
                    }
                }
            } else {
                JDTResolverUtility.addToSyntheticClass(method);
            }
        }
    }

    private static void addToSyntheticClass(Member member) {
        Class container = JDTResolverUtility.getClass(SYNTH_CLASS);
        container.setName(SYNTH_CLASS);
        if (!container.getMembers().contains((Object)member)) {
            container.getMembers().add((Object)member);
        }
    }

    private static void convertPureTypeBindings() {
        int oldSize;
        int newSize = typeBindToAnnot.size() + typeBindToEnum.size() + typeBindToInterface.size() + typeBindToClass.size() + modBindToMod.size() + nameToPackage.size();
        do {
            oldSize = newSize;
            HashMap map = (HashMap)typeBindToAnnot.clone();
            map.forEach(JDTResolverUtility::convertPureTypeBinding);
            map = (HashMap)typeBindToEnum.clone();
            map.forEach(JDTResolverUtility::convertPureTypeBinding);
            map = (HashMap)typeBindToInterface.clone();
            map.forEach(JDTResolverUtility::convertPureTypeBinding);
            map = (HashMap)typeBindToClass.clone();
            map.forEach(JDTResolverUtility::convertPureTypeBinding);
            HashMap mapP = (HashMap)nameToPackage.clone();
            mapP.forEach(JDTResolverUtility::convertPurePackageBinding);
            HashMap mapM = (HashMap)modBindToMod.clone();
            mapM.forEach(JDTResolverUtility::convertPureModuleBinding);
        } while (oldSize < (newSize = typeBindToAnnot.size() + typeBindToEnum.size() + typeBindToInterface.size() + typeBindToClass.size() + modBindToMod.size() + nameToPackage.size()));
    }

    private static void convertPureTypeBinding(String typeName, ConcreteClassifier classifier) {
        ITypeBinding elementType;
        if (objVisited.contains(classifier)) {
            return;
        }
        objVisited.add((EObject)classifier);
        ConcreteClassifier potClass = JavaClasspath.get().getConcreteClassifier(typeName);
        if (potClass == classifier) {
            return;
        }
        ITypeBinding typeBind = typeBindings.stream().filter(type -> type != null && typeName.equals(JDTResolverUtility.convertToTypeName(type))).findFirst().orElse(null);
        if (typeBind == null) {
            classifier.setPackage(JDTResolverUtility.getPackage(""));
            if (classifier.eContainer() != null) {
                return;
            }
        } else if (typeBind.isTopLevel()) {
            JDTBindingConverterUtility.convertToConcreteClassifier(typeBind, true);
        } else if (typeBind.isNested()) {
            ConcreteClassifier parentClassifier = (ConcreteClassifier)JDTResolverUtility.getClassifier(typeBind.getDeclaringClass());
            JDTResolverUtility.convertPureTypeBinding(JDTResolverUtility.convertToTypeName(typeBind.getDeclaringClass()), parentClassifier);
            classifier.setPackage(JDTResolverUtility.getPackage(typeBind.getPackage()));
        } else if (typeBind.isArray() && !(elementType = typeBind.getElementType()).isPrimitive() && !elementType.isTypeVariable()) {
            JDTResolverUtility.convertPureTypeBinding(typeName, (ConcreteClassifier)JDTResolverUtility.getClassifier(elementType));
        }
        if (classifier.eContainer() == null) {
            CompilationUnit cu = ContainersFactory.eINSTANCE.createCompilationUnit();
            cu.setName("");
            cu.getClassifiers().add((Object)classifier);
            String[] namespaces = typeName.substring(0, typeName.length()).split("\\.");
            classifier.setName(namespaces[namespaces.length - 1]);
            for (int index = 0; index < namespaces.length - 1; ++index) {
                cu.getNamespaces().add((Object)namespaces[index]);
            }
            Resource newResource = resourceSet.createResource(URI.createHierarchicalURI((String)"empty", (String)"JaMoPP-CompilationUnit", null, (String[])new String[]{typeName + ".java"}, null, null));
            newResource.getContents().add((Object)cu);
        }
    }

    private static void convertPurePackageBinding(String packageName, Package pack) {
        if (objVisited.contains(pack)) {
            return;
        }
        objVisited.add((EObject)pack);
        Package potPack = JavaClasspath.get().getPackage(packageName);
        if (potPack == pack) {
            return;
        }
        IPackageBinding binding = packageBindings.stream().filter(b -> packageName.equals(b.getName())).findFirst().orElse(null);
        if (binding == null) {
            pack.setName("");
            pack.setModule(JDTResolverUtility.getModule(""));
        } else {
            JDTBindingConverterUtility.convertToPackage(binding);
        }
        if (pack.eResource() != null) {
            return;
        }
        Resource newResource = resourceSet.createResource(URI.createHierarchicalURI((String)"empty", (String)"JaMoPP-Package", null, (String[])new String[]{packageName, "package-info.java"}, null, null));
        newResource.getContents().add((Object)pack);
    }

    private static void convertPureModuleBinding(String modName, Module module) {
        if (objVisited.contains(module)) {
            return;
        }
        objVisited.add((EObject)module);
        Module potMod = JavaClasspath.get().getModule(modName);
        if (potMod == module) {
            return;
        }
        if (module.eResource() != null) {
            return;
        }
        IModuleBinding binding = moduleBindings.stream().filter(b -> modName.equals(b.getName())).findFirst().orElse(null);
        if (binding == null) {
            String[] parts;
            module.getNamespaces().clear();
            for (String part : parts = modName.split("\\.")) {
                module.getNamespaces().add((Object)part);
            }
            module.setName("");
        } else {
            JDTBindingConverterUtility.convertToModule(binding);
        }
        Resource newResource = resourceSet.createResource(URI.createHierarchicalURI((String)"empty", (String)"JaMoPP-Module", null, (String[])new String[]{modName, "module-info.java"}, null, null));
        newResource.getContents().add((Object)module);
    }

    private static void escapeAllIdentifiers() {
        modBindToMod.values().forEach(JDTResolverUtility::escapeIdentifiers);
        nameToPackage.values().forEach(JDTResolverUtility::escapeIdentifiers);
        typeBindToAnnot.values().forEach(JDTResolverUtility::escapeIdentifiers);
        typeBindToEnum.values().forEach(JDTResolverUtility::escapeIdentifiers);
        typeBindToClass.values().forEach(JDTResolverUtility::escapeIdentifiers);
        typeBindToInterface.values().forEach(JDTResolverUtility::escapeIdentifiers);
    }

    private static void escapeIdentifiers(EObject obj) {
        obj.eAllContents().forEachRemaining(JDTResolverUtility::escapeIdentifier);
    }

    private static void escapeIdentifier(Notifier not) {
        if (not instanceof NamedElement) {
            NamedElement ele = (NamedElement)not;
            StringBuilder builder = new StringBuilder();
            String name = ele.getName();
            name.codePoints().forEach(i -> {
                if (i <= 32 || 55296 <= i && i <= 57343) {
                    builder.append("\\u" + String.format("%04x", i));
                } else {
                    builder.appendCodePoint(i);
                }
            });
            ele.setName(builder.toString());
        }
    }

    static {
        modBindToMod = new HashMap();
        nameToPackage = new HashMap();
        typeBindToAnnot = new HashMap();
        typeBindToEnum = new HashMap();
        typeBindToInterface = new HashMap();
        typeBindToClass = new HashMap();
        typeBindToTP = new HashMap();
        methBindToInter = new HashMap();
        methBindToCM = new HashMap();
        methBindToConstr = new HashMap();
        nameToField = new HashMap();
        nameToAddField = new HashMap();
        nameToLocVar = new HashMap();
        nameToAddLocVar = new HashMap();
        nameToEnumConst = new HashMap();
        nameToVarLenParam = new HashMap();
        nameToOrdParam = new HashMap();
        nameToCatchParam = new HashMap();
        nameToAnonymousClass = new HashMap();
        moduleBindings = new HashSet();
        packageBindings = new HashSet();
        typeBindings = new HashSet();
        methodBindings = new HashSet();
        variableBindings = new HashSet();
        uid = 0;
        varBindToUid = new HashMap();
        objVisited = new HashSet();
        nameCache = new HashMap();
    }
}

