/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.jdt;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import tools.mdsd.jamopp.model.java.classifiers.AnonymousClass;
import tools.mdsd.jamopp.model.java.classifiers.Class;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Enumeration;
import tools.mdsd.jamopp.model.java.classifiers.Interface;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.generics.TypeParameter;
import tools.mdsd.jamopp.model.java.literals.LiteralsFactory;
import tools.mdsd.jamopp.model.java.members.AdditionalField;
import tools.mdsd.jamopp.model.java.members.ClassMethod;
import tools.mdsd.jamopp.model.java.members.Constructor;
import tools.mdsd.jamopp.model.java.members.EnumConstant;
import tools.mdsd.jamopp.model.java.members.Field;
import tools.mdsd.jamopp.model.java.members.InterfaceMethod;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.parameters.OrdinaryParameter;
import tools.mdsd.jamopp.model.java.parameters.Parameter;
import tools.mdsd.jamopp.model.java.parameters.ParametersFactory;
import tools.mdsd.jamopp.model.java.parameters.ReceiverParameter;
import tools.mdsd.jamopp.model.java.parameters.VariableLengthParameter;
import tools.mdsd.jamopp.model.java.statements.Block;
import tools.mdsd.jamopp.model.java.statements.Statement;
import tools.mdsd.jamopp.model.java.statements.StatementsFactory;
import tools.mdsd.jamopp.model.java.types.ClassifierReference;
import tools.mdsd.jamopp.model.java.types.NamespaceClassifierReference;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.model.java.types.TypesFactory;
import tools.mdsd.jamopp.parser.jdt.AnnotationInstanceOrModifierConverterUtility;
import tools.mdsd.jamopp.parser.jdt.BaseConverterUtility;
import tools.mdsd.jamopp.parser.jdt.ExpressionConverterUtility;
import tools.mdsd.jamopp.parser.jdt.JDTResolverUtility;
import tools.mdsd.jamopp.parser.jdt.LayoutInformationConverter;
import tools.mdsd.jamopp.parser.jdt.TypeInstructionSeparationUtility;

class ClassifierConverterUtility {
    ClassifierConverterUtility() {
    }

    static ConcreteClassifier convertToConcreteClassifier(AbstractTypeDeclaration typeDecl) {
        ConcreteClassifier result = null;
        if (typeDecl.getNodeType() == 55) {
            result = ClassifierConverterUtility.convertToClassOrInterface((TypeDeclaration)typeDecl);
        } else if (typeDecl.getNodeType() == 81) {
            ConcreteClassifier fR = result = JDTResolverUtility.getAnnotation(typeDecl.resolveBinding());
            typeDecl.bodyDeclarations().forEach(obj -> fR.getMembers().add((Object)ClassifierConverterUtility.convertToInterfaceMember((BodyDeclaration)obj)));
        } else {
            result = ClassifierConverterUtility.convertToEnum((EnumDeclaration)typeDecl);
        }
        ConcreteClassifier finalResult = result;
        typeDecl.modifiers().forEach(obj -> finalResult.getAnnotationsAndModifiers().add((Object)AnnotationInstanceOrModifierConverterUtility.converToModifierOrAnnotationInstance((IExtendedModifier)obj)));
        BaseConverterUtility.convertToSimpleNameOnlyAndSet((Name)typeDecl.getName(), (NamedElement)result);
        LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)typeDecl);
        return result;
    }

    private static ConcreteClassifier convertToClassOrInterface(TypeDeclaration typeDecl) {
        if (typeDecl.isInterface()) {
            Interface interfaceObj = JDTResolverUtility.getInterface(typeDecl.resolveBinding());
            typeDecl.typeParameters().forEach(obj -> interfaceObj.getTypeParameters().add((Object)ClassifierConverterUtility.convertToTypeParameter((org.eclipse.jdt.core.dom.TypeParameter)obj)));
            typeDecl.superInterfaceTypes().forEach(obj -> interfaceObj.getExtends().add((Object)BaseConverterUtility.convertToTypeReference((Type)obj)));
            typeDecl.bodyDeclarations().forEach(obj -> interfaceObj.getMembers().add((Object)ClassifierConverterUtility.convertToInterfaceMember((BodyDeclaration)obj)));
            return interfaceObj;
        }
        Class classObj = JDTResolverUtility.getClass(typeDecl.resolveBinding());
        typeDecl.typeParameters().forEach(obj -> classObj.getTypeParameters().add((Object)ClassifierConverterUtility.convertToTypeParameter((org.eclipse.jdt.core.dom.TypeParameter)obj)));
        if (typeDecl.getSuperclassType() != null) {
            classObj.setExtends(BaseConverterUtility.convertToTypeReference(typeDecl.getSuperclassType()));
        }
        typeDecl.superInterfaceTypes().forEach(obj -> classObj.getImplements().add((Object)BaseConverterUtility.convertToTypeReference((Type)obj)));
        typeDecl.bodyDeclarations().forEach(obj -> classObj.getMembers().add((Object)ClassifierConverterUtility.convertToClassMember((BodyDeclaration)obj)));
        return classObj;
    }

    private static Enumeration convertToEnum(EnumDeclaration enumDecl) {
        Enumeration result = JDTResolverUtility.getEnumeration(enumDecl.resolveBinding());
        enumDecl.superInterfaceTypes().forEach(obj -> result.getImplements().add((Object)BaseConverterUtility.convertToTypeReference((Type)obj)));
        enumDecl.enumConstants().forEach(obj -> result.getConstants().add((Object)ClassifierConverterUtility.convertToEnumConstant((EnumConstantDeclaration)obj)));
        enumDecl.bodyDeclarations().forEach(obj -> result.getMembers().add((Object)ClassifierConverterUtility.convertToClassMember((BodyDeclaration)obj)));
        return result;
    }

    private static Member convertToInterfaceMember(BodyDeclaration body) {
        if (body.getNodeType() == 31) {
            return ClassifierConverterUtility.convertToInterfaceMethodOrConstructor((MethodDeclaration)body);
        }
        return ClassifierConverterUtility.convertToClassMember(body);
    }

    private static Member convertToClassMember(BodyDeclaration body) {
        if (body instanceof AbstractTypeDeclaration) {
            return ClassifierConverterUtility.convertToConcreteClassifier((AbstractTypeDeclaration)body);
        }
        if (body.getNodeType() == 28) {
            return ClassifierConverterUtility.convertToBlock((Initializer)body);
        }
        if (body.getNodeType() == 23) {
            return ClassifierConverterUtility.convertToField((FieldDeclaration)body);
        }
        if (body.getNodeType() == 31) {
            return ClassifierConverterUtility.convertToClassMethodOrConstructor((MethodDeclaration)body);
        }
        if (body.getNodeType() == 82) {
            return ClassifierConverterUtility.convertToInterfaceMethod((AnnotationTypeMemberDeclaration)body);
        }
        return null;
    }

    private static Block convertToBlock(Initializer init) {
        Block result = StatementsFactory.eINSTANCE.createBlock();
        result.setName("");
        TypeInstructionSeparationUtility.addInitializer(init.getBody(), result);
        init.modifiers().forEach(obj -> result.getModifiers().add((Object)AnnotationInstanceOrModifierConverterUtility.convertToModifier((Modifier)obj)));
        return result;
    }

    private static Field convertToField(FieldDeclaration fieldDecl) {
        VariableDeclarationFragment firstFragment = (VariableDeclarationFragment)fieldDecl.fragments().get(0);
        IVariableBinding binding = firstFragment.resolveBinding();
        Field result = binding != null ? JDTResolverUtility.getField(binding) : JDTResolverUtility.getField(firstFragment.getName().getIdentifier());
        BaseConverterUtility.convertToSimpleNameOnlyAndSet((Name)firstFragment.getName(), (NamedElement)result);
        fieldDecl.modifiers().forEach(obj -> result.getAnnotationsAndModifiers().add((Object)AnnotationInstanceOrModifierConverterUtility.converToModifierOrAnnotationInstance((IExtendedModifier)obj)));
        result.setTypeReference(BaseConverterUtility.convertToTypeReference(fieldDecl.getType()));
        if (firstFragment.getInitializer() != null) {
            TypeInstructionSeparationUtility.addField(firstFragment.getInitializer(), result);
        }
        for (int index = 1; index < fieldDecl.fragments().size(); ++index) {
            result.getAdditionalFields().add((Object)ClassifierConverterUtility.convertToAdditionalField((VariableDeclarationFragment)fieldDecl.fragments().get(index)));
        }
        LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)fieldDecl);
        return result;
    }

    private static AdditionalField convertToAdditionalField(VariableDeclarationFragment frag) {
        IVariableBinding binding = frag.resolveBinding();
        AdditionalField result = binding != null ? JDTResolverUtility.getAdditionalField(binding) : JDTResolverUtility.getAdditionalField(frag.getName().getIdentifier());
        BaseConverterUtility.convertToSimpleNameOnlyAndSet((Name)frag.getName(), (NamedElement)result);
        if (frag.getInitializer() != null) {
            TypeInstructionSeparationUtility.addAdditionalField(frag.getInitializer(), result);
        }
        LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)frag);
        return result;
    }

    private static InterfaceMethod convertToInterfaceMethod(AnnotationTypeMemberDeclaration annDecl) {
        IMethodBinding binding = annDecl.resolveBinding();
        InterfaceMethod result = binding != null ? JDTResolverUtility.getInterfaceMethod(binding) : JDTResolverUtility.getInterfaceMethod(annDecl.getName().getIdentifier());
        annDecl.modifiers().forEach(obj -> result.getAnnotationsAndModifiers().add((Object)AnnotationInstanceOrModifierConverterUtility.converToModifierOrAnnotationInstance((IExtendedModifier)obj)));
        result.setTypeReference(BaseConverterUtility.convertToTypeReference(annDecl.getType()));
        BaseConverterUtility.convertToSimpleNameOnlyAndSet((Name)annDecl.getName(), (NamedElement)result);
        if (annDecl.getDefault() != null) {
            TypeInstructionSeparationUtility.addAnnotationMethod(annDecl.getDefault(), result);
        }
        result.setStatement((Statement)StatementsFactory.eINSTANCE.createEmptyStatement());
        LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)annDecl);
        return result;
    }

    private static Member convertToInterfaceMethodOrConstructor(MethodDeclaration methodDecl) {
        if (methodDecl.isConstructor()) {
            return ClassifierConverterUtility.convertToClassMethodOrConstructor(methodDecl);
        }
        IMethodBinding binding = methodDecl.resolveBinding();
        InterfaceMethod result = binding == null ? JDTResolverUtility.getInterfaceMethod(methodDecl.getName().getIdentifier()) : JDTResolverUtility.getInterfaceMethod(binding);
        methodDecl.modifiers().forEach(obj -> result.getAnnotationsAndModifiers().add((Object)AnnotationInstanceOrModifierConverterUtility.converToModifierOrAnnotationInstance((IExtendedModifier)obj)));
        methodDecl.typeParameters().forEach(obj -> result.getTypeParameters().add((Object)ClassifierConverterUtility.convertToTypeParameter((org.eclipse.jdt.core.dom.TypeParameter)obj)));
        result.setTypeReference(BaseConverterUtility.convertToTypeReference(methodDecl.getReturnType2()));
        BaseConverterUtility.convertToSimpleNameOnlyAndSet((Name)methodDecl.getName(), (NamedElement)result);
        if (methodDecl.getReceiverType() != null) {
            result.getParameters().add((Object)ClassifierConverterUtility.convertToReceiverParameter(methodDecl));
        }
        methodDecl.parameters().forEach(obj -> result.getParameters().add((Object)ClassifierConverterUtility.convertToParameter((SingleVariableDeclaration)obj)));
        methodDecl.thrownExceptionTypes().forEach(obj -> result.getExceptions().add((Object)ClassifierConverterUtility.wrapInNamespaceClassifierReference(BaseConverterUtility.convertToTypeReference((Type)obj))));
        if (methodDecl.getBody() != null) {
            TypeInstructionSeparationUtility.addMethod(methodDecl.getBody(), (Method)result);
        } else {
            result.setStatement((Statement)StatementsFactory.eINSTANCE.createEmptyStatement());
        }
        LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)methodDecl);
        return result;
    }

    private static Member convertToClassMethodOrConstructor(MethodDeclaration methodDecl) {
        if (methodDecl.isConstructor()) {
            IMethodBinding binding = methodDecl.resolveBinding();
            Constructor result = binding == null ? JDTResolverUtility.getConstructor(methodDecl.getName().getIdentifier()) : JDTResolverUtility.getConstructor(binding);
            methodDecl.modifiers().forEach(obj -> result.getAnnotationsAndModifiers().add((Object)AnnotationInstanceOrModifierConverterUtility.converToModifierOrAnnotationInstance((IExtendedModifier)obj)));
            methodDecl.typeParameters().forEach(obj -> result.getTypeParameters().add((Object)ClassifierConverterUtility.convertToTypeParameter((org.eclipse.jdt.core.dom.TypeParameter)obj)));
            BaseConverterUtility.convertToSimpleNameOnlyAndSet((Name)methodDecl.getName(), (NamedElement)result);
            if (methodDecl.getReceiverType() != null) {
                result.getParameters().add((Object)ClassifierConverterUtility.convertToReceiverParameter(methodDecl));
            }
            methodDecl.parameters().forEach(obj -> result.getParameters().add((Object)ClassifierConverterUtility.convertToParameter((SingleVariableDeclaration)obj)));
            methodDecl.thrownExceptionTypes().forEach(obj -> result.getExceptions().add((Object)ClassifierConverterUtility.wrapInNamespaceClassifierReference(BaseConverterUtility.convertToTypeReference((Type)obj))));
            TypeInstructionSeparationUtility.addConstructor(methodDecl.getBody(), result);
            LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)methodDecl);
            return result;
        }
        IMethodBinding binding = methodDecl.resolveBinding();
        ClassMethod result = binding != null ? JDTResolverUtility.getClassMethod(binding) : JDTResolverUtility.getClassMethod(methodDecl.getName().getIdentifier());
        methodDecl.modifiers().forEach(obj -> result.getAnnotationsAndModifiers().add((Object)AnnotationInstanceOrModifierConverterUtility.converToModifierOrAnnotationInstance((IExtendedModifier)obj)));
        methodDecl.typeParameters().forEach(obj -> result.getTypeParameters().add((Object)ClassifierConverterUtility.convertToTypeParameter((org.eclipse.jdt.core.dom.TypeParameter)obj)));
        result.setTypeReference(BaseConverterUtility.convertToTypeReference(methodDecl.getReturnType2()));
        BaseConverterUtility.convertToSimpleNameOnlyAndSet((Name)methodDecl.getName(), (NamedElement)result);
        if (methodDecl.getReceiverType() != null) {
            result.getParameters().add((Object)ClassifierConverterUtility.convertToReceiverParameter(methodDecl));
        }
        methodDecl.parameters().forEach(obj -> result.getParameters().add((Object)ClassifierConverterUtility.convertToParameter((SingleVariableDeclaration)obj)));
        methodDecl.thrownExceptionTypes().forEach(obj -> result.getExceptions().add((Object)ClassifierConverterUtility.wrapInNamespaceClassifierReference(BaseConverterUtility.convertToTypeReference((Type)obj))));
        if (methodDecl.getBody() != null) {
            TypeInstructionSeparationUtility.addMethod(methodDecl.getBody(), (Method)result);
        } else {
            result.setStatement((Statement)StatementsFactory.eINSTANCE.createEmptyStatement());
        }
        LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)methodDecl);
        return result;
    }

    private static NamespaceClassifierReference wrapInNamespaceClassifierReference(TypeReference ref) {
        if (ref instanceof NamespaceClassifierReference) {
            return (NamespaceClassifierReference)ref;
        }
        if (ref instanceof ClassifierReference) {
            NamespaceClassifierReference result = TypesFactory.eINSTANCE.createNamespaceClassifierReference();
            result.getClassifierReferences().add((Object)((ClassifierReference)ref));
            return result;
        }
        return null;
    }

    private static EnumConstant convertToEnumConstant(EnumConstantDeclaration enDecl) {
        IVariableBinding binding = enDecl.resolveVariable();
        EnumConstant result = binding == null ? JDTResolverUtility.getEnumConstant(enDecl.getName().getIdentifier()) : JDTResolverUtility.getEnumConstant(binding);
        enDecl.modifiers().forEach(obj -> result.getAnnotations().add((Object)AnnotationInstanceOrModifierConverterUtility.convertToAnnotationInstance((Annotation)obj)));
        BaseConverterUtility.convertToSimpleNameOnlyAndSet((Name)enDecl.getName(), (NamedElement)result);
        enDecl.arguments().forEach(obj -> result.getArguments().add((Object)ExpressionConverterUtility.convertToExpression((Expression)obj)));
        if (enDecl.getAnonymousClassDeclaration() != null) {
            result.setAnonymousClass(ClassifierConverterUtility.convertToAnonymousClass(enDecl.getAnonymousClassDeclaration()));
        }
        LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)enDecl);
        return result;
    }

    private static TypeParameter convertToTypeParameter(org.eclipse.jdt.core.dom.TypeParameter param) {
        TypeParameter result = JDTResolverUtility.getTypeParameter(param.resolveBinding());
        param.modifiers().forEach(obj -> result.getAnnotations().add((Object)AnnotationInstanceOrModifierConverterUtility.convertToAnnotationInstance((Annotation)obj)));
        BaseConverterUtility.convertToSimpleNameOnlyAndSet((Name)param.getName(), (NamedElement)result);
        param.typeBounds().forEach(obj -> result.getExtendTypes().add((Object)BaseConverterUtility.convertToTypeReference((Type)obj)));
        LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)param);
        return result;
    }

    static AnonymousClass convertToAnonymousClass(AnonymousClassDeclaration anon) {
        ITypeBinding binding = anon.resolveBinding();
        AnonymousClass result = binding != null ? JDTResolverUtility.getAnonymousClass(binding) : JDTResolverUtility.getAnonymousClass("" + anon.hashCode());
        anon.bodyDeclarations().forEach(obj -> result.getMembers().add((Object)ClassifierConverterUtility.convertToClassMember((BodyDeclaration)obj)));
        LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)anon);
        return result;
    }

    private static ReceiverParameter convertToReceiverParameter(MethodDeclaration methodDecl) {
        ReceiverParameter result = ParametersFactory.eINSTANCE.createReceiverParameter();
        result.setName("");
        result.setTypeReference(BaseConverterUtility.convertToTypeReference(methodDecl.getReceiverType()));
        if (methodDecl.getReceiverQualifier() != null) {
            result.setOuterTypeReference((TypeReference)BaseConverterUtility.convertToClassifierReference(methodDecl.getReceiverQualifier()));
        }
        result.setThisReference(LiteralsFactory.eINSTANCE.createThis());
        return result;
    }

    private static Parameter convertToParameter(SingleVariableDeclaration decl) {
        if (decl.isVarargs()) {
            VariableLengthParameter result = JDTResolverUtility.getVariableLengthParameter(decl.resolveBinding());
            decl.modifiers().forEach(obj -> result.getAnnotationsAndModifiers().add((Object)AnnotationInstanceOrModifierConverterUtility.converToModifierOrAnnotationInstance((IExtendedModifier)obj)));
            result.setTypeReference(BaseConverterUtility.convertToTypeReference(decl.getType()));
            BaseConverterUtility.convertToSimpleNameOnlyAndSet((Name)decl.getName(), (NamedElement)result);
            decl.varargsAnnotations().forEach(obj -> result.getAnnotations().add((Object)AnnotationInstanceOrModifierConverterUtility.convertToAnnotationInstance((Annotation)obj)));
            LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)decl);
            return result;
        }
        return ClassifierConverterUtility.convertToOrdinaryParameter(decl);
    }

    static OrdinaryParameter convertToOrdinaryParameter(SingleVariableDeclaration decl) {
        OrdinaryParameter result = JDTResolverUtility.getOrdinaryParameter(decl.resolveBinding());
        decl.modifiers().forEach(obj -> result.getAnnotationsAndModifiers().add((Object)AnnotationInstanceOrModifierConverterUtility.converToModifierOrAnnotationInstance((IExtendedModifier)obj)));
        result.setTypeReference(BaseConverterUtility.convertToTypeReference(decl.getType()));
        BaseConverterUtility.convertToSimpleNameOnlyAndSet((Name)decl.getName(), (NamedElement)result);
        LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)decl);
        return result;
    }
}

