/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.jdt;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.WildcardType;
import tools.mdsd.jamopp.model.java.arrays.ArrayDimension;
import tools.mdsd.jamopp.model.java.arrays.ArrayTypeable;
import tools.mdsd.jamopp.model.java.arrays.ArraysFactory;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.commons.NamespaceAwareElement;
import tools.mdsd.jamopp.model.java.generics.ExtendsTypeArgument;
import tools.mdsd.jamopp.model.java.generics.GenericsFactory;
import tools.mdsd.jamopp.model.java.generics.QualifiedTypeArgument;
import tools.mdsd.jamopp.model.java.generics.SuperTypeArgument;
import tools.mdsd.jamopp.model.java.generics.TypeArgument;
import tools.mdsd.jamopp.model.java.generics.UnknownTypeArgument;
import tools.mdsd.jamopp.model.java.types.ClassifierReference;
import tools.mdsd.jamopp.model.java.types.InferableType;
import tools.mdsd.jamopp.model.java.types.NamespaceClassifierReference;
import tools.mdsd.jamopp.model.java.types.PrimitiveType;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.model.java.types.TypesFactory;
import tools.mdsd.jamopp.parser.jdt.AnnotationInstanceOrModifierConverterUtility;
import tools.mdsd.jamopp.parser.jdt.JDTBindingConverterUtility;
import tools.mdsd.jamopp.parser.jdt.JDTResolverUtility;
import tools.mdsd.jamopp.parser.jdt.LayoutInformationConverter;

class BaseConverterUtility {
    BaseConverterUtility() {
    }

    static TypeReference convertToClassifierOrNamespaceClassifierReference(Name name) {
        if (name.isSimpleName()) {
            return BaseConverterUtility.convertToClassifierReference((SimpleName)name);
        }
        QualifiedName qualifiedName = (QualifiedName)name;
        NamespaceClassifierReference ref = TypesFactory.eINSTANCE.createNamespaceClassifierReference();
        if (name.resolveBinding() == null) {
            ref.getClassifierReferences().add((Object)BaseConverterUtility.convertToClassifierReference(qualifiedName.getName()));
            BaseConverterUtility.convertToNamespacesAndSet(qualifiedName.getQualifier(), (NamespaceAwareElement)ref);
            return ref;
        }
        Name qualifier = qualifiedName.getQualifier();
        SimpleName simpleName = qualifiedName.getName();
        while (simpleName != null && simpleName.resolveBinding() instanceof ITypeBinding) {
            ref.getClassifierReferences().add(0, (Object)BaseConverterUtility.convertToClassifierReference(simpleName));
            if (qualifier == null) {
                simpleName = null;
                continue;
            }
            if (qualifier.isSimpleName()) {
                simpleName = (SimpleName)qualifier;
                qualifier = null;
                continue;
            }
            simpleName = ((QualifiedName)qualifier).getName();
            qualifier = ((QualifiedName)qualifier).getQualifier();
        }
        if (simpleName != null && !(simpleName.resolveBinding() instanceof ITypeBinding)) {
            BaseConverterUtility.convertToNamespacesAndSet((Name)simpleName, (NamespaceAwareElement)ref);
        }
        if (qualifier != null) {
            BaseConverterUtility.convertToNamespacesAndSet(qualifier, (NamespaceAwareElement)ref);
        }
        return ref;
    }

    static ClassifierReference convertToClassifierReference(SimpleName simpleName) {
        ClassifierReference ref = TypesFactory.eINSTANCE.createClassifierReference();
        ITypeBinding binding = (ITypeBinding)simpleName.resolveBinding();
        Object proxy = binding == null || binding.isRecovered() ? JDTResolverUtility.getClass(simpleName.getIdentifier()) : JDTResolverUtility.getClassifier(binding);
        proxy.setName(simpleName.getIdentifier());
        ref.setTarget((Classifier)proxy);
        return ref;
    }

    static void convertToNamespacesAndSimpleNameAndSet(Name name, NamespaceAwareElement namespaceElement, NamedElement namedElement) {
        if (name.isSimpleName()) {
            namedElement.setName(((SimpleName)name).getIdentifier());
        } else if (name.isQualifiedName()) {
            QualifiedName qualifiedName = (QualifiedName)name;
            namedElement.setName(qualifiedName.getName().getIdentifier());
            BaseConverterUtility.convertToNamespacesAndSet(qualifiedName.getQualifier(), namespaceElement);
        }
    }

    static void convertToNamespacesAndSet(Name name, NamespaceAwareElement namespaceElement) {
        if (name.isSimpleName()) {
            SimpleName simpleName = (SimpleName)name;
            namespaceElement.getNamespaces().add(0, (Object)simpleName.getIdentifier());
        } else if (name.isQualifiedName()) {
            QualifiedName qualifiedName = (QualifiedName)name;
            namespaceElement.getNamespaces().add(0, (Object)qualifiedName.getName().getIdentifier());
            BaseConverterUtility.convertToNamespacesAndSet(qualifiedName.getQualifier(), namespaceElement);
        }
    }

    static void convertToSimpleNameOnlyAndSet(Name name, NamedElement namedElement) {
        if (name.isSimpleName()) {
            SimpleName simpleName = (SimpleName)name;
            namedElement.setName(simpleName.getIdentifier());
        } else {
            QualifiedName qualifiedName = (QualifiedName)name;
            namedElement.setName(qualifiedName.getName().getIdentifier());
        }
    }

    static TypeReference convertToTypeReference(Type t) {
        if (t.isPrimitiveType()) {
            org.eclipse.jdt.core.dom.PrimitiveType primType = (org.eclipse.jdt.core.dom.PrimitiveType)t;
            Object convertedType = primType.getPrimitiveTypeCode() == org.eclipse.jdt.core.dom.PrimitiveType.BOOLEAN ? TypesFactory.eINSTANCE.createBoolean() : (primType.getPrimitiveTypeCode() == org.eclipse.jdt.core.dom.PrimitiveType.BYTE ? TypesFactory.eINSTANCE.createByte() : (primType.getPrimitiveTypeCode() == org.eclipse.jdt.core.dom.PrimitiveType.CHAR ? TypesFactory.eINSTANCE.createChar() : (primType.getPrimitiveTypeCode() == org.eclipse.jdt.core.dom.PrimitiveType.DOUBLE ? TypesFactory.eINSTANCE.createDouble() : (primType.getPrimitiveTypeCode() == org.eclipse.jdt.core.dom.PrimitiveType.FLOAT ? TypesFactory.eINSTANCE.createFloat() : (primType.getPrimitiveTypeCode() == org.eclipse.jdt.core.dom.PrimitiveType.INT ? TypesFactory.eINSTANCE.createInt() : (primType.getPrimitiveTypeCode() == org.eclipse.jdt.core.dom.PrimitiveType.LONG ? TypesFactory.eINSTANCE.createLong() : (primType.getPrimitiveTypeCode() == org.eclipse.jdt.core.dom.PrimitiveType.SHORT ? TypesFactory.eINSTANCE.createShort() : TypesFactory.eINSTANCE.createVoid())))))));
            primType.annotations().forEach(arg_0 -> BaseConverterUtility.lambda$convertToTypeReference$0((PrimitiveType)convertedType, arg_0));
            LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)convertedType, (ASTNode)primType);
            return convertedType;
        }
        if (t.isVar()) {
            InferableType ref = TypesFactory.eINSTANCE.createInferableType();
            ITypeBinding binding = t.resolveBinding();
            if (binding != null) {
                ref.getActualTargets().addAll(JDTBindingConverterUtility.convertToTypeReferences(binding));
                if (binding.isArray()) {
                    JDTBindingConverterUtility.convertToArrayDimensionsAndSet(binding, (ArrayTypeable)ref);
                } else if (binding.isIntersectionType() && binding.getTypeBounds()[0].isArray()) {
                    JDTBindingConverterUtility.convertToArrayDimensionsAndSet(binding.getTypeBounds()[0], (ArrayTypeable)ref);
                }
            }
            LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)ref, (ASTNode)t);
            return ref;
        }
        if (t.isArrayType()) {
            ArrayType arrT = (ArrayType)t;
            return BaseConverterUtility.convertToTypeReference(arrT.getElementType());
        }
        if (t.isSimpleType()) {
            TypeReference ref;
            SimpleType simT = (SimpleType)t;
            if (simT.annotations().size() > 0) {
                ClassifierReference tempRef = BaseConverterUtility.convertToClassifierReference((SimpleName)simT.getName());
                simT.annotations().forEach(obj -> tempRef.getAnnotations().add((Object)AnnotationInstanceOrModifierConverterUtility.convertToAnnotationInstance((Annotation)obj)));
                ref = tempRef;
            } else {
                ref = BaseConverterUtility.convertToClassifierOrNamespaceClassifierReference(simT.getName());
            }
            LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)ref, (ASTNode)simT);
            return ref;
        }
        if (t.isQualifiedType()) {
            NamespaceClassifierReference result;
            QualifiedType qualType = (QualifiedType)t;
            TypeReference parentRef = BaseConverterUtility.convertToTypeReference(qualType.getQualifier());
            if (parentRef instanceof ClassifierReference) {
                result = TypesFactory.eINSTANCE.createNamespaceClassifierReference();
                result.getClassifierReferences().add((Object)((ClassifierReference)parentRef));
            } else {
                result = (NamespaceClassifierReference)parentRef;
            }
            ClassifierReference childRef = BaseConverterUtility.convertToClassifierReference(qualType.getName());
            qualType.annotations().forEach(obj -> childRef.getAnnotations().add((Object)AnnotationInstanceOrModifierConverterUtility.convertToAnnotationInstance((Annotation)obj)));
            result.getClassifierReferences().add((Object)childRef);
            LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)qualType);
            return result;
        }
        if (t.isNameQualifiedType()) {
            NamespaceClassifierReference result;
            NameQualifiedType nqT = (NameQualifiedType)t;
            TypeReference parentRef = BaseConverterUtility.convertToClassifierOrNamespaceClassifierReference(nqT.getQualifier());
            if (parentRef instanceof ClassifierReference) {
                result = TypesFactory.eINSTANCE.createNamespaceClassifierReference();
                result.getClassifierReferences().add((Object)((ClassifierReference)parentRef));
            } else {
                result = (NamespaceClassifierReference)parentRef;
            }
            ClassifierReference child = BaseConverterUtility.convertToClassifierReference(nqT.getName());
            nqT.annotations().forEach(obj -> child.getAnnotations().add((Object)AnnotationInstanceOrModifierConverterUtility.convertToAnnotationInstance((Annotation)obj)));
            result.getClassifierReferences().add((Object)child);
            LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)nqT);
            return result;
        }
        if (t.isParameterizedType()) {
            ClassifierReference container;
            ParameterizedType paramT = (ParameterizedType)t;
            TypeReference ref = BaseConverterUtility.convertToTypeReference(paramT.getType());
            if (ref instanceof ClassifierReference) {
                container = (ClassifierReference)ref;
            } else {
                NamespaceClassifierReference containerContainer = (NamespaceClassifierReference)ref;
                container = (ClassifierReference)containerContainer.getClassifierReferences().get(containerContainer.getClassifierReferences().size() - 1);
            }
            paramT.typeArguments().forEach(obj -> container.getTypeArguments().add((Object)BaseConverterUtility.convertToTypeArgument((Type)obj)));
            return ref;
        }
        return null;
    }

    static TypeArgument convertToTypeArgument(Type t) {
        if (t.isWildcardType()) {
            WildcardType wildType = (WildcardType)t;
            if (wildType.getBound() == null) {
                UnknownTypeArgument result = GenericsFactory.eINSTANCE.createUnknownTypeArgument();
                wildType.annotations().forEach(obj -> result.getAnnotations().add((Object)AnnotationInstanceOrModifierConverterUtility.convertToAnnotationInstance((Annotation)obj)));
                LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)wildType);
                return result;
            }
            if (wildType.isUpperBound()) {
                ExtendsTypeArgument result = GenericsFactory.eINSTANCE.createExtendsTypeArgument();
                wildType.annotations().forEach(obj -> result.getAnnotations().add((Object)AnnotationInstanceOrModifierConverterUtility.convertToAnnotationInstance((Annotation)obj)));
                result.setExtendType(BaseConverterUtility.convertToTypeReference(wildType.getBound()));
                BaseConverterUtility.convertToArrayDimensionsAndSet(wildType.getBound(), (ArrayTypeable)result);
                LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)wildType);
                return result;
            }
            SuperTypeArgument result = GenericsFactory.eINSTANCE.createSuperTypeArgument();
            wildType.annotations().forEach(obj -> result.getAnnotations().add((Object)AnnotationInstanceOrModifierConverterUtility.convertToAnnotationInstance((Annotation)obj)));
            result.setSuperType(BaseConverterUtility.convertToTypeReference(wildType.getBound()));
            BaseConverterUtility.convertToArrayDimensionsAndSet(wildType.getBound(), (ArrayTypeable)result);
            LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)wildType);
            return result;
        }
        QualifiedTypeArgument result = GenericsFactory.eINSTANCE.createQualifiedTypeArgument();
        result.setTypeReference(BaseConverterUtility.convertToTypeReference(t));
        BaseConverterUtility.convertToArrayDimensionsAndSet(t, (ArrayTypeable)result);
        LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)t);
        return result;
    }

    static void convertToArrayDimensionsAndSet(Type t, ArrayTypeable arrDimContainer) {
        BaseConverterUtility.convertToArrayDimensionsAndSet(t, arrDimContainer, 0);
    }

    static void convertToArrayDimensionsAndSet(Type t, ArrayTypeable arrDimContainer, int ignoreDimensions) {
        if (t.isArrayType()) {
            ArrayType arrT = (ArrayType)t;
            for (int i = ignoreDimensions; i < arrT.dimensions().size(); ++i) {
                arrDimContainer.getArrayDimensionsBefore().add((Object)BaseConverterUtility.convertToArrayDimension((Dimension)arrT.dimensions().get(i)));
            }
        }
    }

    static void convertToArrayDimensionAfterAndSet(Dimension dim, ArrayTypeable arrDimContainer) {
        arrDimContainer.getArrayDimensionsAfter().add((Object)BaseConverterUtility.convertToArrayDimension(dim));
    }

    private static ArrayDimension convertToArrayDimension(Dimension dim) {
        ArrayDimension result = ArraysFactory.eINSTANCE.createArrayDimension();
        dim.annotations().forEach(annot -> result.getAnnotations().add((Object)AnnotationInstanceOrModifierConverterUtility.convertToAnnotationInstance((Annotation)annot)));
        LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)dim);
        return result;
    }

    private static /* synthetic */ void lambda$convertToTypeReference$0(PrimitiveType convertedType, Object obj) {
        convertedType.getAnnotations().add((Object)AnnotationInstanceOrModifierConverterUtility.convertToAnnotationInstance((Annotation)obj));
    }
}

