/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.jdt.singlefile;

import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import tools.mdsd.jamopp.model.java.arrays.ArrayTypeable;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.expressions.Expression;
import tools.mdsd.jamopp.model.java.expressions.ExpressionList;
import tools.mdsd.jamopp.model.java.expressions.ExpressionsFactory;
import tools.mdsd.jamopp.model.java.parameters.CatchParameter;
import tools.mdsd.jamopp.model.java.parameters.OrdinaryParameter;
import tools.mdsd.jamopp.model.java.parameters.ParametersFactory;
import tools.mdsd.jamopp.model.java.references.ElementReference;
import tools.mdsd.jamopp.model.java.statements.Assert;
import tools.mdsd.jamopp.model.java.statements.Block;
import tools.mdsd.jamopp.model.java.statements.Break;
import tools.mdsd.jamopp.model.java.statements.CatchBlock;
import tools.mdsd.jamopp.model.java.statements.Condition;
import tools.mdsd.jamopp.model.java.statements.Continue;
import tools.mdsd.jamopp.model.java.statements.DefaultSwitchRule;
import tools.mdsd.jamopp.model.java.statements.DoWhileLoop;
import tools.mdsd.jamopp.model.java.statements.EmptyStatement;
import tools.mdsd.jamopp.model.java.statements.ExpressionStatement;
import tools.mdsd.jamopp.model.java.statements.ForEachLoop;
import tools.mdsd.jamopp.model.java.statements.ForLoop;
import tools.mdsd.jamopp.model.java.statements.ForLoopInitializer;
import tools.mdsd.jamopp.model.java.statements.JumpLabel;
import tools.mdsd.jamopp.model.java.statements.LocalVariableStatement;
import tools.mdsd.jamopp.model.java.statements.NormalSwitchCase;
import tools.mdsd.jamopp.model.java.statements.NormalSwitchRule;
import tools.mdsd.jamopp.model.java.statements.Return;
import tools.mdsd.jamopp.model.java.statements.StatementsFactory;
import tools.mdsd.jamopp.model.java.statements.Switch;
import tools.mdsd.jamopp.model.java.statements.SwitchRule;
import tools.mdsd.jamopp.model.java.statements.SynchronizedBlock;
import tools.mdsd.jamopp.model.java.statements.Throw;
import tools.mdsd.jamopp.model.java.statements.TryBlock;
import tools.mdsd.jamopp.model.java.statements.WhileLoop;
import tools.mdsd.jamopp.model.java.statements.YieldStatement;
import tools.mdsd.jamopp.model.java.variables.AdditionalLocalVariable;
import tools.mdsd.jamopp.model.java.variables.LocalVariable;
import tools.mdsd.jamopp.model.java.variables.VariablesFactory;
import tools.mdsd.jamopp.parser.jdt.singlefile.AnnotationInstanceOrModifierConverterUtility;
import tools.mdsd.jamopp.parser.jdt.singlefile.BaseConverterUtility;
import tools.mdsd.jamopp.parser.jdt.singlefile.ClassifierConverterUtility;
import tools.mdsd.jamopp.parser.jdt.singlefile.ExpressionConverterUtility;
import tools.mdsd.jamopp.parser.jdt.singlefile.LayoutInformationConverter;
import tools.mdsd.jamopp.parser.jdt.singlefile.ReferenceConverterUtility;

class StatementConverterUtility {
    private static HashSet<JumpLabel> currentJumpLabels = new HashSet();

    StatementConverterUtility() {
    }

    static Block convertToBlock(org.eclipse.jdt.core.dom.Block block) {
        Block result = StatementsFactory.eINSTANCE.createBlock();
        result.setName("");
        block.statements().forEach(obj -> result.getStatements().add((Object)StatementConverterUtility.convertToStatement((Statement)obj)));
        LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)block);
        return result;
    }

    static tools.mdsd.jamopp.model.java.statements.Statement convertToStatement(Statement statement) {
        if (statement.getNodeType() == 6) {
            AssertStatement assertSt = (AssertStatement)statement;
            Assert result = StatementsFactory.eINSTANCE.createAssert();
            result.setCondition(ExpressionConverterUtility.convertToExpression(assertSt.getExpression()));
            if (assertSt.getMessage() != null) {
                result.setErrorMessage(ExpressionConverterUtility.convertToExpression(assertSt.getMessage()));
            }
            LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)assertSt);
            return result;
        }
        if (statement.getNodeType() == 8) {
            return StatementConverterUtility.convertToBlock((org.eclipse.jdt.core.dom.Block)statement);
        }
        if (statement.getNodeType() == 10) {
            BreakStatement breakSt = (BreakStatement)statement;
            Break result = StatementsFactory.eINSTANCE.createBreak();
            if (breakSt.getLabel() != null) {
                JumpLabel proxyTarget = currentJumpLabels.stream().filter(label -> label.getName().equals(breakSt.getLabel().getIdentifier())).findFirst().get();
                result.setTarget(proxyTarget);
            }
            LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)breakSt);
            return result;
        }
        if (statement.getNodeType() == 18) {
            ContinueStatement conSt = (ContinueStatement)statement;
            Continue result = StatementsFactory.eINSTANCE.createContinue();
            if (conSt.getLabel() != null) {
                JumpLabel proxyTarget = currentJumpLabels.stream().filter(label -> label.getName().equals(conSt.getLabel().getIdentifier())).findFirst().get();
                result.setTarget(proxyTarget);
            }
            LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)conSt);
            return result;
        }
        if (statement.getNodeType() == 19) {
            DoStatement doSt = (DoStatement)statement;
            DoWhileLoop result = StatementsFactory.eINSTANCE.createDoWhileLoop();
            result.setCondition(ExpressionConverterUtility.convertToExpression(doSt.getExpression()));
            result.setStatement(StatementConverterUtility.convertToStatement(doSt.getBody()));
            LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)doSt);
            return result;
        }
        if (statement.getNodeType() == 20) {
            EmptyStatement result = StatementsFactory.eINSTANCE.createEmptyStatement();
            LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)statement);
            return result;
        }
        if (statement.getNodeType() == 70) {
            EnhancedForStatement forSt = (EnhancedForStatement)statement;
            ForEachLoop result = StatementsFactory.eINSTANCE.createForEachLoop();
            result.setNext(ClassifierConverterUtility.convertToOrdinaryParameter(forSt.getParameter()));
            result.setCollection(ExpressionConverterUtility.convertToExpression(forSt.getExpression()));
            result.setStatement(StatementConverterUtility.convertToStatement(forSt.getBody()));
            LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)forSt);
            return result;
        }
        if (statement.getNodeType() == 21) {
            org.eclipse.jdt.core.dom.ExpressionStatement exprSt = (org.eclipse.jdt.core.dom.ExpressionStatement)statement;
            if (exprSt.getExpression().getNodeType() == 58) {
                LocalVariableStatement result = StatementsFactory.eINSTANCE.createLocalVariableStatement();
                result.setVariable(StatementConverterUtility.convertToLocalVariable((VariableDeclarationExpression)exprSt.getExpression()));
                LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)exprSt);
                return result;
            }
            ExpressionStatement result = StatementsFactory.eINSTANCE.createExpressionStatement();
            result.setExpression(ExpressionConverterUtility.convertToExpression(exprSt.getExpression()));
            LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)exprSt);
            return result;
        }
        if (statement.getNodeType() == 24) {
            ForStatement forSt = (ForStatement)statement;
            ForLoop result = StatementsFactory.eINSTANCE.createForLoop();
            if (forSt.initializers().size() == 1 && forSt.initializers().get(0) instanceof VariableDeclarationExpression) {
                result.setInit((ForLoopInitializer)StatementConverterUtility.convertToLocalVariable((VariableDeclarationExpression)forSt.initializers().get(0)));
            } else {
                ExpressionList ini = ExpressionsFactory.eINSTANCE.createExpressionList();
                forSt.initializers().forEach(obj -> ini.getExpressions().add((Object)ExpressionConverterUtility.convertToExpression((org.eclipse.jdt.core.dom.Expression)obj)));
                result.setInit((ForLoopInitializer)ini);
            }
            if (forSt.getExpression() != null) {
                result.setCondition(ExpressionConverterUtility.convertToExpression(forSt.getExpression()));
            }
            forSt.updaters().forEach(obj -> result.getUpdates().add((Object)ExpressionConverterUtility.convertToExpression((org.eclipse.jdt.core.dom.Expression)obj)));
            result.setStatement(StatementConverterUtility.convertToStatement(forSt.getBody()));
            LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)forSt);
            return result;
        }
        if (statement.getNodeType() == 25) {
            IfStatement ifSt = (IfStatement)statement;
            Condition result = StatementsFactory.eINSTANCE.createCondition();
            result.setCondition(ExpressionConverterUtility.convertToExpression(ifSt.getExpression()));
            result.setStatement(StatementConverterUtility.convertToStatement(ifSt.getThenStatement()));
            if (ifSt.getElseStatement() != null) {
                result.setElseStatement(StatementConverterUtility.convertToStatement(ifSt.getElseStatement()));
            }
            LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)ifSt);
            return result;
        }
        if (statement.getNodeType() == 30) {
            LabeledStatement labelSt = (LabeledStatement)statement;
            JumpLabel result = StatementsFactory.eINSTANCE.createJumpLabel();
            BaseConverterUtility.convertToSimpleNameOnlyAndSet((Name)labelSt.getLabel(), (NamedElement)result);
            currentJumpLabels.add(result);
            result.setStatement(StatementConverterUtility.convertToStatement(labelSt.getBody()));
            currentJumpLabels.remove(result);
            LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)labelSt);
            return result;
        }
        if (statement.getNodeType() == 41) {
            ReturnStatement retSt = (ReturnStatement)statement;
            Return result = StatementsFactory.eINSTANCE.createReturn();
            if (retSt.getExpression() != null) {
                result.setReturnValue(ExpressionConverterUtility.convertToExpression(retSt.getExpression()));
            }
            LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)retSt);
            return result;
        }
        if (statement.getNodeType() == 50) {
            return StatementConverterUtility.convertToSwitch((SwitchStatement)statement);
        }
        if (statement.getNodeType() == 51) {
            SynchronizedStatement synSt = (SynchronizedStatement)statement;
            SynchronizedBlock result = StatementsFactory.eINSTANCE.createSynchronizedBlock();
            result.setLockProvider(ExpressionConverterUtility.convertToExpression(synSt.getExpression()));
            result.setBlock(StatementConverterUtility.convertToBlock(synSt.getBody()));
            LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)synSt);
            return result;
        }
        if (statement.getNodeType() == 53) {
            ThrowStatement throwSt = (ThrowStatement)statement;
            Throw result = StatementsFactory.eINSTANCE.createThrow();
            result.setThrowable(ExpressionConverterUtility.convertToExpression(throwSt.getExpression()));
            LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)throwSt);
            return result;
        }
        if (statement.getNodeType() == 54) {
            TryStatement trySt = (TryStatement)statement;
            TryBlock result = StatementsFactory.eINSTANCE.createTryBlock();
            trySt.resources().forEach(obj -> {
                org.eclipse.jdt.core.dom.Expression resExpr = (org.eclipse.jdt.core.dom.Expression)obj;
                if (resExpr instanceof VariableDeclarationExpression) {
                    result.getResources().add((Object)StatementConverterUtility.convertToLocalVariable((VariableDeclarationExpression)resExpr));
                } else {
                    result.getResources().add((Object)((ElementReference)ReferenceConverterUtility.convertToReference(resExpr)));
                }
            });
            result.setBlock(StatementConverterUtility.convertToBlock(trySt.getBody()));
            trySt.catchClauses().forEach(obj -> result.getCatchBlocks().add((Object)StatementConverterUtility.convertToCatchBlock((CatchClause)obj)));
            if (trySt.getFinally() != null) {
                result.setFinallyBlock(StatementConverterUtility.convertToBlock(trySt.getFinally()));
            }
            LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)trySt);
            return result;
        }
        if (statement.getNodeType() == 56) {
            TypeDeclarationStatement declSt = (TypeDeclarationStatement)statement;
            return ClassifierConverterUtility.convertToConcreteClassifier(declSt.getDeclaration());
        }
        if (statement.getNodeType() == 60) {
            VariableDeclarationStatement varSt = (VariableDeclarationStatement)statement;
            LocalVariableStatement result = StatementsFactory.eINSTANCE.createLocalVariableStatement();
            LocalVariable locVar = VariablesFactory.eINSTANCE.createLocalVariable();
            varSt.modifiers().forEach(obj -> locVar.getAnnotationsAndModifiers().add((Object)AnnotationInstanceOrModifierConverterUtility.converToModifierOrAnnotationInstance((IExtendedModifier)obj)));
            locVar.setTypeReference(BaseConverterUtility.convertToTypeReference(varSt.getType()));
            VariableDeclarationFragment frag = (VariableDeclarationFragment)varSt.fragments().get(0);
            BaseConverterUtility.convertToSimpleNameOnlyAndSet((Name)frag.getName(), (NamedElement)locVar);
            BaseConverterUtility.convertToArrayDimensionsAndSet(varSt.getType(), (ArrayTypeable)locVar.getTypeReference());
            frag.extraDimensions().forEach(obj -> BaseConverterUtility.convertToArrayDimensionAfterAndSet((Dimension)obj, (ArrayTypeable)locVar.getTypeReference()));
            if (frag.getInitializer() != null) {
                locVar.setInitialValue(ExpressionConverterUtility.convertToExpression(frag.getInitializer()));
            }
            for (int index = 1; index < varSt.fragments().size(); ++index) {
                locVar.getAdditionalLocalVariables().add((Object)StatementConverterUtility.convertToAdditionalLocalVariable((VariableDeclarationFragment)varSt.fragments().get(index), varSt.getType()));
            }
            result.setVariable(locVar);
            LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)varSt);
            return result;
        }
        if (statement.getNodeType() == 61) {
            WhileStatement whileSt = (WhileStatement)statement;
            WhileLoop result = StatementsFactory.eINSTANCE.createWhileLoop();
            result.setCondition(ExpressionConverterUtility.convertToExpression(whileSt.getExpression()));
            result.setStatement(StatementConverterUtility.convertToStatement(whileSt.getBody()));
            LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)whileSt);
            return result;
        }
        if (statement.getNodeType() == 101) {
            org.eclipse.jdt.core.dom.YieldStatement yieldSt = (org.eclipse.jdt.core.dom.YieldStatement)statement;
            YieldStatement result = StatementsFactory.eINSTANCE.createYieldStatement();
            if (yieldSt.getExpression() != null) {
                result.setYieldExpression(ExpressionConverterUtility.convertToExpression(yieldSt.getExpression()));
            }
            LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)yieldSt);
            return result;
        }
        ExpressionStatement result = StatementsFactory.eINSTANCE.createExpressionStatement();
        result.setExpression((Expression)ReferenceConverterUtility.convertToReference(statement));
        return result;
    }

    private static Switch convertToSwitch(SwitchStatement switchSt) {
        Switch result = StatementsFactory.eINSTANCE.createSwitch();
        result.setVariable(ExpressionConverterUtility.convertToExpression(switchSt.getExpression()));
        StatementConverterUtility.convertToSwitchCasesAndSet(result, switchSt.statements());
        LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)switchSt);
        return result;
    }

    static void convertToSwitchCasesAndSet(Switch switchExprSt, List switchStatementList) {
        tools.mdsd.jamopp.model.java.statements.SwitchCase currentCase = null;
        for (int index = 0; index < switchStatementList.size(); ++index) {
            Statement st = (Statement)switchStatementList.get(index);
            if (st.getNodeType() == 49) {
                currentCase = StatementConverterUtility.convertToSwitchCase((SwitchCase)st);
                switchExprSt.getCases().add((Object)currentCase);
                continue;
            }
            if (currentCase instanceof SwitchRule && st.getNodeType() == 101) {
                org.eclipse.jdt.core.dom.YieldStatement ys = (org.eclipse.jdt.core.dom.YieldStatement)st;
                ExpressionStatement exprSt = StatementsFactory.eINSTANCE.createExpressionStatement();
                exprSt.setExpression(ExpressionConverterUtility.convertToExpression(ys.getExpression()));
                currentCase.getStatements().add((Object)exprSt);
                continue;
            }
            currentCase.getStatements().add((Object)StatementConverterUtility.convertToStatement(st));
        }
    }

    private static tools.mdsd.jamopp.model.java.statements.SwitchCase convertToSwitchCase(SwitchCase switchCase) {
        DefaultSwitchRule result = null;
        if (switchCase.isSwitchLabeledRule() && switchCase.isDefault()) {
            result = StatementsFactory.eINSTANCE.createDefaultSwitchRule();
        } else if (switchCase.isSwitchLabeledRule() && !switchCase.isDefault()) {
            NormalSwitchRule normalRule = StatementsFactory.eINSTANCE.createNormalSwitchRule();
            normalRule.setCondition(ExpressionConverterUtility.convertToExpression((org.eclipse.jdt.core.dom.Expression)switchCase.expressions().get(0)));
            for (int index = 1; index < switchCase.expressions().size(); ++index) {
                org.eclipse.jdt.core.dom.Expression expr = (org.eclipse.jdt.core.dom.Expression)switchCase.expressions().get(index);
                normalRule.getAdditionalConditions().add((Object)ExpressionConverterUtility.convertToExpression(expr));
            }
            result = normalRule;
        } else if (!switchCase.isSwitchLabeledRule() && switchCase.isDefault()) {
            result = StatementsFactory.eINSTANCE.createDefaultSwitchCase();
        } else {
            NormalSwitchCase normalCase = StatementsFactory.eINSTANCE.createNormalSwitchCase();
            normalCase.setCondition(ExpressionConverterUtility.convertToExpression((org.eclipse.jdt.core.dom.Expression)switchCase.expressions().get(0)));
            for (int index = 1; index < switchCase.expressions().size(); ++index) {
                org.eclipse.jdt.core.dom.Expression expr = (org.eclipse.jdt.core.dom.Expression)switchCase.expressions().get(index);
                normalCase.getAdditionalConditions().add((Object)ExpressionConverterUtility.convertToExpression(expr));
            }
            result = normalCase;
        }
        LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)switchCase);
        return result;
    }

    private static CatchBlock convertToCatchBlock(CatchClause block) {
        CatchBlock result = StatementsFactory.eINSTANCE.createCatchBlock();
        CatchParameter param = ParametersFactory.eINSTANCE.createCatchParameter();
        SingleVariableDeclaration decl = block.getException();
        decl.modifiers().forEach(obj -> param.getAnnotationsAndModifiers().add((Object)AnnotationInstanceOrModifierConverterUtility.converToModifierOrAnnotationInstance((IExtendedModifier)obj)));
        if (decl.getType().isUnionType()) {
            UnionType un = (UnionType)decl.getType();
            param.setTypeReference(BaseConverterUtility.convertToTypeReference((Type)un.types().get(0)));
            for (int index = 1; index < un.types().size(); ++index) {
                param.getTypeReferences().add((Object)BaseConverterUtility.convertToTypeReference((Type)un.types().get(index)));
            }
        } else {
            param.setTypeReference(BaseConverterUtility.convertToTypeReference(decl.getType()));
        }
        BaseConverterUtility.convertToSimpleNameOnlyAndSet((Name)decl.getName(), (NamedElement)param);
        result.setParameter((OrdinaryParameter)param);
        result.setBlock(StatementConverterUtility.convertToBlock(block.getBody()));
        LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)block);
        return result;
    }

    private static AdditionalLocalVariable convertToAdditionalLocalVariable(VariableDeclarationFragment frag, Type type) {
        AdditionalLocalVariable result = VariablesFactory.eINSTANCE.createAdditionalLocalVariable();
        BaseConverterUtility.convertToSimpleNameOnlyAndSet((Name)frag.getName(), (NamedElement)result);
        result.setTypeReference(BaseConverterUtility.convertToTypeReference(type));
        BaseConverterUtility.convertToArrayDimensionsAndSet(type, (ArrayTypeable)result.getTypeReference());
        frag.extraDimensions().forEach(obj -> BaseConverterUtility.convertToArrayDimensionAfterAndSet((Dimension)obj, (ArrayTypeable)result.getTypeReference()));
        if (frag.getInitializer() != null) {
            result.setInitialValue(ExpressionConverterUtility.convertToExpression(frag.getInitializer()));
        }
        LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)frag);
        return result;
    }

    private static LocalVariable convertToLocalVariable(VariableDeclarationExpression expr) {
        LocalVariable loc = VariablesFactory.eINSTANCE.createLocalVariable();
        expr.modifiers().forEach(obj -> loc.getAnnotationsAndModifiers().add((Object)AnnotationInstanceOrModifierConverterUtility.converToModifierOrAnnotationInstance((IExtendedModifier)obj)));
        loc.setTypeReference(BaseConverterUtility.convertToTypeReference(expr.getType()));
        VariableDeclarationFragment frag = (VariableDeclarationFragment)expr.fragments().get(0);
        BaseConverterUtility.convertToSimpleNameOnlyAndSet((Name)frag.getName(), (NamedElement)loc);
        BaseConverterUtility.convertToArrayDimensionsAndSet(expr.getType(), (ArrayTypeable)loc.getTypeReference());
        frag.extraDimensions().forEach(obj -> BaseConverterUtility.convertToArrayDimensionAfterAndSet((Dimension)obj, (ArrayTypeable)loc.getTypeReference()));
        if (frag.getInitializer() != null) {
            loc.setInitialValue(ExpressionConverterUtility.convertToExpression(frag.getInitializer()));
        }
        for (int index = 1; index < expr.fragments().size(); ++index) {
            loc.getAdditionalLocalVariables().add((Object)StatementConverterUtility.convertToAdditionalLocalVariable((VariableDeclarationFragment)expr.fragments().get(index), expr.getType()));
        }
        LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)loc, (ASTNode)expr);
        return loc;
    }
}

