/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.jdt.singlefile;

import org.eclipse.emf.ecore.EObject;
import tools.mdsd.jamopp.model.java.JavaClasspath;
import tools.mdsd.jamopp.model.java.classifiers.Annotation;
import tools.mdsd.jamopp.model.java.classifiers.Class;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Enumeration;
import tools.mdsd.jamopp.model.java.classifiers.Interface;
import tools.mdsd.jamopp.model.java.containers.Package;
import tools.mdsd.jamopp.model.java.members.MembersFactory;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.parameters.OrdinaryParameter;
import tools.mdsd.jamopp.model.java.parameters.ParametersFactory;
import tools.mdsd.jamopp.model.java.statements.Statement;
import tools.mdsd.jamopp.model.java.statements.StatementsFactory;
import tools.mdsd.jamopp.model.java.types.ClassifierReference;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.model.java.types.TypesFactory;

public class ParsePostProcessor {
    public static void complete(EObject obj) {
        obj.eAllContents().forEachRemaining(element -> {
            if (element instanceof Class) {
                ParsePostProcessor.addDefaultSuperClass((Class)element);
            }
            if (element instanceof Interface) {
                ParsePostProcessor.addDefaultSuperInterface((Interface)element);
            }
            if (element instanceof Enumeration) {
                ParsePostProcessor.addMissingEnumerationMembers((Enumeration)element);
            }
            if (element instanceof Annotation) {
                ParsePostProcessor.addMissingAnnotationMembers((Annotation)element);
            }
            if (element instanceof ConcreteClassifier) {
                ParsePostProcessor.addMissingPackage((ConcreteClassifier)element);
            }
        });
    }

    private static void addDefaultSuperClass(Class javaClass) {
        if (javaClass.getExtends() == null && javaClass.getDefaultExtends() == null && !javaClass.isJavaLangObject((ConcreteClassifier)javaClass)) {
            Class objectClass = javaClass.getObjectClass();
            ClassifierReference classifierReference = TypesFactory.eINSTANCE.createClassifierReference();
            classifierReference.setTarget((Classifier)objectClass);
            javaClass.setDefaultExtends((TypeReference)classifierReference);
        }
    }

    private static void addDefaultSuperInterface(Interface javaInterface) {
        if (javaInterface.getExtends().isEmpty() && javaInterface.getDefaultExtends().isEmpty()) {
            Class objectClass = javaInterface.getObjectClass();
            ClassifierReference classifierReference = TypesFactory.eINSTANCE.createClassifierReference();
            classifierReference.setTarget((Classifier)objectClass);
            javaInterface.getDefaultExtends().add((Object)classifierReference);
        }
    }

    private static void addMissingAnnotationMembers(Annotation annotation) {
        String valueMethodName = "value";
        Method valueMethod = annotation.getContainedMethod(valueMethodName);
        if (valueMethod == null) {
            valueMethod = MembersFactory.eINSTANCE.createInterfaceMethod();
            valueMethod.setName(valueMethodName);
            valueMethod.setStatement((Statement)StatementsFactory.eINSTANCE.createEmptyStatement());
            ClassifierReference type = TypesFactory.eINSTANCE.createClassifierReference();
            type.setTarget((Classifier)JavaClasspath.get().getConcreteClassifier("java.lang.String"));
            valueMethod.setTypeReference((TypeReference)type);
            annotation.getDefaultMembers().add((Object)valueMethod);
        }
    }

    private static void addMissingEnumerationMembers(Enumeration enumeration) {
        String valueOfMethodName;
        Method valueOfMethod;
        String valuesMethodName = "values";
        Method valuesMethod = enumeration.getContainedMethod(valuesMethodName);
        if (valuesMethod == null) {
            valuesMethod = MembersFactory.eINSTANCE.createInterfaceMethod();
            valuesMethod.setName(valuesMethodName);
            valuesMethod.setStatement((Statement)StatementsFactory.eINSTANCE.createEmptyStatement());
            ClassifierReference type = TypesFactory.eINSTANCE.createClassifierReference();
            type.setTarget((Classifier)enumeration);
            valuesMethod.setTypeReference((TypeReference)type);
            enumeration.getDefaultMembers().add((Object)valuesMethod);
        }
        if ((valueOfMethod = enumeration.getContainedMethod(valueOfMethodName = "valueOf")) == null) {
            valueOfMethod = MembersFactory.eINSTANCE.createInterfaceMethod();
            valueOfMethod.setName(valueOfMethodName);
            valueOfMethod.setStatement((Statement)StatementsFactory.eINSTANCE.createEmptyStatement());
            ClassifierReference type = TypesFactory.eINSTANCE.createClassifierReference();
            type.setTarget((Classifier)enumeration);
            valueOfMethod.setTypeReference((TypeReference)type);
            OrdinaryParameter strParameter = ParametersFactory.eINSTANCE.createOrdinaryParameter();
            strParameter.setName("str");
            type = TypesFactory.eINSTANCE.createClassifierReference();
            type.setTarget((Classifier)JavaClasspath.get().getConcreteClassifier("java.lang.String"));
            strParameter.setTypeReference((TypeReference)type);
            valueOfMethod.getParameters().add((Object)strParameter);
            enumeration.getDefaultMembers().add((Object)valueOfMethod);
        }
    }

    private static void addMissingPackage(ConcreteClassifier clazz) {
        if (clazz.getPackage() == null) {
            String packageName = clazz.getContainingCompilationUnit().getNamespacesAsString();
            Package pack = JavaClasspath.get().getPackage(packageName);
            if (pack != null) {
                clazz.setPackage(pack);
            }
        }
    }
}

