/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.jdt.singlefile;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FileASTRequestor;
import tools.mdsd.jamopp.model.java.JavaClasspath;
import tools.mdsd.jamopp.model.java.containers.JavaRoot;
import tools.mdsd.jamopp.model.java.containers.Origin;
import tools.mdsd.jamopp.options.ParserOptions;
import tools.mdsd.jamopp.parser.api.JaMoPPParserAPI;
import tools.mdsd.jamopp.parser.jdt.singlefile.OrdinaryCompilationUnitJDTASTVisitorAndConverter;
import tools.mdsd.jamopp.proxy.IJavaContextDependentURIFragmentCollector;
import tools.mdsd.jamopp.resolution.bindings.CentralBindingBasedResolver;
import tools.mdsd.jamopp.resolution.resolver.CentralReferenceResolver;

public class JaMoPPJDTSingleFileParser
implements JaMoPPParserAPI {
    private final String DEFAULT_ENCODING = StandardCharsets.UTF_8.toString();
    private ResourceSet resourceSet;
    private ArrayList<String> exclusionPatterns = new ArrayList();
    private static boolean isResolving = false;

    public void setExclusionPatterns(String ... patterns) {
        this.exclusionPatterns.clear();
        for (String pa : patterns) {
            this.exclusionPatterns.add(pa);
        }
    }

    public JavaRoot parse(String fileName, InputStream input) {
        this.setUpResourceSet();
        StringBuilder builder = new StringBuilder();
        String lineSep = System.getProperty("line.separator");
        try (InputStreamReader inReader2 = new InputStreamReader(input);
             BufferedReader buffReader = new BufferedReader(inReader2);){
            buffReader.lines().forEach(line -> builder.append(line + lineSep));
        }
        catch (IOException inReader2) {
            // empty catch block
        }
        String src = builder.toString();
        ASTNode ast = this.parseFileWithJDT(src, fileName);
        OrdinaryCompilationUnitJDTASTVisitorAndConverter converter = new OrdinaryCompilationUnitJDTASTVisitorAndConverter();
        converter.setSource(src);
        ast.accept((ASTVisitor)converter);
        this.resourceSet = null;
        return converter.getConvertedElement();
    }

    private ASTNode parseFileWithJDT(String fileContent, String fileName) {
        ASTParser parser = this.setUpParser();
        parser.setUnitName(fileName);
        parser.setEnvironment(new String[0], new String[0], new String[0], true);
        parser.setSource(fileContent.toCharArray());
        return parser.createAST(null);
    }

    public Resource parseFile(Path file) {
        this.setUpResourceSet();
        Resource result = this.parseFilesWithJDT(new String[0], new String[]{file.toAbsolutePath().toString()}, new String[]{this.DEFAULT_ENCODING}).get(0).eResource();
        this.resourceSet = null;
        return result;
    }

    public ResourceSet parseDirectory(Path dir) {
        this.setUpResourceSet();
        try {
            String[] sources = this.findSources(dir);
            String[] encodings = new String[sources.length];
            for (int index = 0; index < encodings.length; ++index) {
                encodings[index] = this.DEFAULT_ENCODING;
            }
            String[] classpathEntries = this.findClasspathEntries(dir);
            this.parseFilesWithJDT(classpathEntries, sources, encodings);
            this.resolveBindings();
            this.resolveEverything();
        }
        catch (IOException sources) {
            // empty catch block
        }
        ResourceSet result = this.resourceSet;
        this.resourceSet = null;
        return result;
    }

    public String[] findSources(Path directory) throws IOException {
        return this.findFiles(directory, ".java");
    }

    public String[] findClasspathEntries(Path directory) throws IOException {
        return this.findFiles(directory, ".jar", ".zip");
    }

    private String[] findFiles(Path directory, String ... extensions) throws IOException {
        return (String[])Files.walk(directory, new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0]) && this.testFileExtensions((Path)path, extensions)).map(Path::toAbsolutePath).map(Path::toString).map(s -> s.replace(File.separator, "/")).filter(this::testPathStringForExclusion).toArray(String[]::new);
    }

    private boolean testFileExtensions(Path file, String ... extensions) {
        String fileName = file.getFileName().toString();
        boolean result = false;
        for (String ext : extensions) {
            result = result || fileName.endsWith(ext);
        }
        return result;
    }

    private boolean testPathStringForExclusion(String path) {
        return this.exclusionPatterns.stream().map(pattern -> !path.matches((String)pattern)).reduce(true, (i, j) -> i != false && j != false);
    }

    private List<JavaRoot> parseFilesWithJDT(String[] classpathEntries, String[] sources, String[] encodings) {
        final ArrayList<JavaRoot> result = new ArrayList<JavaRoot>();
        ASTParser parser = this.setUpParser();
        for (String entry : classpathEntries) {
            JavaClasspath.get((ResourceSet)this.resourceSet).registerZip(URI.createFileURI((String)entry));
        }
        parser.setEnvironment(classpathEntries, new String[0], new String[0], true);
        final OrdinaryCompilationUnitJDTASTVisitorAndConverter converter = new OrdinaryCompilationUnitJDTASTVisitorAndConverter();
        parser.createASTs(sources, encodings, new String[0], new FileASTRequestor(){

            public void acceptAST(String sourceFilePath, CompilationUnit node) {
                URI fileURI = URI.createFileURI((String)sourceFilePath);
                IJavaContextDependentURIFragmentCollector.GLOBAL_INSTANCE.setBaseURI(fileURI);
                node.accept((ASTVisitor)converter);
                JavaRoot root = converter.getConvertedElement();
                root.setOrigin(Origin.FILE);
                if (root.eResource() == null) {
                    Resource newResource = JaMoPPJDTSingleFileParser.this.resourceSet.createResource(fileURI);
                    newResource.getContents().add((Object)root);
                    JavaClasspath.get((ResourceSet)JaMoPPJDTSingleFileParser.this.resourceSet).registerJavaRoot(root, fileURI);
                } else {
                    Resource newResource = root.eResource();
                    if (!newResource.getURI().toFileString().equals(sourceFilePath)) {
                        newResource.setURI(fileURI);
                        JavaClasspath.get((ResourceSet)JaMoPPJDTSingleFileParser.this.resourceSet).registerJavaRoot(root, fileURI);
                    }
                }
                result.add(root);
            }
        }, null);
        return result;
    }

    private void setUpResourceSet() {
        if (this.resourceSet == null) {
            this.resourceSet = new ResourceSetImpl();
        }
        if (ParserOptions.REGISTER_LOCAL.isTrue()) {
            JavaClasspath.get((ResourceSet)this.resourceSet).enableLocalRegistration();
            JavaClasspath.get((ResourceSet)this.resourceSet).registerStdLib();
        }
    }

    private ASTParser setUpParser() {
        ASTParser parser = ASTParser.newParser((int)15);
        parser.setResolveBindings(true);
        parser.setStatementsRecovery(true);
        HashMap<String, String> compilerOptions = new HashMap<String, String>();
        compilerOptions.put("org.eclipse.jdt.core.compiler.source", "15");
        compilerOptions.put("org.eclipse.jdt.core.compiler.compliance", "15");
        compilerOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        parser.setCompilerOptions(compilerOptions);
        return parser;
    }

    public void resolveBindings() {
        if (isResolving) {
            return;
        }
        if (ParserOptions.RESOLVE_BINDINGS.isTrue()) {
            int oldSize;
            isResolving = true;
            CentralReferenceResolver.GLOBAL_INSTANCE.setBindingBasedResolver(new CentralBindingBasedResolver(this.resourceSet));
            int newSize = this.resourceSet.getResources().size();
            HashSet alreadyResolved = new HashSet();
            boolean resolveAllBindings = ParserOptions.RESOLVE_ALL_BINDINGS.isTrue();
            do {
                oldSize = newSize;
                ArrayList resources = new ArrayList(this.resourceSet.getResources());
                resources.forEach(r -> {
                    if (!alreadyResolved.contains(r) && (resolveAllBindings || r.getURI().isFile())) {
                        EcoreUtil.resolveAll((Resource)r);
                        alreadyResolved.add(r);
                    }
                });
            } while (oldSize != (newSize = this.resourceSet.getResources().size()) && resolveAllBindings);
            CentralReferenceResolver.GLOBAL_INSTANCE.setBindingBasedResolver(null);
            Map fragments = IJavaContextDependentURIFragmentCollector.GLOBAL_INSTANCE.getContextDependentURIFragmentMap();
            fragments.values().forEach(v -> v.setBinding(null));
            isResolving = false;
        }
    }

    private void resolveEverything() {
        if (ParserOptions.RESOLVE_EVERYTHING.isTrue()) {
            int oldSize;
            do {
                oldSize = this.resourceSet.getResources().size();
                for (Resource res : new ArrayList(this.resourceSet.getResources())) {
                    if (res.getContents().isEmpty()) continue;
                    EcoreUtil.resolveAll((Resource)res);
                }
            } while (oldSize != this.resourceSet.getResources().size());
        }
    }

    public void setResourceSet(ResourceSet set) {
        this.resourceSet = set;
    }
}

