/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.bcel;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.bcel.classfile.AccessFlags;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.Signature;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.Type;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import tools.mdsd.jamopp.model.java.JavaClasspath;
import tools.mdsd.jamopp.model.java.arrays.ArraysFactory;
import tools.mdsd.jamopp.model.java.classifiers.Annotation;
import tools.mdsd.jamopp.model.java.classifiers.Class;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.classifiers.ClassifiersFactory;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Enumeration;
import tools.mdsd.jamopp.model.java.classifiers.Interface;
import tools.mdsd.jamopp.model.java.containers.CompilationUnit;
import tools.mdsd.jamopp.model.java.containers.ContainersFactory;
import tools.mdsd.jamopp.model.java.containers.Origin;
import tools.mdsd.jamopp.model.java.generics.GenericsFactory;
import tools.mdsd.jamopp.model.java.generics.QualifiedTypeArgument;
import tools.mdsd.jamopp.model.java.generics.TypeParameter;
import tools.mdsd.jamopp.model.java.generics.TypeParametrizable;
import tools.mdsd.jamopp.model.java.generics.UnknownTypeArgument;
import tools.mdsd.jamopp.model.java.members.Constructor;
import tools.mdsd.jamopp.model.java.members.EnumConstant;
import tools.mdsd.jamopp.model.java.members.Field;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.members.MembersFactory;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.modifiers.AnnotableAndModifiable;
import tools.mdsd.jamopp.model.java.modifiers.ModifiersFactory;
import tools.mdsd.jamopp.model.java.parameters.OrdinaryParameter;
import tools.mdsd.jamopp.model.java.parameters.Parameter;
import tools.mdsd.jamopp.model.java.parameters.ParametersFactory;
import tools.mdsd.jamopp.model.java.parameters.VariableLengthParameter;
import tools.mdsd.jamopp.model.java.types.Byte;
import tools.mdsd.jamopp.model.java.types.ClassifierReference;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.model.java.types.TypedElement;
import tools.mdsd.jamopp.model.java.types.TypesFactory;

public class ClassFileModelLoader {
    private ClassifiersFactory qualifiersFactory = ClassifiersFactory.eINSTANCE;
    private MembersFactory membersFactory = MembersFactory.eINSTANCE;
    private ParametersFactory parametersFactory = ParametersFactory.eINSTANCE;

    public CompilationUnit parse(InputStream inputStream, String classFileName) throws IOException {
        try {
            ClassParser classParser = new ClassParser(inputStream, classFileName);
            JavaClass myClass = classParser.parse();
            ConcreteClassifier classifier = this.constructClassifier(myClass);
            CompilationUnit cu = ContainersFactory.eINSTANCE.createCompilationUnit();
            cu.setOrigin(Origin.CLASS);
            cu.setName(classFileName);
            List<String> namespace1 = Arrays.asList(myClass.getClassName().split("\\."));
            List<String> namespace2 = Arrays.asList(namespace1.get(namespace1.size() - 1).split("\\$"));
            cu.getNamespaces().addAll(namespace1.subList(0, namespace1.size() - 1));
            if (myClass.getClassName().endsWith("$")) {
                cu.getNamespaces().addAll(namespace2);
            } else {
                cu.getNamespaces().addAll(namespace2.subList(0, namespace2.size() - 1));
            }
            cu.getClassifiers().add((Object)classifier);
            return cu;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage(), e);
        }
    }

    private ConcreteClassifier constructClassifier(JavaClass clazz) {
        Enumeration emfClassifier = null;
        if (clazz.isEnum()) {
            emfClassifier = this.qualifiersFactory.createEnumeration();
        } else if (clazz.isAnnotation()) {
            emfClassifier = this.qualifiersFactory.createAnnotation();
        } else if (clazz.isClass()) {
            emfClassifier = this.qualifiersFactory.createClass();
        } else if (clazz.isInterface()) {
            emfClassifier = this.qualifiersFactory.createInterface();
        } else {
            assert (false);
            return null;
        }
        String className = clazz.getClassName();
        int idx = clazz.getClassName().lastIndexOf("$");
        if (idx >= 0) {
            className = className.substring(idx + 1);
        } else {
            idx = clazz.getClassName().lastIndexOf(".");
            if (idx >= 0) {
                className = className.substring(idx + 1);
            }
        }
        emfClassifier.setName(className);
        for (Attribute a : clazz.getAttributes()) {
            String string = a.toString();
            if (!string.startsWith("Signature(")) continue;
            EList<TypeParameter> tpList = this.constructTypeParameters(string);
            emfClassifier.getTypeParameters().addAll(tpList);
        }
        String typeArgumentSig = "";
        for (Attribute attribute : clazz.getAttributes()) {
            String s = attribute.toString();
            if ((s = s.replaceAll("\\[", "")).startsWith("Signature(L")) {
                typeArgumentSig = s.substring(s.indexOf("(") + 1, s.indexOf(")"));
            }
            if (!s.startsWith("Signature(<")) continue;
            typeArgumentSig = s.substring(s.indexOf(";>L") + 2, s.indexOf(")"));
        }
        if (clazz.isClass() && !clazz.isEnum()) {
            Class clazz2 = (Class)emfClassifier;
            if (clazz.getSuperclassName() != null) {
                clazz2.setExtends(this.createReferenceToClassifier(clazz.getSuperclassName()));
                typeArgumentSig = this.constructTypeArguments(typeArgumentSig, (ClassifierReference)clazz2.getExtends(), null, (ConcreteClassifier)emfClassifier);
            }
        } else {
            typeArgumentSig = this.constructTypeArguments(typeArgumentSig, null, null, (ConcreteClassifier)emfClassifier);
        }
        for (String string : clazz.getInterfaceNames()) {
            TypeReference typeArg = this.createReferenceToClassifier(string);
            typeArgumentSig = this.constructTypeArguments(typeArgumentSig, (ClassifierReference)typeArg, null, (ConcreteClassifier)emfClassifier);
            if (clazz.isEnum()) {
                emfClassifier.getImplements().add((Object)typeArg);
                continue;
            }
            if (clazz.isAnnotation()) continue;
            if (clazz.isClass()) {
                ((Class)emfClassifier).getImplements().add((Object)typeArg);
                continue;
            }
            if (!clazz.isInterface()) continue;
            ((Interface)emfClassifier).getExtends().add((Object)typeArg);
        }
        for (org.apache.bcel.classfile.Field field : clazz.getFields()) {
            if (field.isEnum() && emfClassifier instanceof Enumeration) {
                emfClassifier.getConstants().add((Object)this.constructEnumConstant(field));
                continue;
            }
            emfClassifier.getMembers().add((Object)this.constructField(field, (ConcreteClassifier)emfClassifier));
        }
        for (org.apache.bcel.classfile.Method method : clazz.getMethods()) {
            if (method.isSynthetic()) continue;
            Member emfMember = this.constructMethod(method, (ConcreteClassifier)emfClassifier, false);
            if (emfMember instanceof Method && !((Method)emfMember).getParameters().isEmpty() && !((Parameter)((Method)emfMember).getParameters().get(((Method)emfMember).getParameters().size() - 1)).getTypeReference().getArrayDimensionsBefore().isEmpty()) {
                Member emfMethod2 = this.constructMethod(method, (ConcreteClassifier)emfClassifier, true);
                emfClassifier.getMembers().add((Object)emfMethod2);
                continue;
            }
            emfClassifier.getMembers().add((Object)emfMember);
        }
        this.constructModifiers((AnnotableAndModifiable)emfClassifier, (AccessFlags)clazz);
        return emfClassifier;
    }

    private Member constructMethod(org.apache.bcel.classfile.Method method, ConcreteClassifier emfClassifier, boolean withVariableLength) {
        Object emfMethod = null;
        emfMethod = emfClassifier instanceof Annotation || emfClassifier instanceof Interface ? this.membersFactory.createInterfaceMethod() : this.membersFactory.createClassMethod();
        emfMethod.setName(method.getName());
        String signature = method.getReturnType().getSignature();
        String plainSignature = "";
        for (Attribute a : method.getAttributes()) {
            if (!(a instanceof Signature)) continue;
            String s = a.toString();
            plainSignature = s = s.replaceAll("\\[", "");
            break;
        }
        emfMethod.getTypeParameters().addAll(this.constructTypeParameters(plainSignature));
        TypeReference typeRef = this.createReferenceToType(signature);
        ClassifierReference typeParamRef = this.constructReturnTypeParameterReference(plainSignature, (TypedElement)emfMethod, emfClassifier);
        if (typeParamRef != null) {
            ((TypeParameter)typeParamRef.getTarget()).getExtendTypes().add((Object)typeRef);
            typeRef = typeParamRef;
        }
        emfMethod.setTypeReference(typeRef);
        int arrayDimension = this.getArrayDimension(signature);
        for (int i = 0; i < arrayDimension; ++i) {
            emfMethod.getTypeReference().getArrayDimensionsBefore().add((Object)ArraysFactory.eINSTANCE.createArrayDimension());
        }
        List<String> parameterNames = this.extractParameterNames(method);
        for (int i = 0; i < method.getArgumentTypes().length; ++i) {
            Type argType = method.getArgumentTypes()[i];
            Object paramName = parameterNames.size() > i ? parameterNames.get(i) : "arg" + i;
            if (i == method.getArgumentTypes().length - 1 && withVariableLength) {
                emfMethod.getParameters().add((Object)this.constructVariableLengthParameter(argType, (String)paramName));
                continue;
            }
            emfMethod.getParameters().add((Object)this.constructParameter(argType, (String)paramName));
        }
        EList<TypeReference> tpList = this.constructMethodTypeParameterReferences(plainSignature, (Method)emfMethod, emfClassifier);
        for (int i = 0; i < tpList.size(); ++i) {
            TypeReference typeReference;
            TypeReference typeParameterReference = (TypeReference)tpList.get(i);
            if (typeParameterReference == null || !((typeReference = ((Parameter)emfMethod.getParameters().get(i)).getTypeReference()) instanceof ClassifierReference)) continue;
            ((TypeParameter)((ClassifierReference)typeParameterReference).getTarget()).getExtendTypes().add((Object)typeReference);
            ((Parameter)emfMethod.getParameters().get(i)).setTypeReference(typeParameterReference);
        }
        if (!"".equals(plainSignature) && !(emfClassifier instanceof Enumeration)) {
            if (typeRef instanceof ClassifierReference) {
                String returnSignature = plainSignature.substring(0, plainSignature.lastIndexOf(")"));
                returnSignature = returnSignature.substring(returnSignature.lastIndexOf(")") + 1);
                this.constructTypeArguments(returnSignature, (ClassifierReference)typeRef, (TypeParametrizable)emfMethod, emfClassifier);
            }
            String argumentSignature = plainSignature.substring(plainSignature.lastIndexOf("(") + 1, plainSignature.indexOf(")"));
            for (Parameter parameter : emfMethod.getParameters()) {
                TypeReference parameterTypeRef = parameter.getTypeReference();
                if (parameterTypeRef instanceof ClassifierReference) {
                    argumentSignature = this.constructTypeArguments(argumentSignature, (ClassifierReference)parameterTypeRef, (TypeParametrizable)emfMethod, emfClassifier);
                    continue;
                }
                argumentSignature = this.constructTypeArguments(argumentSignature, null, (TypeParametrizable)emfMethod, emfClassifier);
            }
        }
        if (emfMethod.getName().equals("<init>")) {
            Constructor constructor = MembersFactory.eINSTANCE.createConstructor();
            constructor.getTypeParameters().addAll((Collection)emfMethod.getTypeParameters());
            constructor.getParameters().addAll((Collection)emfMethod.getParameters());
            constructor.setName(emfClassifier.getName());
            return constructor;
        }
        this.constructModifiers((AnnotableAndModifiable)emfMethod, (AccessFlags)method);
        return emfMethod;
    }

    private Parameter constructParameter(Type attrType, String paramName) {
        OrdinaryParameter emfParameter = this.parametersFactory.createOrdinaryParameter();
        String signature = attrType.getSignature();
        TypeReference emfTypeReference = this.createReferenceToType(signature);
        emfParameter.setTypeReference(emfTypeReference);
        emfParameter.setName(paramName);
        int arrayDimension = this.getArrayDimension(signature);
        for (int i = 0; i < arrayDimension; ++i) {
            emfParameter.getTypeReference().getArrayDimensionsBefore().add((Object)ArraysFactory.eINSTANCE.createArrayDimension());
        }
        return emfParameter;
    }

    private Parameter constructVariableLengthParameter(Type attrType, String paramName) {
        VariableLengthParameter emfParameter = this.parametersFactory.createVariableLengthParameter();
        String signature = attrType.getSignature();
        TypeReference emfTypeReference = this.createReferenceToType(signature);
        emfParameter.setTypeReference(emfTypeReference);
        emfParameter.setName(paramName);
        int arrayDimension = this.getArrayDimension(signature) - 1;
        for (int i = 0; i < arrayDimension; ++i) {
            emfParameter.getTypeReference().getArrayDimensionsBefore().add((Object)ArraysFactory.eINSTANCE.createArrayDimension());
        }
        return emfParameter;
    }

    private Field constructField(org.apache.bcel.classfile.Field field, ConcreteClassifier emfClassifier) {
        Field emfField = this.membersFactory.createField();
        emfField.setName(field.getName());
        String signature = field.getType().getSignature();
        String plainSignature = "";
        for (Attribute a : field.getAttributes()) {
            String s = a.toString();
            if (!s.startsWith("Signature(")) continue;
            s = s.replaceAll("\\[", "");
            plainSignature = s.substring(s.indexOf("(") + 1, s.lastIndexOf(")"));
            break;
        }
        TypeReference typeRef = this.createReferenceToType(signature);
        ClassifierReference typeParamRef = this.constructReturnTypeParameterReference(plainSignature, (TypedElement)emfField, emfClassifier);
        if (typeParamRef != null) {
            ((TypeParameter)typeParamRef.getTarget()).getExtendTypes().add((Object)typeRef);
            typeRef = typeParamRef;
        }
        emfField.setTypeReference(typeRef);
        int arrayDimension = this.getArrayDimension(signature);
        for (int i = 0; i < arrayDimension; ++i) {
            emfField.getTypeReference().getArrayDimensionsBefore().add((Object)ArraysFactory.eINSTANCE.createArrayDimension());
        }
        if (!"".equals(plainSignature) && typeRef instanceof ClassifierReference) {
            this.constructTypeArguments(plainSignature, (ClassifierReference)typeRef, null, emfClassifier);
        }
        this.constructModifiers((AnnotableAndModifiable)emfField, (AccessFlags)field);
        return emfField;
    }

    private void constructModifiers(AnnotableAndModifiable emfMember, AccessFlags member) {
        ModifiersFactory f = ModifiersFactory.eINSTANCE;
        if (member.isAbstract()) {
            emfMember.getAnnotationsAndModifiers().add((Object)f.createAbstract());
        }
        if (member.isFinal()) {
            emfMember.getAnnotationsAndModifiers().add((Object)f.createFinal());
        }
        if (member.isNative()) {
            emfMember.getAnnotationsAndModifiers().add((Object)f.createNative());
        }
        if (member.isPrivate()) {
            emfMember.getAnnotationsAndModifiers().add((Object)f.createPrivate());
        }
        if (member.isProtected()) {
            emfMember.getAnnotationsAndModifiers().add((Object)f.createProtected());
        }
        if (member.isPublic()) {
            emfMember.getAnnotationsAndModifiers().add((Object)f.createPublic());
        }
        if (member.isStatic()) {
            emfMember.getAnnotationsAndModifiers().add((Object)f.createStatic());
        }
        if (member.isStrictfp()) {
            emfMember.getAnnotationsAndModifiers().add((Object)f.createStrictfp());
        }
        if (member.isSynchronized()) {
            emfMember.getAnnotationsAndModifiers().add((Object)f.createSynchronized());
        }
        if (member.isTransient()) {
            emfMember.getAnnotationsAndModifiers().add((Object)f.createTransient());
        }
        if (member.isVolatile()) {
            emfMember.getAnnotationsAndModifiers().add((Object)f.createVolatile());
        }
        if (!member.isPrivate() && emfMember instanceof ConcreteClassifier) {
            emfMember.getAnnotationsAndModifiers().add((Object)f.createStatic());
        }
    }

    private EnumConstant constructEnumConstant(org.apache.bcel.classfile.Field field) {
        EnumConstant enumConstant = this.membersFactory.createEnumConstant();
        enumConstant.setName(field.getName());
        return enumConstant;
    }

    private ClassifierReference constructTypeParameterReference(String name, TypeParametrizable method, ConcreteClassifier emfClassifier) {
        TypeParameter typeParameter = null;
        if (method != null) {
            for (TypeParameter cand : method.getTypeParameters()) {
                if (!cand.getName().equals(name)) continue;
                typeParameter = cand;
            }
        }
        if (typeParameter == null) {
            for (TypeParameter cand : emfClassifier.getTypeParameters()) {
                if (!cand.getName().equals(name)) continue;
                typeParameter = cand;
            }
        }
        if (typeParameter == null) {
            return null;
        }
        ClassifierReference classifierReference = TypesFactory.eINSTANCE.createClassifierReference();
        classifierReference.setTarget(typeParameter);
        return classifierReference;
    }

    private ClassifierReference constructReturnTypeParameterReference(String signature, TypedElement element, ConcreteClassifier emfClassifier) {
        int idx = signature.indexOf(")T");
        if (idx != -1) {
            signature = signature.substring(idx + 2);
        } else {
            idx = signature.indexOf("T");
            if (idx != 0) {
                return null;
            }
            signature = signature.substring(1);
        }
        idx = signature.indexOf(";");
        if (idx == -1) {
            return null;
        }
        String name = signature.substring(0, idx);
        TypeParameter typeParameter = null;
        if (element instanceof TypeParametrizable) {
            for (TypeParameter cand : ((TypeParametrizable)element).getTypeParameters()) {
                if (!cand.getName().equals(name)) continue;
                typeParameter = cand;
            }
        }
        if (typeParameter == null) {
            for (TypeParameter cand : emfClassifier.getTypeParameters()) {
                if (!cand.getName().equals(name)) continue;
                typeParameter = cand;
            }
        }
        if (typeParameter == null) {
            return null;
        }
        ClassifierReference classifierReference = TypesFactory.eINSTANCE.createClassifierReference();
        classifierReference.setTarget(typeParameter);
        return classifierReference;
    }

    private EList<TypeReference> constructMethodTypeParameterReferences(String signature, Method method, ConcreteClassifier emfClassifier) {
        int idx;
        BasicEList result = new BasicEList();
        int idx1 = ((String)signature).indexOf("((");
        if (idx1 == -1) {
            idx1 = ((String)signature).indexOf(">(");
        }
        int idx2 = ((String)signature).indexOf(")");
        if (idx1 == -1 || idx2 == -1) {
            return result;
        }
        signature = ((String)signature).substring(idx1 + 2, idx2);
        while (((String)signature).contains("<")) {
            idx = ((String)signature).indexOf("<");
            String start = ((String)signature).substring(0, idx);
            String end = ((String)signature).substring(idx + 1);
            int bracketCount = 1;
            while (bracketCount > 0) {
                if (end.startsWith("<")) {
                    ++bracketCount;
                }
                if (end.startsWith(">")) {
                    --bracketCount;
                }
                end = end.substring(1, end.length());
            }
            signature = start + end;
        }
        while (((String)signature).contains(";")) {
            idx = ((String)signature).indexOf(";");
            if (((String)signature).startsWith("T")) {
                String name = ((String)signature).substring(1, idx);
                TypeParameter typeParameter = null;
                for (TypeParameter cand : method.getTypeParameters()) {
                    if (!cand.getName().equals(name)) continue;
                    typeParameter = cand;
                }
                if (typeParameter == null) {
                    for (TypeParameter cand : emfClassifier.getTypeParameters()) {
                        if (!cand.getName().equals(name)) continue;
                        typeParameter = cand;
                    }
                }
                if (typeParameter == null) {
                    return result;
                }
                ClassifierReference classifierReference = TypesFactory.eINSTANCE.createClassifierReference();
                classifierReference.setTarget(typeParameter);
                result.add((Object)classifierReference);
            } else {
                result.add(null);
            }
            signature = ((String)signature).substring(((String)signature).indexOf(";") + 1);
        }
        return result;
    }

    private EList<TypeParameter> constructTypeParameters(String signature) {
        BasicEList result = new BasicEList();
        if (signature.contains("((") || !signature.contains("<")) {
            return result;
        }
        int endIdx = (signature = signature.substring(signature.indexOf("<") + 1)).indexOf(">(");
        if (endIdx > 0) {
            signature = signature.substring(0, endIdx);
        }
        while (signature.contains(":")) {
            int idx = signature.indexOf(":");
            String name = signature.substring(0, idx);
            if (!name.equals("")) {
                TypeParameter typeParameter = GenericsFactory.eINSTANCE.createTypeParameter();
                typeParameter.setName(name);
                result.add((Object)typeParameter);
            }
            signature = signature.substring(idx + 1);
            int sepIdx = signature.indexOf(";");
            int colonIdx = signature.indexOf(":");
            while (sepIdx < colonIdx && sepIdx > 0) {
                signature = signature.substring(sepIdx + 1);
                sepIdx = signature.indexOf(";");
                colonIdx = signature.indexOf(":");
            }
        }
        return result;
    }

    private TypeReference createReferenceToType(String signature) {
        Byte emfTypeReference = null;
        while (signature.startsWith("[")) {
            signature = signature.substring(1);
        }
        switch (signature.charAt(0)) {
            case 'B': {
                emfTypeReference = TypesFactory.eINSTANCE.createByte();
                break;
            }
            case 'C': {
                emfTypeReference = TypesFactory.eINSTANCE.createChar();
                break;
            }
            case 'D': {
                emfTypeReference = TypesFactory.eINSTANCE.createDouble();
                break;
            }
            case 'F': {
                emfTypeReference = TypesFactory.eINSTANCE.createFloat();
                break;
            }
            case 'I': {
                emfTypeReference = TypesFactory.eINSTANCE.createInt();
                break;
            }
            case 'J': {
                emfTypeReference = TypesFactory.eINSTANCE.createLong();
                break;
            }
            case 'L': {
                String fullClassName = Utility.signatureToString((String)signature, (boolean)false);
                emfTypeReference = this.createReferenceToClassifier(fullClassName);
                break;
            }
            case 'S': {
                emfTypeReference = TypesFactory.eINSTANCE.createShort();
                break;
            }
            case 'Z': {
                emfTypeReference = TypesFactory.eINSTANCE.createBoolean();
                break;
            }
            case 'V': {
                emfTypeReference = TypesFactory.eINSTANCE.createVoid();
            }
        }
        return emfTypeReference;
    }

    private String constructTypeArguments(String s, ClassifierReference typeRef, TypeParametrizable method, ConcreteClassifier emfClassifier) {
        if ("".equals(s) || s == null) {
            return "";
        }
        char[] charArray = s.toCharArray();
        int bracketCount = 0;
        int begin = 0;
        int end = 0;
        if (charArray[0] != 'L' && charArray[0] != 'T' && charArray[0] != '+' && charArray[0] != '-') {
            return s.substring(1);
        }
        for (int i = 0; i < charArray.length; ++i) {
            char next = charArray[i];
            if (next == ';' && bracketCount == 0) {
                return s.substring(i + 1);
            }
            if (next == '<') {
                if (bracketCount == 0 && (charArray[begin = i + 1] == '+' || charArray[begin] == '-')) {
                    ++begin;
                }
                ++bracketCount;
            }
            if (next != '>' || --bracketCount != 0) continue;
            end = i - 1;
            int internalBracketCount = 0;
            int internalBegin = begin;
            int internalEnd = end;
            for (int j = begin; j < end + 1; ++j) {
                int followUpArgumentIdx = -1;
                char internalNext = charArray[j];
                if (internalNext == '<') {
                    ++internalBracketCount;
                    followUpArgumentIdx = j;
                }
                if (internalNext == '>') {
                    --internalBracketCount;
                }
                if (internalNext != ';' || internalBracketCount != 0) continue;
                internalEnd = j;
                if (charArray[internalBegin] == '*' || charArray[internalBegin] == '?') {
                    UnknownTypeArgument typeArgument = GenericsFactory.eINSTANCE.createUnknownTypeArgument();
                    if (typeRef != null) {
                        typeRef.getTypeArguments().add((Object)typeArgument);
                    }
                } else {
                    ClassifierReference argumentType;
                    String fullName = s.substring(internalBegin + 1, internalEnd);
                    if (followUpArgumentIdx != -1) {
                        fullName = s.substring(internalBegin + 1, followUpArgumentIdx);
                    }
                    if (charArray[internalBegin] == 'T') {
                        argumentType = this.constructTypeParameterReference(fullName, method, emfClassifier);
                    } else {
                        int idx = fullName.indexOf("<");
                        if (idx >= 0) {
                            fullName = fullName.substring(0, idx);
                        }
                        argumentType = (ClassifierReference)this.createReferenceToClassifier(fullName);
                    }
                    if (typeRef != null) {
                        UnknownTypeArgument typeArgument = null;
                        if (argumentType == null) {
                            typeArgument = GenericsFactory.eINSTANCE.createUnknownTypeArgument();
                        } else {
                            typeArgument = GenericsFactory.eINSTANCE.createQualifiedTypeArgument();
                            ((QualifiedTypeArgument)typeArgument).setTypeReference((TypeReference)argumentType);
                        }
                        typeRef.getTypeArguments().add((Object)typeArgument);
                    }
                    this.constructTypeArguments(s.substring(internalBegin, internalEnd), argumentType, method, emfClassifier);
                }
                internalBegin = j + 1;
                if (charArray[internalBegin] != '+' && charArray[internalBegin] != '-') continue;
                ++internalBegin;
            }
        }
        return "";
    }

    private TypeReference createReferenceToClassifier(String fullClassifierName) {
        fullClassifierName = fullClassifierName.replaceAll("/", ".");
        ConcreteClassifier classifier = JavaClasspath.get().getConcreteClassifier(fullClassifierName);
        ClassifierReference classifierReference = TypesFactory.eINSTANCE.createClassifierReference();
        classifierReference.setTarget((Classifier)classifier);
        return classifierReference;
    }

    private int getArrayDimension(String signature) {
        int arrayDimension = 0;
        while (signature.startsWith("[")) {
            signature = signature.substring(1);
            ++arrayDimension;
        }
        return arrayDimension;
    }

    private List<String> extractParameterNames(org.apache.bcel.classfile.Method method) {
        ArrayList<String> names = new ArrayList<String>();
        if (method.getLocalVariableTable() == null) {
            return names;
        }
        int start = method.isStatic() ? 0 : 1;
        int stop = method.isStatic() ? method.getArgumentTypes().length : method.getArgumentTypes().length + 1;
        LocalVariable[] variables = method.getLocalVariableTable().getLocalVariableTable();
        if (variables != null) {
            for (int i = start; i < stop && i < variables.length; ++i) {
                names.add(variables[i].getName());
            }
        }
        return names;
    }
}

