/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.model.java.extensions.variables;

import org.eclipse.emf.common.util.EList;
import tools.mdsd.jamopp.model.java.expressions.Expression;
import tools.mdsd.jamopp.model.java.members.MemberContainer;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.references.IdentifierReference;
import tools.mdsd.jamopp.model.java.references.MethodCall;
import tools.mdsd.jamopp.model.java.references.ReferencesFactory;
import tools.mdsd.jamopp.model.java.statements.ExpressionStatement;
import tools.mdsd.jamopp.model.java.statements.StatementsFactory;
import tools.mdsd.jamopp.model.java.types.Type;
import tools.mdsd.jamopp.model.java.variables.Variable;

public class VariableExtension {
    public static ExpressionStatement createMethodCallStatement(Variable me, String methodName, EList<Expression> arguments) {
        ExpressionStatement callStatement = StatementsFactory.eINSTANCE.createExpressionStatement();
        callStatement.setExpression(me.createMethodCall(methodName, arguments));
        return callStatement;
    }

    public static IdentifierReference createMethodCall(Variable me, String methodName, EList<Expression> arguments) {
        IdentifierReference thisRef = ReferencesFactory.eINSTANCE.createIdentifierReference();
        thisRef.setTarget(me);
        MethodCall methodCall = ReferencesFactory.eINSTANCE.createMethodCall();
        Type thisType = me.getTypeReference().getTarget();
        if (thisType instanceof MemberContainer) {
            MemberContainer castedType = (MemberContainer)((Object)thisType);
            Method method = castedType.getContainedMethod(methodName);
            if (method == null) {
                return null;
            }
            methodCall.setTarget(method);
            methodCall.getArguments().addAll(arguments);
            thisRef.setNext(methodCall);
            return thisRef;
        }
        return null;
    }
}

