/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.model.java.extensions.types;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import tools.mdsd.jamopp.model.java.arrays.ArrayTypeable;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.generics.ExtendsTypeArgument;
import tools.mdsd.jamopp.model.java.generics.QualifiedTypeArgument;
import tools.mdsd.jamopp.model.java.generics.SuperTypeArgument;
import tools.mdsd.jamopp.model.java.generics.TypeArgument;
import tools.mdsd.jamopp.model.java.generics.TypeParameter;
import tools.mdsd.jamopp.model.java.references.ElementReference;
import tools.mdsd.jamopp.model.java.references.MethodCall;
import tools.mdsd.jamopp.model.java.references.Reference;
import tools.mdsd.jamopp.model.java.references.ReferenceableElement;
import tools.mdsd.jamopp.model.java.types.ClassifierReference;
import tools.mdsd.jamopp.model.java.types.InferableType;
import tools.mdsd.jamopp.model.java.types.NamespaceClassifierReference;
import tools.mdsd.jamopp.model.java.types.PrimitiveType;
import tools.mdsd.jamopp.model.java.types.Type;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.model.java.types.TypesFactory;
import tools.mdsd.jamopp.model.java.util.TemporalCompositeTypeReference;

public class TypeReferenceExtension {
    public static Type getTarget(TypeReference me) {
        return me.getBoundTarget(null);
    }

    public static void setTarget(TypeReference me, Classifier type) {
        if (type == null) {
            return;
        }
        if (type.eIsProxy()) {
            return;
        }
        if (me instanceof NamespaceClassifierReference) {
            NamespaceClassifierReference nsClassifierReference = (NamespaceClassifierReference)me;
            nsClassifierReference.getClassifierReferences().clear();
            nsClassifierReference.getNamespaces().clear();
            nsClassifierReference.getNamespaces().addAll(type.getContainingContainerName());
            ClassifierReference classifierRef = TypesFactory.eINSTANCE.createClassifierReference();
            classifierRef.setTarget(type);
            nsClassifierReference.getClassifierReferences().add((Object)classifierRef);
        } else if (me instanceof ClassifierReference) {
            ClassifierReference ref = (ClassifierReference)me;
            ref.setTarget(type);
        } else if (me instanceof InferableType) {
            InferableType ref = (InferableType)me;
            ref.getArrayDimensionsBefore().clear();
            ref.getActualTargets().clear();
            ClassifierReference newRef = TypesFactory.eINSTANCE.createClassifierReference();
            newRef.setTarget(type);
            ref.getActualTargets().add((Object)newRef);
        }
    }

    public static Type getBoundTarget(TypeReference me, Reference reference) {
        TypeReference ref = me.getBoundTargetReference(reference);
        if (ref != null) {
            if (ref instanceof TemporalCompositeTypeReference) {
                return ((TemporalCompositeTypeReference)ref).asType();
            }
            if (ref instanceof PrimitiveType) {
                return (PrimitiveType)ref;
            }
            return ref.getTarget();
        }
        return null;
    }

    public static TypeReference getBoundTargetReference(TypeReference me, Reference reference) {
        TypeReference type = null;
        if (me instanceof ClassifierReference || me instanceof NamespaceClassifierReference) {
            ElementReference prevRef;
            MethodCall potentialCloneCall;
            ReferenceableElement potentialCloneCallTarget;
            ClassifierReference classifierRef = me.getPureClassifierReference();
            if (classifierRef != null) {
                type = classifierRef;
            }
            if (reference instanceof MethodCall && (potentialCloneCallTarget = (potentialCloneCall = (MethodCall)reference).getTarget()) != null && !potentialCloneCallTarget.eIsProxy() && "clone".equals(potentialCloneCallTarget.getName()) && potentialCloneCall.getPrevious() instanceof ElementReference && (prevRef = (ElementReference)potentialCloneCall.getPrevious()).getTarget() instanceof ArrayTypeable && ((ArrayTypeable)((Object)prevRef.getTarget())).getArrayDimension() > 0L) {
                type = prevRef.getReferencedTypeReference();
            }
        } else if (me instanceof PrimitiveType) {
            return (PrimitiveType)me;
        }
        if (type != null && type.getTarget() instanceof TypeParameter) {
            type = ((TypeParameter)type.getTarget()).getBoundTypeReference(me, reference);
        }
        if (type != null && type.getTarget() != null && type.getTarget().eIsProxy()) {
            return null;
        }
        return type;
    }

    public static TypeReference getTypeReferenceOfTypeArgument(TypeReference ref, int index) {
        ClassifierReference actualRef = ref.getPureClassifierReference();
        if (actualRef == null) {
            return null;
        }
        TypeArgument arg = (TypeArgument)actualRef.getTypeArguments().get(index);
        return TypeReferenceExtension.getTypeReferenceOfTypeArgument(arg);
    }

    public static TypeReference getTypeReferenceOfTypeArgument(TypeArgument arg) {
        if (arg instanceof QualifiedTypeArgument) {
            QualifiedTypeArgument qual = (QualifiedTypeArgument)arg;
            return qual.getTypeReference();
        }
        if (arg instanceof ExtendsTypeArgument) {
            ExtendsTypeArgument qual = (ExtendsTypeArgument)arg;
            return qual.getExtendType();
        }
        if (arg instanceof SuperTypeArgument) {
            SuperTypeArgument qual = (SuperTypeArgument)arg;
            return qual.getSuperType();
        }
        return null;
    }

    public static TypeReference convertToTypeReference(EObject obj) {
        if (obj instanceof TypeReference) {
            return (TypeReference)obj;
        }
        if (obj instanceof Classifier) {
            ClassifierReference ref = TypesFactory.eINSTANCE.createClassifierReference();
            ref.setTarget((Classifier)obj);
            return ref;
        }
        return null;
    }

    public static TypeReference clone(TypeReference me) {
        if (me.eContainer() == null) {
            return me;
        }
        return (TypeReference)EcoreUtil.copy((EObject)me);
    }

    public static ClassifierReference getPureClassifierReference(TypeReference me) {
        InferableType t;
        NamespaceClassifierReference nsClassifierReference;
        ClassifierReference classifierReference = null;
        if (me instanceof ClassifierReference) {
            classifierReference = (ClassifierReference)me;
        }
        if (me instanceof NamespaceClassifierReference && !(nsClassifierReference = (NamespaceClassifierReference)me).getClassifierReferences().isEmpty()) {
            int lastIndex = nsClassifierReference.getClassifierReferences().size() - 1;
            classifierReference = (ClassifierReference)nsClassifierReference.getClassifierReferences().get(lastIndex);
        }
        if (me instanceof InferableType && (t = (InferableType)me).getActualTargets().size() > 0) {
            return ((TypeReference)t.getActualTargets().get(0)).getPureClassifierReference();
        }
        return classifierReference;
    }
}

