/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.model.java.extensions.references;

import tools.mdsd.jamopp.model.java.classifiers.AnonymousClass;
import tools.mdsd.jamopp.model.java.classifiers.Class;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Enumeration;
import tools.mdsd.jamopp.model.java.expressions.NestedExpression;
import tools.mdsd.jamopp.model.java.extensions.types.TypeReferenceExtension;
import tools.mdsd.jamopp.model.java.generics.ExtendsTypeArgument;
import tools.mdsd.jamopp.model.java.generics.QualifiedTypeArgument;
import tools.mdsd.jamopp.model.java.generics.SuperTypeArgument;
import tools.mdsd.jamopp.model.java.generics.TypeArgument;
import tools.mdsd.jamopp.model.java.generics.TypeArgumentable;
import tools.mdsd.jamopp.model.java.generics.TypeParameter;
import tools.mdsd.jamopp.model.java.instantiations.ExplicitConstructorCall;
import tools.mdsd.jamopp.model.java.literals.Literal;
import tools.mdsd.jamopp.model.java.literals.Super;
import tools.mdsd.jamopp.model.java.literals.This;
import tools.mdsd.jamopp.model.java.members.AdditionalField;
import tools.mdsd.jamopp.model.java.members.EnumConstant;
import tools.mdsd.jamopp.model.java.references.ElementReference;
import tools.mdsd.jamopp.model.java.references.PrimitiveTypeReference;
import tools.mdsd.jamopp.model.java.references.Reference;
import tools.mdsd.jamopp.model.java.references.ReferenceableElement;
import tools.mdsd.jamopp.model.java.references.ReflectiveClassReference;
import tools.mdsd.jamopp.model.java.references.SelfReference;
import tools.mdsd.jamopp.model.java.references.StringReference;
import tools.mdsd.jamopp.model.java.references.TextBlockReference;
import tools.mdsd.jamopp.model.java.types.ClassifierReference;
import tools.mdsd.jamopp.model.java.types.InferableType;
import tools.mdsd.jamopp.model.java.types.Type;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.model.java.types.TypedElement;
import tools.mdsd.jamopp.model.java.util.TemporalCompositeTypeReference;
import tools.mdsd.jamopp.model.java.variables.AdditionalLocalVariable;

public class ReferenceExtension {
    public static Reference getPrevious(Reference me) {
        Reference container;
        if (me.eContainer() instanceof Reference && me.equals((container = (Reference)me.eContainer()).getNext())) {
            return container;
        }
        return null;
    }

    public static Type getReferencedType(Reference me) {
        TypeReference ref = ReferenceExtension.getReferencedTypeReference(me);
        if (ref != null) {
            ref = ref.getBoundTargetReference(me);
        }
        if (ref instanceof TemporalCompositeTypeReference) {
            return ((TemporalCompositeTypeReference)ref).asType();
        }
        return ref == null ? null : ref.getTarget();
    }

    public static TypeReference getReferencedTypeReference(Reference me) {
        if (me.getActualTargets().size() > 0) {
            return (TypeReference)me.getActualTargets().get(0);
        }
        if (me instanceof Literal) {
            return TypeReferenceExtension.convertToTypeReference(((Literal)((Object)me)).getType());
        }
        TypeReference type = null;
        if (me instanceof TypedElement) {
            type = ((TypedElement)((Object)me)).getTypeReference();
        } else if (me instanceof SelfReference) {
            TypeReference thisClassRef = null;
            Type thisClass = null;
            if (me.getPrevious() != null) {
                thisClassRef = me.getPrevious().getReferencedTypeReference();
                thisClass = thisClassRef.getTarget();
            } else {
                AnonymousClass anonymousContainer = me.getContainingAnonymousClass();
                thisClass = anonymousContainer != null ? anonymousContainer : me.getContainingConcreteClassifier();
            }
            if (((SelfReference)me).getSelf() instanceof Super) {
                if (thisClass instanceof Class) {
                    return TypeReferenceExtension.convertToTypeReference(((Class)thisClass).getSuperClass());
                }
                if (thisClass instanceof AnonymousClass) {
                    return TypeReferenceExtension.convertToTypeReference(((AnonymousClass)thisClass).getSuperClassifier());
                }
            }
            type = thisClassRef != null ? thisClassRef : TypeReferenceExtension.convertToTypeReference(thisClass);
        } else {
            if (me instanceof ReflectiveClassReference) {
                return TypeReferenceExtension.convertToTypeReference(me.getClassClass());
            }
            if (me instanceof ElementReference) {
                ReferenceableElement target = ((ElementReference)me).getTarget();
                if (target == null) {
                    return null;
                }
                if (target.eIsProxy()) {
                    type = null;
                }
                if (target instanceof AdditionalLocalVariable) {
                    target = (ReferenceableElement)target.eContainer();
                }
                if (target instanceof AdditionalField) {
                    target = (ReferenceableElement)target.eContainer();
                }
                if (target instanceof TypedElement) {
                    type = ((TypedElement)((Object)target)).getTypeReference();
                    if (type != null && !(type instanceof InferableType)) {
                        TypeReference clonedType = TypeReferenceExtension.clone(type);
                        if ((clonedType = ReferenceExtension.resolveAllTypeParameters(clonedType, (ElementReference)me, type)) != null) {
                            me.getActualTargets().add((Object)clonedType);
                            type = clonedType;
                        }
                    }
                } else {
                    if (target instanceof Type) {
                        return TypeReferenceExtension.convertToTypeReference((Type)((Object)target));
                    }
                    if (target instanceof EnumConstant) {
                        type = TypeReferenceExtension.convertToTypeReference((Enumeration)target.eContainer());
                    }
                }
            } else {
                if (me instanceof StringReference || me instanceof TextBlockReference) {
                    return TypeReferenceExtension.convertToTypeReference(me.getStringClass());
                }
                if (me instanceof NestedExpression) {
                    type = ((NestedExpression)me).getExpression().getOneTypeReference(false);
                } else if (me instanceof PrimitiveTypeReference) {
                    type = ((PrimitiveTypeReference)me).getPrimitiveType();
                } else if (me instanceof ExplicitConstructorCall) {
                    ExplicitConstructorCall exCall = (ExplicitConstructorCall)me;
                    ConcreteClassifier thisClass = me.getContainingConcreteClassifier();
                    if (exCall.getCallTarget() instanceof This) {
                        return TypeReferenceExtension.convertToTypeReference(thisClass);
                    }
                    if (thisClass instanceof Class) {
                        return TypeReferenceExtension.convertToTypeReference(((Class)thisClass).getSuperClass());
                    }
                } else assert (false);
            }
        }
        return type;
    }

    private static TypeReference resolveAllTypeParameters(TypeReference type, ElementReference me, TypeReference original) {
        Type t = original.getTarget();
        if (t instanceof TypeParameter) {
            TypeReference boundRef = ((TypeParameter)t).getBoundTypeReference(original, me);
            if (boundRef == null || boundRef.getTarget() == null || boundRef.getTarget().equals(t)) {
                return null;
            }
            return TypeReferenceExtension.clone(boundRef);
        }
        ClassifierReference classRef = type.getPureClassifierReference();
        ClassifierReference originalClassRef = original.getPureClassifierReference();
        if (classRef instanceof TypeArgumentable) {
            ClassifierReference typeArg = classRef;
            ClassifierReference originalTypeArg = originalClassRef;
            for (int index = 0; index < typeArg.getTypeArguments().size(); ++index) {
                TypeArgument typeArgument = (TypeArgument)typeArg.getTypeArguments().get(index);
                TypeArgument originalTypeArgument = (TypeArgument)originalTypeArg.getTypeArguments().get(index);
                TypeReference argRef = TypeReferenceExtension.getTypeReferenceOfTypeArgument(typeArgument);
                TypeReference originalArgRef = TypeReferenceExtension.getTypeReferenceOfTypeArgument(originalTypeArgument);
                if (argRef == null) continue;
                TypeReference resolved = ReferenceExtension.resolveAllTypeParameters(argRef, me, originalArgRef);
                if (resolved != null) {
                    resolved = TypeReferenceExtension.clone(resolved);
                    ReferenceExtension.setTypeReferenceOfTypeArgument(typeArgument, resolved);
                    continue;
                }
                return null;
            }
        }
        return type;
    }

    private static void setTypeReferenceOfTypeArgument(TypeArgument arg, TypeReference ref) {
        if (arg instanceof QualifiedTypeArgument) {
            ((QualifiedTypeArgument)arg).setTypeReference(ref);
        } else if (arg instanceof SuperTypeArgument) {
            ((SuperTypeArgument)arg).setSuperType(ref);
        } else if (arg instanceof ExtendsTypeArgument) {
            ((ExtendsTypeArgument)arg).setExtendType(ref);
        }
    }
}

