/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.model.java.extensions.modifiers;

import java.util.ArrayList;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import tools.mdsd.jamopp.model.java.annotations.AnnotationInstance;
import tools.mdsd.jamopp.model.java.classifiers.AnonymousClass;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Interface;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.literals.Self;
import tools.mdsd.jamopp.model.java.members.Field;
import tools.mdsd.jamopp.model.java.modifiers.AnnotableAndModifiable;
import tools.mdsd.jamopp.model.java.modifiers.AnnotationInstanceOrModifier;
import tools.mdsd.jamopp.model.java.modifiers.Modifier;
import tools.mdsd.jamopp.model.java.modifiers.ModifiersFactory;
import tools.mdsd.jamopp.model.java.modifiers.Private;
import tools.mdsd.jamopp.model.java.modifiers.Protected;
import tools.mdsd.jamopp.model.java.modifiers.Public;
import tools.mdsd.jamopp.model.java.modifiers.Static;
import tools.mdsd.jamopp.model.java.references.Reference;
import tools.mdsd.jamopp.model.java.references.SelfReference;
import tools.mdsd.jamopp.model.java.types.Type;

public class AnnotableAndModifiableExtension {
    public static void makePrivate(AnnotableAndModifiable me) {
        if (me.isPrivate()) {
            return;
        }
        me.removeModifier(Public.class);
        me.removeModifier(Protected.class);
        me.getAnnotationsAndModifiers().add((Object)ModifiersFactory.eINSTANCE.createPrivate());
    }

    public static void makePublic(AnnotableAndModifiable me) {
        if (me.isPublic()) {
            return;
        }
        me.removeModifier(Private.class);
        me.removeModifier(Protected.class);
        me.getAnnotationsAndModifiers().add((Object)ModifiersFactory.eINSTANCE.createPublic());
    }

    public static void makeProtected(AnnotableAndModifiable me) {
        if (me.isProtected()) {
            return;
        }
        me.removeModifier(Private.class);
        me.removeModifier(Public.class);
        me.getAnnotationsAndModifiers().add((Object)ModifiersFactory.eINSTANCE.createProtected());
    }

    public static void removeAllModifiers(AnnotableAndModifiable me) {
        EList<Modifier> modifiers = me.getModifiers();
        EList<AnnotationInstanceOrModifier> elements = me.getAnnotationsAndModifiers();
        elements.removeAll(modifiers);
    }

    public static EList<Modifier> getModifiers(AnnotableAndModifiable me) {
        EList<AnnotationInstanceOrModifier> elements = me.getAnnotationsAndModifiers();
        BasicEList modifiers = new BasicEList();
        for (AnnotationInstanceOrModifier next : elements) {
            if (!(next instanceof Modifier)) continue;
            modifiers.add((Object)((Modifier)next));
        }
        return ECollections.unmodifiableEList((EList)modifiers);
    }

    public static EList<AnnotationInstance> getAnnotationInstances(AnnotableAndModifiable me) {
        EList<AnnotationInstanceOrModifier> elements = me.getAnnotationsAndModifiers();
        BasicEList annotations = new BasicEList();
        for (AnnotationInstanceOrModifier next : elements) {
            if (!(next instanceof AnnotationInstance)) continue;
            annotations.add((Object)((AnnotationInstance)next));
        }
        return ECollections.unmodifiableEList((EList)annotations);
    }

    public static void addModifier(AnnotableAndModifiable me, Modifier newModifier) {
        me.getAnnotationsAndModifiers().add((Object)newModifier);
    }

    public static void removeModifier(AnnotableAndModifiable me, Class<?> modifierType) {
        EList<AnnotationInstanceOrModifier> modifiers = me.getAnnotationsAndModifiers();
        ArrayList<AnnotationInstanceOrModifier> modifiersToRemove = new ArrayList<AnnotationInstanceOrModifier>();
        for (AnnotationInstanceOrModifier modifier : modifiers) {
            if (!modifierType.isInstance(modifier)) continue;
            modifiersToRemove.add(modifier);
        }
        modifiers.removeAll(modifiersToRemove);
    }

    public static boolean isPublic(AnnotableAndModifiable me) {
        return me.hasModifier(Public.class);
    }

    public static boolean isPrivate(AnnotableAndModifiable me) {
        return me.hasModifier(Private.class);
    }

    public static boolean isProtected(AnnotableAndModifiable me) {
        return me.hasModifier(Protected.class);
    }

    public static boolean hasModifier(AnnotableAndModifiable me, Class<?> type) {
        EList<AnnotationInstanceOrModifier> modifiers = me.getAnnotationsAndModifiers();
        for (AnnotationInstanceOrModifier modifier : modifiers) {
            if (!type.isInstance(modifier)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStatic(AnnotableAndModifiable me) {
        if (me.eContainer() instanceof Interface && (me.hasModifier(Static.class) || me instanceof Field || me instanceof ConcreteClassifier)) {
            return true;
        }
        for (AnnotationInstanceOrModifier modifier : me.getAnnotationsAndModifiers()) {
            if (!(modifier instanceof Static)) continue;
            return true;
        }
        return false;
    }

    public static boolean isHidden(AnnotableAndModifiable me, Commentable context) {
        Type type;
        SelfReference selfReference;
        Commentable lContext = context;
        if (me.eIsProxy()) {
            return false;
        }
        if (me.eContainer() instanceof Interface) {
            return false;
        }
        if (lContext.eIsProxy()) {
            lContext = (Commentable)EcoreUtil.resolve((EObject)lContext, (EObject)me);
        }
        ConcreteClassifier lContextClassifier = lContext.getContainingConcreteClassifier();
        if (!(me.eContainer() instanceof Commentable)) {
            return true;
        }
        ConcreteClassifier myClassifier = ((Commentable)me.eContainer()).getParentConcreteClassifier();
        if (lContext instanceof Reference && ((Reference)lContext).getPrevious() instanceof SelfReference && (selfReference = (SelfReference)((Reference)lContext).getPrevious()).getSelf() instanceof Self && selfReference.getPrevious() != null && (type = selfReference.getPrevious().getReferencedType()) instanceof ConcreteClassifier) {
            lContextClassifier = (ConcreteClassifier)type;
        }
        for (AnnotationInstanceOrModifier modifier : me.getAnnotationsAndModifiers()) {
            if (modifier instanceof Private) {
                return !myClassifier.equalsType(0L, lContextClassifier, 0L);
            }
            if (modifier instanceof Public) {
                return false;
            }
            if (!(modifier instanceof Protected)) continue;
            if (me.getContainingPackageName() != null && me.getContainingPackageName().equals(lContext.getContainingPackageName())) {
                return false;
            }
            while (lContextClassifier instanceof Classifier) {
                if (lContextClassifier.isSuperType(0L, myClassifier, null)) {
                    return false;
                }
                EObject container = lContextClassifier.eContainer();
                if ((lContextClassifier = container instanceof Commentable ? ((Commentable)container).getParentConcreteClassifier() : null) == null || lContextClassifier.eIsProxy() || !lContextClassifier.isSuperType(0L, myClassifier, null)) continue;
                return false;
            }
            AnonymousClass anonymousClass = lContext.getContainingAnonymousClass();
            while (anonymousClass != null) {
                lContextClassifier = anonymousClass.getSuperClassifier();
                if (lContextClassifier == null) {
                    return true;
                }
                if (lContextClassifier.isSuperType(0L, myClassifier, null)) {
                    return false;
                }
                EObject container = anonymousClass.eContainer();
                if (container instanceof Commentable) {
                    anonymousClass = ((Commentable)container).getContainingAnonymousClass();
                    continue;
                }
                anonymousClass = null;
            }
            return true;
        }
        return me.getContainingPackageName() == null || !me.getContainingPackageName().equals(lContext.getContainingPackageName());
    }
}

