/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.model.java.extensions.members;

import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Interface;
import tools.mdsd.jamopp.model.java.expressions.Expression;
import tools.mdsd.jamopp.model.java.expressions.LambdaExpression;
import tools.mdsd.jamopp.model.java.extensions.types.TypeReferenceExtension;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.parameters.OrdinaryParameter;
import tools.mdsd.jamopp.model.java.parameters.Parameter;
import tools.mdsd.jamopp.model.java.parameters.ParametersFactory;
import tools.mdsd.jamopp.model.java.parameters.ReceiverParameter;
import tools.mdsd.jamopp.model.java.parameters.VariableLengthParameter;
import tools.mdsd.jamopp.model.java.references.MethodCall;
import tools.mdsd.jamopp.model.java.statements.Block;
import tools.mdsd.jamopp.model.java.statements.Statement;
import tools.mdsd.jamopp.model.java.types.Type;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.model.java.util.TemporalUnknownType;

public class MethodExtension {
    public static boolean isSomeMethodForCall(Method me, MethodCall methodCall) {
        return me.isMethodForCall(methodCall, false);
    }

    public static boolean isBetterMethodForCall(Method me, Method otherMethod, MethodCall methodCall) {
        if (!me.isMethodForCall(methodCall, false)) {
            return false;
        }
        if (otherMethod.isMethodForCall(methodCall, true)) {
            Type target;
            return me.isMethodForCall(methodCall, true) && (target = me.getTypeReference().getTarget()) instanceof ConcreteClassifier && ((ConcreteClassifier)target).getAllSuperClassifiers().contains((Object)otherMethod.getTypeReference().getTarget());
        }
        if (!otherMethod.isMethodForCall(methodCall, false)) {
            return true;
        }
        return me.isMethodForCall(methodCall, true);
    }

    public static boolean isMethodForCall(Method me, MethodCall methodCall, boolean needsPerfectMatch) {
        EList argumentTypeList = methodCall.getArgumentTypes();
        BasicEList parameterList = new BasicEList((Collection)me.getParameters());
        if (parameterList.size() > 0 && parameterList.get(0) instanceof ReceiverParameter) {
            parameterList.remove(0);
        }
        BasicEList parameterTypeList = new BasicEList();
        for (Parameter parameter : parameterList) {
            TypeReference typeReference = parameter.getTypeReference();
            Type boundTarget = typeReference.getBoundTarget(methodCall);
            parameterTypeList.add((Object)boundTarget);
        }
        if (!parameterList.isEmpty()) {
            Parameter lastParameter = (Parameter)parameterList.get(parameterList.size() - 1);
            Type lastParameterType = (Type)parameterTypeList.get(parameterTypeList.size() - 1);
            if (lastParameter instanceof VariableLengthParameter) {
                while (parameterList.size() < argumentTypeList.size()) {
                    if (needsPerfectMatch) {
                        return false;
                    }
                    parameterList.add((Object)lastParameter);
                    parameterTypeList.add((Object)lastParameterType);
                }
                if (parameterList.size() > argumentTypeList.size()) {
                    if (needsPerfectMatch) {
                        return false;
                    }
                    parameterList.remove((Object)lastParameter);
                    parameterTypeList.remove(parameterTypeList.size() - 1);
                }
            }
        }
        if (parameterList.size() == argumentTypeList.size()) {
            boolean parametersMatch = true;
            for (int i = 0; i < argumentTypeList.size() && parametersMatch; ++i) {
                Parameter parameter = (Parameter)parameterList.get(i);
                Expression argument = (Expression)methodCall.getArguments().get(i);
                Type parameterType = (Type)parameterTypeList.get(i);
                Type argumentType = (Type)argumentTypeList.get(i);
                if (argumentType == null || parameterType == null) {
                    return false;
                }
                if (!parameterType.eIsProxy() || !argumentType.eIsProxy()) {
                    if (argumentType instanceof TemporalUnknownType) {
                        LambdaExpression lambda;
                        LambdaExpression lambdaExpression = lambda = argument instanceof LambdaExpression ? (LambdaExpression)argument : argument.getFirstChildByType(LambdaExpression.class);
                        if (lambda == null) continue;
                        if (!(parameterType instanceof Interface)) {
                            return false;
                        }
                        Method absMeth = ((Interface)parameterType).getAbstractMethodOfFunctionalInterface();
                        if (absMeth.getParameters().size() == lambda.getParameters().getParameters().size()) continue;
                        return false;
                    }
                    long argumentArrayDimension = argument.getArrayDimension();
                    if (needsPerfectMatch) {
                        long parameterArrayDimension = parameter.getTypeReference().getArrayDimension();
                        parametersMatch = parametersMatch && argumentType.equalsType(argumentArrayDimension, parameterType, parameterArrayDimension);
                        continue;
                    }
                    parametersMatch = parametersMatch && argumentType.isSuperType(argumentArrayDimension, parameterType, parameter.getTypeReference());
                    continue;
                }
                return false;
            }
            return parametersMatch;
        }
        return false;
    }

    public static boolean isSignatureMatching(Method one, Method two) {
        return MethodExtension.isSignatureMatching(one, two, null);
    }

    public static boolean isSignatureMatching(Method one, Method two, Type twoFirstParameter) {
        BasicEList parameterListOne = new BasicEList((Collection)one.getParameters());
        BasicEList parameterListTwo = new BasicEList((Collection)two.getParameters());
        if (parameterListOne.size() > 0 && parameterListOne.get(0) instanceof ReceiverParameter) {
            parameterListOne.remove(0);
        }
        if (parameterListTwo.size() > 0 && parameterListTwo.get(0) instanceof ReceiverParameter) {
            parameterListTwo.remove(0);
        }
        if (twoFirstParameter != null) {
            OrdinaryParameter p = ParametersFactory.eINSTANCE.createOrdinaryParameter();
            p.setTypeReference(TypeReferenceExtension.convertToTypeReference(twoFirstParameter));
            parameterListTwo.add(0, (Object)p);
        }
        if (parameterListOne.size() == parameterListTwo.size()) {
            boolean parametersMatch = true;
            for (int i = 0; i < parameterListOne.size() && parametersMatch; ++i) {
                Parameter paramOne = (Parameter)parameterListOne.get(i);
                Parameter paramTwo = (Parameter)parameterListTwo.get(i);
                Type parameterType = paramOne.getTypeReference().getTarget();
                Type argumentType = paramTwo.getTypeReference().getTarget();
                if (argumentType == null || parameterType == null) {
                    return false;
                }
                if (parameterType.eIsProxy() && argumentType.eIsProxy()) {
                    return false;
                }
                parametersMatch = parametersMatch && parameterType.isSuperType(paramOne.getTypeReference().getArrayDimension(), argumentType, paramTwo.getTypeReference());
            }
            Type target = one.getTypeReference().getTarget();
            parametersMatch = parametersMatch && target.isSuperType(one.getTypeReference().getArrayDimension(), two.getTypeReference().getTarget(), two.getTypeReference());
            return parametersMatch;
        }
        return false;
    }

    @Deprecated
    public static EList<Statement> getStatements(Method me) {
        Block b = MethodExtension.getBlock(me);
        return b != null ? b.getStatements() : new BasicEList();
    }

    public static Block getBlock(Method me) {
        if (me.getStatement() instanceof Block) {
            return (Block)me.getStatement();
        }
        return null;
    }
}

