/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.model.java.extensions.members;

import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.members.Constructor;
import tools.mdsd.jamopp.model.java.members.Field;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.members.MemberContainer;
import tools.mdsd.jamopp.model.java.members.MembersFactory;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.types.ClassifierReference;
import tools.mdsd.jamopp.model.java.types.TypesFactory;

public class MemberContainerExtension {
    public static EList<Method> getMethods(MemberContainer me) {
        BasicEList methodList = new BasicEList();
        for (Member member : me.getMembers()) {
            if (!(member instanceof Method)) continue;
            methodList.add((Object)((Method)member));
        }
        return ECollections.unmodifiableEList((EList)methodList);
    }

    public static EList<Field> getFields(MemberContainer me) {
        BasicEList fieldList = new BasicEList();
        for (Member member : me.getMembers()) {
            if (!(member instanceof Field)) continue;
            fieldList.add((Object)((Field)member));
        }
        return ECollections.unmodifiableEList((EList)fieldList);
    }

    public static EList<Constructor> getConstructors(MemberContainer me) {
        BasicEList constructorList = new BasicEList();
        for (Member member : me.getMembers()) {
            if (!(member instanceof Constructor)) continue;
            constructorList.add((Object)((Constructor)member));
        }
        return ECollections.unmodifiableEList((EList)constructorList);
    }

    public static EList<Member> getMembersByName(MemberContainer me, String name) {
        BasicEList matchingMembers = new BasicEList();
        for (Member member : me.getMembers()) {
            if (!name.equals(member.getName())) continue;
            matchingMembers.add((Object)member);
        }
        return ECollections.unmodifiableEList((EList)matchingMembers);
    }

    public static void removeMethods(MemberContainer me, String name) {
        BasicEList methodsToRemove = new BasicEList();
        for (Member member : me.getMembers()) {
            if (!(member instanceof Method) || !name.equals(member.getName())) continue;
            methodsToRemove.add((Object)((Method)member));
        }
        me.getMembers().removeAll((Collection)methodsToRemove);
    }

    public static ConcreteClassifier getContainedClassifier(MemberContainer me, String name) {
        for (Member member : me.getMembers()) {
            if (!(member instanceof ConcreteClassifier) || !name.equals(member.getName())) continue;
            return (ConcreteClassifier)member;
        }
        for (Member member : me.getDefaultMembers()) {
            if (!(member instanceof ConcreteClassifier) || !name.equals(member.getName())) continue;
            return (ConcreteClassifier)member;
        }
        return null;
    }

    public static Field getContainedField(MemberContainer me, String name) {
        for (Member member : me.getMembers()) {
            if (!(member instanceof Field) || !name.equals(member.getName())) continue;
            return (Field)member;
        }
        for (Member member : me.getDefaultMembers()) {
            if (!(member instanceof Field) || !name.equals(member.getName())) continue;
            return (Field)member;
        }
        return null;
    }

    public static Method getContainedMethod(MemberContainer me, String name) {
        Method found = null;
        for (Member member : me.getMembers()) {
            if (!(member instanceof Method) || !name.equals(member.getName())) continue;
            if (found != null) {
                return null;
            }
            found = (Method)member;
        }
        for (Member member : me.getDefaultMembers()) {
            if (!(member instanceof Method) || !name.equals(member.getName())) continue;
            if (found != null) {
                return null;
            }
            found = (Method)member;
        }
        return found;
    }

    public static Field createField(MemberContainer me, String name, String qualifiedTypeName) {
        Field field = MembersFactory.eINSTANCE.createField();
        field.setName(name);
        ClassifierReference typeRef = TypesFactory.eINSTANCE.createClassifierReference();
        typeRef.setTarget(me.getConcreteClassifier(qualifiedTypeName));
        field.setTypeReference(typeRef);
        me.getMembers().add((Object)field);
        return field;
    }
}

