/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.model.java.extensions.members;

import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.expressions.Expression;
import tools.mdsd.jamopp.model.java.instantiations.Instantiation;
import tools.mdsd.jamopp.model.java.members.Constructor;
import tools.mdsd.jamopp.model.java.parameters.Parameter;
import tools.mdsd.jamopp.model.java.parameters.ReceiverParameter;
import tools.mdsd.jamopp.model.java.parameters.VariableLengthParameter;
import tools.mdsd.jamopp.model.java.statements.Statement;
import tools.mdsd.jamopp.model.java.types.Type;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.model.java.util.TemporalUnknownType;

public class ConstructorExtension {
    public static boolean isBetterConstructorForCall(Constructor co, Constructor other, Instantiation call) {
        if (ConstructorExtension.isConstructorForCall(other, call, true)) {
            return false;
        }
        if (ConstructorExtension.isConstructorForCall(other, call, false)) {
            return ConstructorExtension.isConstructorForCall(co, call, true);
        }
        return ConstructorExtension.isConstructorForCall(co, call, false);
    }

    public static boolean isConstructorForCall(Constructor co, Instantiation call, boolean needsPerfectMatch) {
        Type callType = call.getReferencedType();
        if (callType instanceof ConcreteClassifier) {
            if (!((ConcreteClassifier)callType).getMembers().contains((Object)co)) {
                return false;
            }
        } else {
            return false;
        }
        EList argumentTypeList = call.getArgumentTypes();
        BasicEList parameterList = new BasicEList((Collection)co.getParameters());
        if (parameterList.size() > 0 && parameterList.get(0) instanceof ReceiverParameter) {
            parameterList.remove(0);
        }
        BasicEList parameterTypeList = new BasicEList();
        for (Parameter parameter : parameterList) {
            TypeReference typeReference = parameter.getTypeReference();
            Type boundTarget = typeReference.getBoundTarget(call);
            parameterTypeList.add((Object)boundTarget);
        }
        if (!parameterList.isEmpty()) {
            Parameter lastParameter = (Parameter)parameterList.get(parameterList.size() - 1);
            Type lastParameterType = (Type)parameterTypeList.get(parameterTypeList.size() - 1);
            if (lastParameter instanceof VariableLengthParameter) {
                while (parameterList.size() < argumentTypeList.size()) {
                    if (needsPerfectMatch) {
                        return false;
                    }
                    parameterList.add((Object)lastParameter);
                    parameterTypeList.add((Object)lastParameterType);
                }
                if (parameterList.size() > argumentTypeList.size()) {
                    if (needsPerfectMatch) {
                        return false;
                    }
                    parameterList.remove((Object)lastParameter);
                    parameterTypeList.remove(parameterTypeList.size() - 1);
                }
            }
        }
        if (parameterList.size() == argumentTypeList.size()) {
            boolean parametersMatch = true;
            for (int i = 0; i < argumentTypeList.size(); ++i) {
                Parameter parameter = (Parameter)parameterList.get(i);
                Expression argument = (Expression)call.getArguments().get(i);
                Type parameterType = (Type)parameterTypeList.get(i);
                Type argumentType = (Type)argumentTypeList.get(i);
                if (argumentType == null || parameterType == null) {
                    return false;
                }
                if (!parameterType.eIsProxy() || !argumentType.eIsProxy()) {
                    if (argumentType instanceof TemporalUnknownType) continue;
                    long argumentArrayDimension = argument.getArrayDimension();
                    if (needsPerfectMatch) {
                        long parameterArrayDimension = parameter.getTypeReference().getArrayDimension();
                        parametersMatch = parametersMatch && argumentType.equalsType(argumentArrayDimension, parameterType, parameterArrayDimension);
                        continue;
                    }
                    parametersMatch = parametersMatch && argumentType.isSuperType(argumentArrayDimension, parameterType, parameter.getTypeReference());
                    continue;
                }
                return false;
            }
            return parametersMatch;
        }
        return false;
    }

    @Deprecated
    public static EList<Statement> getStatements(Constructor me) {
        return me.getBlock().getStatements();
    }
}

