/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.model.java.extensions.imports;

import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Enumeration;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.imports.Import;

public class ImportExtension {
    public static ConcreteClassifier getImportedClassifier(Import me, String name) {
        String containerName = me.getNamespacesAsString();
        if (containerName == null) {
            return null;
        }
        String fullQualifiedName = containerName + name;
        return me.getConcreteClassifier(fullQualifiedName);
    }

    public static EList<NamedElement> getImportedMembers(Import me) {
        ConcreteClassifier concreteClassifier = me.getClassifier();
        if (concreteClassifier == null || concreteClassifier.eIsProxy()) {
            return ECollections.emptyEList();
        }
        UniqueEList result = new UniqueEList();
        result.addAll(concreteClassifier.getAllMembers(me));
        if (concreteClassifier instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)concreteClassifier;
            result.addAll(enumeration.getConstants());
        }
        return result;
    }

    public static EList<ConcreteClassifier> getImportedClassifiers(Import me) {
        String containerName = me.getNamespacesAsString();
        if (containerName == null) {
            return ECollections.emptyEList();
        }
        return me.getConcreteClassifiers(containerName, "*");
    }
}

