/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.model.java.extensions.generics;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Interface;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.expressions.AssignmentExpression;
import tools.mdsd.jamopp.model.java.expressions.CastExpression;
import tools.mdsd.jamopp.model.java.expressions.ConditionalExpression;
import tools.mdsd.jamopp.model.java.expressions.ExplicitlyTypedLambdaParameters;
import tools.mdsd.jamopp.model.java.expressions.Expression;
import tools.mdsd.jamopp.model.java.expressions.LambdaExpression;
import tools.mdsd.jamopp.model.java.expressions.MethodReferenceExpression;
import tools.mdsd.jamopp.model.java.expressions.NestedExpression;
import tools.mdsd.jamopp.model.java.extensions.types.TypeReferenceExtension;
import tools.mdsd.jamopp.model.java.generics.QualifiedTypeArgument;
import tools.mdsd.jamopp.model.java.generics.TypeArgument;
import tools.mdsd.jamopp.model.java.generics.TypeArgumentable;
import tools.mdsd.jamopp.model.java.generics.TypeParameter;
import tools.mdsd.jamopp.model.java.generics.TypeParametrizable;
import tools.mdsd.jamopp.model.java.instantiations.NewConstructorCall;
import tools.mdsd.jamopp.model.java.literals.Super;
import tools.mdsd.jamopp.model.java.members.AdditionalField;
import tools.mdsd.jamopp.model.java.members.Field;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.modifiers.AnnotableAndModifiable;
import tools.mdsd.jamopp.model.java.parameters.Parameter;
import tools.mdsd.jamopp.model.java.references.ElementReference;
import tools.mdsd.jamopp.model.java.references.MethodCall;
import tools.mdsd.jamopp.model.java.references.Reference;
import tools.mdsd.jamopp.model.java.references.ReferenceableElement;
import tools.mdsd.jamopp.model.java.references.ReflectiveClassReference;
import tools.mdsd.jamopp.model.java.references.SelfReference;
import tools.mdsd.jamopp.model.java.types.ClassifierReference;
import tools.mdsd.jamopp.model.java.types.InferableType;
import tools.mdsd.jamopp.model.java.types.PrimitiveType;
import tools.mdsd.jamopp.model.java.types.Type;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.model.java.types.TypedElement;
import tools.mdsd.jamopp.model.java.util.TemporalCompositeTypeReference;
import tools.mdsd.jamopp.model.java.variables.AdditionalLocalVariable;
import tools.mdsd.jamopp.model.java.variables.LocalVariable;

public class TypeParameterExtension {
    public static EList<ConcreteClassifier> getAllSuperClassifiers(TypeParameter me) {
        UniqueEList result = new UniqueEList();
        for (TypeReference typeRef : me.getExtendTypes()) {
            Type type = typeRef.getTarget();
            if (type instanceof ConcreteClassifier) {
                ConcreteClassifier concreteClassifier = (ConcreteClassifier)type;
                result.add((Object)concreteClassifier);
            }
            if (!(type instanceof Classifier)) continue;
            Classifier classifier = (Classifier)type;
            result.addAll(classifier.getAllSuperClassifiers());
        }
        return result;
    }

    public static EList<Member> getAllMembers(TypeParameter me, Commentable context) {
        UniqueEList memberList = new UniqueEList();
        UniqueEList possiblyVisibleSuperClassifier = new UniqueEList();
        for (TypeReference typeReference : me.getExtendTypes()) {
            Type target = typeReference.getTarget();
            possiblyVisibleSuperClassifier.add((Object)target);
        }
        for (ConcreteClassifier superClassifier : me.getAllSuperClassifiers()) {
            for (Member member : superClassifier.getMembers()) {
                if (member instanceof AnnotableAndModifiable) {
                    AnnotableAndModifiable modifiable = (AnnotableAndModifiable)((Object)member);
                    if (!modifiable.isHidden(context)) {
                        memberList.add((Object)member);
                        continue;
                    }
                    if (!possiblyVisibleSuperClassifier.contains((Object)superClassifier)) continue;
                    memberList.add((Object)member);
                    continue;
                }
                memberList.add((Object)member);
            }
            memberList.addAll((Collection)superClassifier.getDefaultMembers());
        }
        return memberList;
    }

    public static Type getBoundType(TypeParameter me, TypeReference typeReference, Reference reference) {
        TypeReference ref = me.getBoundTypeReference(typeReference, reference);
        if (ref != null) {
            if (ref instanceof TemporalCompositeTypeReference) {
                return ((TemporalCompositeTypeReference)ref).asType();
            }
            return ref.getTarget();
        }
        return null;
    }

    public static TypeReference getBoundTypeReference(TypeParameter me, TypeReference typeReference, Reference reference) {
        BasicEList resultList = new BasicEList();
        TypeParametrizable typeParameterDeclarator = (TypeParametrizable)me.eContainer();
        Reference parentReference = null;
        UniqueEList prevTypeList = new UniqueEList();
        if (reference != null && reference.getPrevious() instanceof NestedExpression) {
            NestedExpression nestedExpression = (NestedExpression)reference.getPrevious();
            Object expression = null;
            Expression nestedExpressionExpression = nestedExpression.getExpression();
            if (nestedExpressionExpression instanceof Reference) {
                expression = nestedExpressionExpression;
            } else if (nestedExpressionExpression instanceof ConditionalExpression) {
                ConditionalExpression conditionalExpression = (ConditionalExpression)nestedExpressionExpression;
                expression = conditionalExpression.getExpressionIf();
            }
            if (expression instanceof Reference) {
                Reference expressionReference = (Reference)expression;
                while (expressionReference.getNext() != null) {
                    expressionReference = expressionReference.getNext();
                }
                parentReference = expressionReference;
                TypeReference prevType = nestedExpressionExpression.getOneTypeReference(false);
                if (prevType instanceof TemporalCompositeTypeReference) {
                    for (TypeReference nextSuperType : ((TemporalCompositeTypeReference)prevType).getTypeReferences()) {
                        prevTypeList.add((Object)nextSuperType);
                    }
                } else {
                    prevTypeList.add((Object)prevType);
                }
            } else if (nestedExpressionExpression instanceof CastExpression) {
                CastExpression castExpression = (CastExpression)nestedExpressionExpression;
                prevTypeList.add((Object)castExpression.getTypeReference());
                for (TypeReference typeRef : castExpression.getAdditionalBounds()) {
                    prevTypeList.add((Object)typeRef);
                }
            }
        } else if (reference != null && reference.getPrevious() != null) {
            parentReference = reference.getPrevious();
            while (parentReference instanceof SelfReference && ((SelfReference)parentReference).getSelf() instanceof Super) {
                if (parentReference.eContainer() instanceof Reference) {
                    parentReference = (Reference)parentReference.eContainer();
                    continue;
                }
                containingClassifier = reference.getContainingConcreteClassifier();
                if (containingClassifier != null) {
                    prevTypeList.add((Object)TypeReferenceExtension.convertToTypeReference((EObject)containingClassifier));
                }
                parentReference = null;
            }
            if (parentReference != null) {
                TypeReference prevType = parentReference.getReferencedTypeReference();
                if (prevType instanceof TemporalCompositeTypeReference) {
                    for (TypeReference aType : ((TemporalCompositeTypeReference)prevType).getTypeReferences()) {
                        prevTypeList.add((Object)aType);
                    }
                } else {
                    prevTypeList.add((Object)prevType);
                }
            }
        } else if (reference != null) {
            containingClassifier = reference.getContainingConcreteClassifier();
            while (containingClassifier != null) {
                prevTypeList.add((Object)TypeReferenceExtension.convertToTypeReference((EObject)containingClassifier));
                EObject container = containingClassifier.eContainer();
                if (container instanceof Commentable) {
                    Commentable commentableContainer = (Commentable)container;
                    containingClassifier = commentableContainer.getContainingConcreteClassifier();
                    continue;
                }
                containingClassifier = null;
            }
        }
        for (TypeReference prevType : prevTypeList) {
            if (prevType == null) continue;
            int typeParameterIndex = -1;
            if (!(typeParameterDeclarator instanceof ConcreteClassifier)) continue;
            typeParameterIndex = typeParameterDeclarator.getTypeParameters().indexOf((Object)me);
            if (reference != null) {
                Type prevTypeTarget;
                TypeArgument arg;
                TypeReference theTypeRef;
                EList typeArgumentList;
                TypeReference prevParentReference;
                TypeReference prevTypeReference;
                ElementReference parentElementReference;
                ReferenceableElement prevReferenced;
                ClassifierReference classifierReference = null;
                if (parentReference instanceof ElementReference && (prevReferenced = (parentElementReference = (ElementReference)parentReference).getTarget()) instanceof TypedElement && (prevTypeReference = parentElementReference.getReferencedTypeReference()) != null) {
                    classifierReference = prevTypeReference.getPureClassifierReference();
                }
                if (parentReference instanceof TypedElement && (prevParentReference = ((TypedElement)((Object)parentReference)).getTypeReference()) != null) {
                    classifierReference = prevParentReference.getPureClassifierReference();
                }
                if (typeParameterIndex < (typeArgumentList = prevType instanceof TypeArgumentable ? ((TypeArgumentable)((Object)prevType)).getTypeArguments() : (classifierReference != null ? classifierReference.getTypeArguments() : ECollections.emptyEList())).size() && (theTypeRef = TypeReferenceExtension.getTypeReferenceOfTypeArgument(arg = (TypeArgument)typeArgumentList.get(typeParameterIndex))) != null) {
                    TypeReference theType = theTypeRef.getBoundTargetReference(parentReference);
                    resultList.add(0, (Object)theType);
                }
                if ((prevTypeTarget = prevType.getTarget()) instanceof ConcreteClassifier) {
                    int idx = 0;
                    for (ClassifierReference superClassifierReference : ((ConcreteClassifier)prevTypeTarget).getSuperTypeReferences()) {
                        TypeArgument arg2;
                        if (typeParameterIndex >= superClassifierReference.getTypeArguments().size() || !typeParameterDeclarator.equals(superClassifierReference.getTarget()) || !((arg2 = (TypeArgument)superClassifierReference.getTypeArguments().get(typeParameterIndex)) instanceof QualifiedTypeArgument)) continue;
                        TypeReference argRef = ((QualifiedTypeArgument)arg2).getTypeReference();
                        if (idx <= 0 && (idx != 0 || !resultList.isEmpty())) continue;
                        resultList.add(idx, (Object)argRef);
                        ++idx;
                    }
                } else if (prevTypeTarget instanceof TypeParameter) {
                    resultList.add((Object)prevType);
                    for (TypeReference extendedRef : ((TypeParameter)prevTypeTarget).getExtendTypes()) {
                        ConcreteClassifier extended = (ConcreteClassifier)extendedRef.getTarget();
                        int idx = ((TypeParametrizable)prevTypeTarget.eContainer()).getTypeParameters().indexOf((Object)prevTypeTarget);
                        if (extended.getTypeParameters().size() <= idx) continue;
                        resultList.add((Object)TypeReferenceExtension.convertToTypeReference((EObject)extended.getTypeParameters().get(idx)));
                    }
                }
            }
            if (reference == null || !(reference.eContainer() instanceof ReflectiveClassReference) || !(reference.eContainer().eContainer() instanceof Reference)) continue;
            resultList.add(0, (Object)((Reference)reference.eContainer().eContainer()).getReferencedTypeReference());
        }
        if (typeParameterDeclarator instanceof Method && reference instanceof MethodCall) {
            Method method = (Method)typeParameterDeclarator;
            MethodCall methodCall = (MethodCall)reference;
            TypeParameterExtension.inferTypeReferenceFromMethod(me, typeReference, reference, method, methodCall, (EList<TypeReference>)resultList, parentReference);
        }
        Iterator it = resultList.iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            it.remove();
        }
        if (resultList.isEmpty() || resultList.size() == 1 && !(resultList.get(0) instanceof InferableType) && ((TypeReference)resultList.get(0)).getTarget() != null && ((TypeReference)resultList.get(0)).getTarget().equals(me)) {
            if (me.getExtendTypes().size() > 0 && typeParameterDeclarator instanceof ConcreteClassifier) {
                TypeReference result = (TypeReference)me.getExtendTypes().get(0);
                return result;
            }
            return TypeReferenceExtension.convertToTypeReference(me);
        }
        if (resultList.size() == 1) {
            return (TypeReference)resultList.get(0);
        }
        TemporalCompositeTypeReference temp = new TemporalCompositeTypeReference();
        for (TypeReference aResult : resultList) {
            if (aResult instanceof TemporalCompositeTypeReference) {
                temp.getTypeReferences().addAll(((TemporalCompositeTypeReference)aResult).getTypeReferences());
                continue;
            }
            temp.getTypeReferences().add((Object)aResult);
        }
        temp.getTypeReferences().add((Object)TypeReferenceExtension.convertToTypeReference(me));
        return temp;
    }

    private static void inferTypeReferenceFromMethod(TypeParameter me, TypeReference typeReference, Reference reference, Method method, MethodCall methodCall, EList<TypeReference> resultList, Reference parentReference) {
        TypeReference argRef;
        int idx;
        if (!method.equals(methodCall.getTarget())) {
            return;
        }
        if (method.getTypeParameters().size() == methodCall.getCallTypeArguments().size()) {
            TypeArgument typeArgument = (TypeArgument)methodCall.getCallTypeArguments().get(method.getTypeParameters().indexOf((Object)me));
            resultList.add(0, (Object)TypeReferenceExtension.getTypeReferenceOfTypeArgument(typeArgument).getBoundTargetReference(parentReference));
        }
        if ((idx = method.getParameters().indexOf((Object)typeReference.eContainer())) == -1) {
            int hasIgnoredLambdaParameterIdx = -1;
            for (Parameter parameter : method.getParameters()) {
                Expression arg;
                LambdaExpression lambda;
                int oldIdx = idx;
                for (Object typeArgument : parameter.getTypeArguments()) {
                    argRef = TypeReferenceExtension.getTypeReferenceOfTypeArgument((TypeArgument)typeArgument);
                    if (argRef == null || !me.equals(argRef.getTarget())) continue;
                    idx = method.getParameters().indexOf((Object)parameter);
                }
                ClassifierReference paramTypeReference = parameter.getTypeReference().getPureClassifierReference();
                if (paramTypeReference != null) {
                    Object typeArgument;
                    typeArgument = paramTypeReference.getTypeArguments().iterator();
                    while (typeArgument.hasNext()) {
                        TypeArgument typeArgument2 = (TypeArgument)typeArgument.next();
                        TypeReference argRef2 = TypeReferenceExtension.getTypeReferenceOfTypeArgument(typeArgument2);
                        if (argRef2 == null || !me.equals(argRef2.getTarget())) continue;
                        idx = method.getParameters().indexOf((Object)parameter);
                    }
                    Classifier paramType = paramTypeReference.getTarget();
                    if (paramType instanceof TypeParameter && ((TypeParameter)paramType).equals(me)) {
                        idx = method.getParameters().indexOf((Object)parameter);
                    }
                }
                if ((lambda = (arg = (Expression)methodCall.getArguments().get(method.getParameters().indexOf((Object)parameter))) instanceof LambdaExpression ? (LambdaExpression)arg : arg.getFirstChildByType(LambdaExpression.class)) == null || lambda.getParameters() instanceof ExplicitlyTypedLambdaParameters || oldIdx == idx) continue;
                hasIgnoredLambdaParameterIdx = idx;
                idx = oldIdx;
            }
            if (hasIgnoredLambdaParameterIdx > -1 && idx == -1) {
                idx = hasIgnoredLambdaParameterIdx;
            }
        }
        if (idx < methodCall.getArguments().size() && idx >= 0) {
            Expression argument = (Expression)methodCall.getArguments().get(idx);
            Parameter parameter = (Parameter)method.getParameters().get(idx);
            ClassifierReference parameterType = parameter.getTypeReference().getPureClassifierReference();
            if (argument instanceof NewConstructorCall) {
                ClassifierReference argumentType = ((NewConstructorCall)argument).getTypeReference().getPureClassifierReference();
                if (argumentType != null && parameterType.getTypeArguments().size() == argumentType.getTypeArguments().size()) {
                    for (Object typeArgument : parameterType.getTypeArguments()) {
                        argRef = TypeReferenceExtension.getTypeReferenceOfTypeArgument((TypeArgument)typeArgument);
                        if (argRef == null || !argRef.getTarget().equals(me)) continue;
                        resultList.add(0, (Object)TypeReferenceExtension.getTypeReferenceOfTypeArgument((TypeArgument)argumentType.getTypeArguments().get(parameterType.getTypeArguments().indexOf(typeArgument))));
                    }
                }
                if (argumentType != null && parameterType.getTarget() instanceof TypeParameter) {
                    resultList.add(0, (Object)argumentType);
                }
            } else if (parameterType != null && argument instanceof Reference) {
                Reference argReference = (Reference)argument;
                while (argReference.getNext() instanceof Reference && !(argReference.getNext() instanceof ReflectiveClassReference)) {
                    argReference = argReference.getNext();
                }
                if (argReference instanceof ElementReference) {
                    ElementReference elementReference = (ElementReference)argReference;
                    while (elementReference.getNext() instanceof ElementReference) {
                        elementReference = (ElementReference)elementReference.getNext();
                    }
                    if (elementReference.getTarget() instanceof TypedElement) {
                        TypeReference typeRef = ((TypedElement)((Object)elementReference.getTarget())).getTypeReference();
                        if (typeRef != null) {
                            ClassifierReference argumentType = typeRef.getPureClassifierReference();
                            if (argumentType != null && parameterType.getTypeArguments().size() == argumentType.getTypeArguments().size()) {
                                for (TypeArgument typeArgument : parameterType.getTypeArguments()) {
                                    if (!(typeArgument instanceof QualifiedTypeArgument) || !((QualifiedTypeArgument)typeArgument).getTypeReference().getTarget().equals(me)) continue;
                                    int idx2 = parameterType.getTypeArguments().indexOf((Object)typeArgument);
                                    resultList.add(0, (Object)TypeReferenceExtension.getTypeReferenceOfTypeArgument((TypeArgument)argumentType.getTypeArguments().get(idx2)));
                                }
                            }
                            if (parameterType.getTarget().equals(me)) {
                                if (argumentType != null) {
                                    resultList.add(0, (Object)argumentType);
                                } else {
                                    resultList.add(0, (Object)typeRef);
                                }
                            }
                        }
                    } else if (elementReference.getNext() == null && parameter.getTypeReference().getTarget().equals(me)) {
                        resultList.add((Object)elementReference.getReferencedTypeReference());
                    }
                    if (elementReference.getNext() instanceof ReflectiveClassReference && parameterType.getTypeArguments().size() == 1) {
                        for (TypeArgument typeArgument2 : parameterType.getTypeArguments()) {
                            if (!(typeArgument2 instanceof QualifiedTypeArgument) || !((QualifiedTypeArgument)typeArgument2).getTypeReference().getTarget().equals(me)) continue;
                            resultList.add(0, (Object)elementReference.getReferencedTypeReference());
                        }
                    }
                } else if (parameterType.getTarget() instanceof TypeParameter) {
                    while (argReference.getNext() instanceof Reference) {
                        argReference = argReference.getNext();
                    }
                    resultList.add(0, (Object)argReference.getReferencedTypeReference());
                }
            } else {
                LambdaExpression lambda;
                LambdaExpression lambdaExpression = lambda = argument instanceof LambdaExpression ? (LambdaExpression)argument : argument.getFirstChildByType(LambdaExpression.class);
                if (lambda != null) {
                    Interface narrowedParameterType = (Interface)parameterType.getTarget();
                    TypeParameter correspondingTypeParameter = null;
                    for (int typeArgIndex = 0; typeArgIndex < parameterType.getTypeArguments().size(); ++typeArgIndex) {
                        TypeArgument typeArg = (TypeArgument)parameterType.getTypeArguments().get(typeArgIndex);
                        TypeReference typeArgRef = TypeReferenceExtension.getTypeReferenceOfTypeArgument(typeArg);
                        if (!typeArgRef.getTarget().equals(me)) continue;
                        correspondingTypeParameter = (TypeParameter)narrowedParameterType.getTypeParameters().get(typeArgIndex);
                    }
                    Method correspondingMethod = narrowedParameterType.getAbstractMethodOfFunctionalInterface();
                    Type potT = correspondingMethod.getTypeReference().getTarget();
                    if (potT.equals(correspondingTypeParameter)) {
                        Type ret = lambda.getReturnType(null);
                        if (ret != null) {
                            resultList.add(0, (Object)TypeReferenceExtension.convertToTypeReference(ret));
                        }
                    } else {
                        for (int cmIndex = 0; cmIndex < correspondingMethod.getParameters().size(); ++cmIndex) {
                            TypeReference potRes;
                            potT = ((Parameter)correspondingMethod.getParameters().get(cmIndex)).getTypeReference().getTarget();
                            if (!potT.equals(correspondingTypeParameter) || (potRes = ((Parameter)lambda.getParameters().getParameters().get(cmIndex)).getTypeReference()) instanceof InferableType) continue;
                            resultList.add(0, (Object)potRes);
                        }
                    }
                } else {
                    MethodReferenceExpression methodRef;
                    MethodReferenceExpression methodReferenceExpression = methodRef = argument instanceof MethodReferenceExpression ? (MethodReferenceExpression)argument : argument.getFirstChildByType(MethodReferenceExpression.class);
                    if (methodRef == null) {
                        resultList.add(0, (Object)argument.getOneTypeReference(false));
                    }
                }
            }
        }
        if (method.equals(typeReference.eContainer())) {
            HashSet<Classifier> allSuperTypes = new HashSet<Classifier>();
            for (Parameter parameter : method.getParameters()) {
                if (!me.equals(parameter.getTypeReference().getTarget())) continue;
                idx = method.getParameters().indexOf((Object)parameter);
                Type originalArgType = ((Expression)methodCall.getArguments().get(idx)).getType();
                Classifier argumentType = originalArgType instanceof PrimitiveType ? ((PrimitiveType)originalArgType).wrapPrimitiveType() : (Classifier)originalArgType;
                allSuperTypes.add(argumentType);
                allSuperTypes.addAll((Collection<Classifier>)argumentType.getAllSuperClassifiers());
            }
            for (Classifier classifier : allSuperTypes) {
                resultList.add((Object)TypeReferenceExtension.convertToTypeReference(classifier));
            }
        }
        if (resultList.isEmpty()) {
            resultList.addAll(TypeParameterExtension.inferTypeFromContext(me, typeReference, reference, method));
        }
    }

    private static BasicEList<TypeReference> inferTypeFromContext(TypeParameter me, TypeReference typeReference, Reference reference, Method method) {
        BasicEList resultList = new BasicEList();
        if (me.getExtendTypes().size() != 0) {
            return resultList;
        }
        Reference prevReference = reference;
        while (prevReference.getPrevious() != null) {
            prevReference = prevReference.getPrevious();
        }
        Reference contained = prevReference;
        EObject container = contained.eContainer();
        while (container != null && !(container instanceof MethodCall) && !(container instanceof AssignmentExpression) && !(container instanceof CastExpression) && container instanceof Expression) {
            contained = container;
            container = contained.eContainer();
        }
        if (container instanceof MethodCall) {
            MethodCall containingCall = (MethodCall)container;
            int index = containingCall.getArguments().indexOf((Object)contained);
            Method containingMethod = (Method)containingCall.getTarget();
            if (containingMethod != null && !containingMethod.eIsProxy()) {
                TypeReference typeRef = ((Parameter)((Method)containingCall.getTarget()).getParameters().get(index)).getTypeReference();
                if (typeRef instanceof TypeArgumentable) {
                    int indx = method.getTypeParameters().indexOf((Object)me);
                    TypeArgumentable argumentable = (TypeArgumentable)((Object)typeRef);
                    if (argumentable.getTypeArguments().size() > indx) {
                        TypeArgument typeArg = (TypeArgument)argumentable.getTypeArguments().get(indx);
                        TypeReference argRef = TypeReferenceExtension.getTypeReferenceOfTypeArgument(typeArg);
                        if (argRef != null) {
                            resultList.add(0, (Object)argRef.getBoundTargetReference(containingCall));
                        }
                    } else {
                        resultList.add((Object)typeRef.getBoundTargetReference(containingCall));
                    }
                } else {
                    resultList.add((Object)typeRef.getBoundTargetReference(containingCall));
                }
            }
        } else {
            TypeReference potType;
            TypeReference ref = null;
            if (container instanceof LocalVariable) {
                ref = ((LocalVariable)container).getTypeReference();
            } else if (container instanceof AdditionalLocalVariable) {
                ref = ((AdditionalLocalVariable)container).getTypeReference();
            } else if (container instanceof Field) {
                ref = ((Field)container).getTypeReference();
            } else if (container instanceof AdditionalField) {
                ref = ((AdditionalField)container).getTypeReference();
            } else if (container instanceof AssignmentExpression) {
                ref = ((AssignmentExpression)container).getChild().getOneTypeReference(false);
            } else if (container instanceof CastExpression) {
                ref = ((CastExpression)container).getTypeReference();
            }
            if (ref != null && (potType = TypeParameterExtension.searchForTypeParameter(me, method.getTypeReference(), ref)) != null) {
                resultList.add((Object)potType);
            }
        }
        return resultList;
    }

    private static TypeReference searchForTypeParameter(TypeParameter me, TypeReference searchReference, TypeReference targetReference) {
        if (searchReference == null || targetReference == null) {
            return null;
        }
        if (searchReference.getTarget().equals(me)) {
            return targetReference;
        }
        if (searchReference instanceof TypeArgumentable && targetReference instanceof TypeArgumentable) {
            TypeArgumentable typeArg = (TypeArgumentable)((Object)searchReference);
            TypeArgumentable targetArg = (TypeArgumentable)((Object)targetReference);
            for (int i = 0; i < typeArg.getTypeArguments().size(); ++i) {
                TypeArgument arg = (TypeArgument)typeArg.getTypeArguments().get(i);
                TypeReference refOfArg = TypeReferenceExtension.getTypeReferenceOfTypeArgument(arg);
                TypeReference potResult = TypeParameterExtension.searchForTypeParameter(me, refOfArg, TypeReferenceExtension.getTypeReferenceOfTypeArgument((TypeArgument)targetArg.getTypeArguments().get(i)));
                if (potResult == null) continue;
                return potResult;
            }
        }
        return null;
    }
}

