/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.model.java.extensions.containers;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import tools.mdsd.jamopp.model.java.classifiers.Annotation;
import tools.mdsd.jamopp.model.java.classifiers.Class;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Enumeration;
import tools.mdsd.jamopp.model.java.classifiers.Interface;
import tools.mdsd.jamopp.model.java.containers.CompilationUnit;
import tools.mdsd.jamopp.model.java.imports.ClassifierImport;
import tools.mdsd.jamopp.model.java.imports.ImportsFactory;
import tools.mdsd.jamopp.model.java.imports.PackageImport;

public class CompilationUnitExtension {
    public static ConcreteClassifier getContainedClassifier(CompilationUnit me, String name) {
        if (name == null) {
            return null;
        }
        for (ConcreteClassifier candidate : me.getClassifiers()) {
            if (!name.equals(candidate.getName())) continue;
            return candidate;
        }
        return null;
    }

    public static EList<ConcreteClassifier> getClassifiersInSamePackage(CompilationUnit me) {
        UniqueEList defaultImportList = new UniqueEList();
        String packageName = me.getNamespacesAsString();
        defaultImportList.addAll(me.getClassifiers());
        defaultImportList.addAll(me.getConcreteClassifiers(packageName, "*"));
        return defaultImportList;
    }

    public static Class getContainedClass(CompilationUnit me) {
        EList<ConcreteClassifier> classifiers = me.getClassifiers();
        if (classifiers.size() != 1) {
            return null;
        }
        ConcreteClassifier first = (ConcreteClassifier)classifiers.get(0);
        if (first instanceof Class) {
            return (Class)first;
        }
        return null;
    }

    public static Interface getContainedInterface(CompilationUnit me) {
        EList<ConcreteClassifier> classifiers = me.getClassifiers();
        if (classifiers.size() != 1) {
            return null;
        }
        ConcreteClassifier first = (ConcreteClassifier)classifiers.get(0);
        if (first instanceof Interface) {
            return (Interface)first;
        }
        return null;
    }

    public static Annotation getContainedAnnotation(CompilationUnit me) {
        EList<ConcreteClassifier> classifiers = me.getClassifiers();
        if (classifiers.size() != 1) {
            return null;
        }
        ConcreteClassifier first = (ConcreteClassifier)classifiers.get(0);
        if (first instanceof Annotation) {
            return (Annotation)first;
        }
        return null;
    }

    public static Enumeration getContainedEnumeration(CompilationUnit me) {
        EList<ConcreteClassifier> classifiers = me.getClassifiers();
        if (classifiers.size() != 1) {
            return null;
        }
        ConcreteClassifier first = (ConcreteClassifier)classifiers.get(0);
        if (first instanceof Enumeration) {
            return (Enumeration)first;
        }
        return null;
    }

    public static void addImport(CompilationUnit me, String nameOfClassToImport) {
        ClassifierImport importElement = ImportsFactory.eINSTANCE.createClassifierImport();
        ConcreteClassifier classToImport = me.getConcreteClassifier(nameOfClassToImport);
        importElement.setClassifier(classToImport);
        importElement.getNamespaces().addAll((Collection)classToImport.getContainingCompilationUnit().getNamespaces());
        me.getImports().add((Object)importElement);
    }

    public static void addPackageImport(CompilationUnit me, String packageName) {
        PackageImport nsImport = ImportsFactory.eINSTANCE.createPackageImport();
        for (String name : packageName.split("\\.")) {
            nsImport.getNamespaces().add((Object)name);
        }
        me.getImports().add((Object)nsImport);
    }
}

