/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.model.java.extensions.commons;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import tools.mdsd.jamopp.model.java.JavaClasspath;
import tools.mdsd.jamopp.model.java.annotations.AnnotationInstance;
import tools.mdsd.jamopp.model.java.classifiers.AnonymousClass;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Interface;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.containers.CompilationUnit;
import tools.mdsd.jamopp.model.java.statements.Statement;
import tools.mdsd.jamopp.model.java.statements.StatementListContainer;

public class CommentableExtension {
    public static void addBeforeContainingStatement(Commentable me, Statement statementToAdd) {
        EObject container = me.eContainer();
        Commentable statement = me;
        while (container != null && !(container instanceof StatementListContainer)) {
            container = container.eContainer();
            statement = statement.eContainer();
        }
        if (container == null) {
            throw new IllegalArgumentException("Element " + String.valueOf(me) + " is not contained in a StatementListContainer.");
        }
        StatementListContainer statementListContainer = (StatementListContainer)container;
        EList<Statement> statements = statementListContainer.getStatements();
        int index = statements.indexOf((Object)statement);
        statements.add(index, (Object)statementToAdd);
    }

    public static void addAfterContainingStatement(Commentable me, Statement statementToAdd) {
        EObject container = me.eContainer();
        Commentable statement = me;
        while (container != null && !(container instanceof StatementListContainer)) {
            container = container.eContainer();
            statement = statement.eContainer();
        }
        if (container == null) {
            throw new IllegalArgumentException("Element " + String.valueOf(me) + " is not contained in a StatementListContainer.");
        }
        StatementListContainer statementListContainer = (StatementListContainer)container;
        EList<Statement> statements = statementListContainer.getStatements();
        int index = statements.indexOf((Object)statement);
        if (index == statements.size() - 1) {
            statements.add((Object)statementToAdd);
        } else {
            statements.add(index + 1, (Object)statementToAdd);
        }
    }

    public static EObject getParentByEType(Commentable me, EClass type) {
        for (EObject container = me.eContainer(); container != null; container = container.eContainer()) {
            if (!type.isInstance((Object)container)) continue;
            return container;
        }
        return null;
    }

    public static <T> T getParentByType(Commentable me, Class<T> type) {
        for (EObject container = me.eContainer(); container != null; container = container.eContainer()) {
            if (!type.isInstance(container)) continue;
            return type.cast(container);
        }
        return null;
    }

    public static EObject getFirstChildByEType(Commentable me, EClass type) {
        TreeIterator it = me.eAllContents();
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (!type.isInstance((Object)next)) continue;
            return next;
        }
        return null;
    }

    public static <T> T getFirstChildByType(Commentable me, Class<T> type) {
        TreeIterator it = me.eAllContents();
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (!type.isInstance(next)) continue;
            return type.cast(next);
        }
        return null;
    }

    public static EList<EObject> getChildrenByEType(Commentable me, EClass type) {
        BasicEList children = new BasicEList();
        TreeIterator it = me.eAllContents();
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (!type.isInstance((Object)next)) continue;
            children.add((Object)next);
        }
        return children;
    }

    public static <T> EList<T> getChildrenByType(Commentable me, Class<T> type) {
        BasicEList children = new BasicEList();
        TreeIterator it = me.eAllContents();
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (!type.isInstance(next)) continue;
            children.add(type.cast(next));
        }
        return children;
    }

    public static ConcreteClassifier getConcreteClassifier(Commentable me, String name) {
        return (ConcreteClassifier)EcoreUtil.resolve((EObject)JavaClasspath.get(me).getConcreteClassifier(name), (EObject)me);
    }

    public static EList<ConcreteClassifier> getConcreteClassifiers(Commentable me, String packageName, String classifierQuery) {
        if (!((String)packageName).endsWith(".")) {
            packageName = (String)packageName + ".";
        }
        UniqueEList result = new UniqueEList();
        if (classifierQuery.equals("*")) {
            Collection<ConcreteClassifier> classi = JavaClasspath.get(me).getConcreteClassifiers((String)packageName);
            if (classi != null) {
                for (ConcreteClassifier clazz : classi) {
                    result.add((Object)clazz);
                }
            }
        } else {
            ConcreteClassifier classifier = JavaClasspath.get(me).getConcreteClassifier((String)packageName + classifierQuery);
            if (classifier != null) {
                result.add((Object)classifier);
            }
        }
        return result;
    }

    public static tools.mdsd.jamopp.model.java.classifiers.Class getLibClass(Commentable me, String name) {
        ConcreteClassifier result = JavaClasspath.get(me).getConcreteClassifier("java.lang." + name);
        if ((result = (ConcreteClassifier)EcoreUtil.resolve((EObject)result, (EObject)me)) != null && result instanceof tools.mdsd.jamopp.model.java.classifiers.Class) {
            return (tools.mdsd.jamopp.model.java.classifiers.Class)result;
        }
        return null;
    }

    public static Interface getLibInterface(Commentable me, String name) {
        ConcreteClassifier interfaceClass = JavaClasspath.get(me).getConcreteClassifier("java.lang." + name);
        if ((interfaceClass = (ConcreteClassifier)EcoreUtil.resolve((EObject)interfaceClass, (EObject)me)) != null && interfaceClass instanceof Interface) {
            return (Interface)interfaceClass;
        }
        return null;
    }

    public static tools.mdsd.jamopp.model.java.classifiers.Class getClassClass(Commentable me) {
        return me.getLibClass("Class");
    }

    public static tools.mdsd.jamopp.model.java.classifiers.Class getObjectClass(Commentable me) {
        return me.getLibClass("Object");
    }

    public static tools.mdsd.jamopp.model.java.classifiers.Class getStringClass(Commentable me) {
        return me.getLibClass("String");
    }

    public static Interface getAnnotationInterface(Commentable me) {
        ConcreteClassifier proxy = JavaClasspath.get(me).getConcreteClassifier("java.lang.annotation.Annotation");
        if ((proxy = (ConcreteClassifier)EcoreUtil.resolve((EObject)proxy, (EObject)me)) != null && proxy instanceof Interface) {
            return (Interface)proxy;
        }
        return null;
    }

    public static ConcreteClassifier getContainingConcreteClassifier(Commentable me) {
        Commentable value;
        for (value = me; !(value instanceof ConcreteClassifier) && value != null; value = value.eContainer()) {
        }
        return (ConcreteClassifier)value;
    }

    public static ConcreteClassifier getParentConcreteClassifier(Commentable me) {
        return me.getContainingConcreteClassifier();
    }

    public static AnonymousClass getContainingAnonymousClass(Commentable me) {
        Commentable value;
        for (value = me; !(value instanceof AnonymousClass) && !(value instanceof ConcreteClassifier) && value != null; value = value.eContainer()) {
        }
        if (!(value instanceof AnonymousClass)) {
            return null;
        }
        return (AnonymousClass)value;
    }

    public static CompilationUnit getContainingCompilationUnit(Commentable me) {
        Commentable value;
        for (value = me; !(value instanceof CompilationUnit) && value != null; value = value.eContainer()) {
        }
        return (CompilationUnit)value;
    }

    public static AnnotationInstance getContainingAnnotationInstance(Commentable me) {
        Commentable value;
        for (value = me; !(value instanceof AnnotationInstance) && value != null; value = value.eContainer()) {
        }
        return (AnnotationInstance)value;
    }

    public static EList<String> getContainingPackageName(Commentable me) {
        CompilationUnit cu = me.getContainingCompilationUnit();
        if (cu == null) {
            return null;
        }
        int idx = cu.getNamespaces().size();
        if (cu.getName() != null) {
            char[] fullName = cu.getName().toCharArray();
            for (int i = 0; i < fullName.length; ++i) {
                if (fullName[i] != '$') continue;
                --idx;
            }
        }
        List packageNameParts = cu.getNamespaces().subList(0, idx);
        BasicEList packageNameList = new BasicEList((Collection)packageNameParts);
        return ECollections.unmodifiableEList((EList)packageNameList);
    }

    public static EList<String> getContainingContainerName(Commentable me) {
        CompilationUnit cu = me.getContainingCompilationUnit();
        if (cu == null) {
            return null;
        }
        return ECollections.unmodifiableEList((EList)cu.getNamespaces());
    }
}

