/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.model.java.extensions.classifiers;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import tools.mdsd.jamopp.model.java.classifiers.Class;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Interface;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.modifiers.Default;
import tools.mdsd.jamopp.model.java.types.Type;
import tools.mdsd.jamopp.model.java.types.TypeReference;

public class InterfaceExtension {
    public static EList<ConcreteClassifier> getAllSuperClassifiers(Interface me) {
        UniqueEList result = new UniqueEList();
        EList<TypeReference> explicitExtends = me.getExtends();
        InterfaceExtension.getAllSuperClassifiers(explicitExtends, (List<ConcreteClassifier>)result);
        EList<TypeReference> defaultExtends = me.getDefaultExtends();
        InterfaceExtension.getAllSuperClassifiers(defaultExtends, (List<ConcreteClassifier>)result);
        return result;
    }

    private static void getAllSuperClassifiers(List<TypeReference> typeReferences, List<ConcreteClassifier> result) {
        for (TypeReference typeReference : typeReferences) {
            InterfaceExtension.getAllSuperClassifiers(typeReference, result);
        }
    }

    private static void getAllSuperClassifiers(TypeReference typeReference, List<ConcreteClassifier> result) {
        Type target = typeReference.getTarget();
        ConcreteClassifier superInterface = (ConcreteClassifier)target;
        if (superInterface != null) {
            result.add(superInterface);
            if (superInterface instanceof Interface) {
                result.addAll((Collection<ConcreteClassifier>)((Interface)superInterface).getAllSuperClassifiers());
            }
        }
    }

    public static Method getAbstractMethodOfFunctionalInterface(Interface me) {
        Class objectClass = me.getObjectClass();
        for (Member mem : me.getAllMembers(me)) {
            if (!(mem instanceof Method) || ((Method)mem).isStatic() || ((Method)mem).hasModifier(Default.class) || !objectClass.getMembersByName(mem.getName()).isEmpty()) continue;
            return (Method)mem;
        }
        return null;
    }
}

