/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.model.java.extensions.classifiers;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import tools.mdsd.jamopp.model.java.JavaClasspath;
import tools.mdsd.jamopp.model.java.classifiers.Class;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Interface;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.commons.NamespaceAwareElement;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.modifiers.AnnotableAndModifiable;
import tools.mdsd.jamopp.model.java.types.ClassifierReference;
import tools.mdsd.jamopp.model.java.types.TypeReference;

public class ConcreteClassifierExtension {
    public static EList<ConcreteClassifier> getAllInnerClassifiers(ConcreteClassifier me) {
        UniqueEList innerClassifierList = new UniqueEList();
        innerClassifierList.addAll(me.getInnerClassifiers());
        for (ConcreteClassifier superClassifier : me.getAllSuperClassifiers()) {
            if (superClassifier == null) continue;
            EList<ConcreteClassifier> superInnerList = superClassifier.getInnerClassifiers();
            for (ConcreteClassifier superInner : superInnerList) {
                boolean isVisible;
                if (superInner.eIsProxy()) {
                    EObject resolved = EcoreUtil.resolve((EObject)superInner, (EObject)me);
                    superInner = (ConcreteClassifier)resolved;
                }
                if (!(isVisible = !superInner.isHidden(me))) continue;
                innerClassifierList.add((Object)superInner);
            }
        }
        return innerClassifierList;
    }

    public static EList<ConcreteClassifier> getInnerClassifiers(ConcreteClassifier me) {
        if (me.eIsProxy()) {
            String uriString = ((InternalEObject)me).eProxyURI().trimFragment().toString();
            String fullName = uriString.substring("pathmap:/javaclass/".length(), uriString.length() - ".java".length());
            UniqueEList result = new UniqueEList();
            result.add((Object)JavaClasspath.get(me).getConcreteClassifier(fullName));
            return result;
        }
        UniqueEList result = new UniqueEList();
        for (Member member : me.getMembers()) {
            if (!(member instanceof ConcreteClassifier)) continue;
            result.add((Object)((ConcreteClassifier)member));
            result.addAll(((ConcreteClassifier)member).getInnerClassifiers());
        }
        return result;
    }

    public static EList<ClassifierReference> getSuperTypeReferences(ConcreteClassifier me) {
        UniqueEList typeReferenceList = new UniqueEList();
        if (me instanceof Class) {
            Class javaClass = (Class)me;
            TypeReference superClass = javaClass.getExtends();
            if (superClass != null) {
                ClassifierReference classifierReference = superClass.getPureClassifierReference();
                typeReferenceList.add((Object)classifierReference);
                Classifier target = classifierReference.getTarget();
                ConcreteClassifier concreteTarget = (ConcreteClassifier)target;
                if (!me.isJavaLangObject(concreteTarget)) {
                    typeReferenceList.addAll(concreteTarget.getSuperTypeReferences());
                }
            }
            ConcreteClassifierExtension.addSuperTypes((List<TypeReference>)javaClass.getImplements(), (List<ClassifierReference>)typeReferenceList);
        } else if (me instanceof Interface) {
            Interface javaInterface = (Interface)me;
            ConcreteClassifierExtension.addSuperTypes(javaInterface.getExtends(), (List<ClassifierReference>)typeReferenceList);
        }
        return typeReferenceList;
    }

    private static void addSuperTypes(List<TypeReference> typeReferences, List<ClassifierReference> superTypeReferences) {
        for (TypeReference interfaceReference : typeReferences) {
            ConcreteClassifierExtension.addSuperType(interfaceReference, superTypeReferences);
        }
    }

    private static void addSuperType(TypeReference typeReference, List<ClassifierReference> superTypeReferences) {
        ClassifierReference classifierReference = typeReference.getPureClassifierReference();
        superTypeReferences.add(classifierReference);
        Classifier target = classifierReference.getTarget();
        ConcreteClassifier concreteTarget = (ConcreteClassifier)target;
        superTypeReferences.addAll((Collection<ClassifierReference>)concreteTarget.getSuperTypeReferences());
    }

    public static EList<Member> getAllMembers(ConcreteClassifier me, Commentable context) {
        UniqueEList memberList = new UniqueEList();
        ConcreteClassifier concreteClassifier = me;
        memberList.addAll((Collection)concreteClassifier.getMembers());
        memberList.addAll((Collection)concreteClassifier.getDefaultMembers());
        memberList.addAll(concreteClassifier.getAllInnerClassifiers());
        for (ConcreteClassifier superClassifier : me.getAllSuperClassifiers()) {
            if (superClassifier == null) continue;
            if (superClassifier.eIsProxy()) {
                superClassifier = (ConcreteClassifier)EcoreUtil.resolve((EObject)superClassifier, (EObject)context);
            }
            for (Member member : superClassifier.getMembers()) {
                if (member instanceof AnnotableAndModifiable) {
                    AnnotableAndModifiable modifiable = (AnnotableAndModifiable)((Object)member);
                    boolean isVisible = !modifiable.isHidden(context);
                    if (!isVisible) continue;
                    memberList.add((Object)member);
                    continue;
                }
                memberList.add((Object)member);
            }
            memberList.addAll((Collection)superClassifier.getDefaultMembers());
        }
        return memberList;
    }

    public static String getQualifiedName(ConcreteClassifier me) {
        StringBuilder qualifiedName = new StringBuilder();
        if (me.eContainer() instanceof ConcreteClassifier) {
            qualifiedName.append(((ConcreteClassifier)me.eContainer()).getQualifiedName());
            qualifiedName.append(".");
        } else if (me.eContainer() instanceof NamespaceAwareElement) {
            qualifiedName.append(((NamespaceAwareElement)me.eContainer()).getNamespacesAsString());
        } else {
            EList<String> packageParts = me.getContainingPackageName();
            if (packageParts != null) {
                for (String packagePart : packageParts) {
                    qualifiedName.append(packagePart);
                    qualifiedName.append(".");
                }
            }
        }
        qualifiedName.append(me.getName());
        return qualifiedName.toString();
    }

    public static boolean isJavaLangObject(ConcreteClassifier clazz) {
        String name = clazz.getName();
        if (!"Object".equals(name)) {
            return false;
        }
        EList<String> packageName = clazz.getContainingPackageName();
        if (packageName.size() != 2) {
            return false;
        }
        if (!"java".equals(packageName.get(0))) {
            return false;
        }
        return "lang".equals(packageName.get(1));
    }
}

