/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.model.java.extensions.classifiers;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.InternalEObject;
import tools.mdsd.jamopp.model.java.classifiers.Class;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Interface;
import tools.mdsd.jamopp.model.java.types.PrimitiveType;
import tools.mdsd.jamopp.model.java.types.Type;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.model.java.types.TypesFactory;

public class ClassExtension {
    public static EList<ConcreteClassifier> getAllSuperClassifiers(Class me) {
        UniqueEList result = new UniqueEList();
        Class superClass = me;
        while (superClass != null && !superClass.eIsProxy() && !me.isJavaLangObject(superClass)) {
            if ((superClass = superClass.getSuperClass()) == null) continue;
            result.add((Object)superClass);
        }
        for (TypeReference typeArg : me.getImplements()) {
            ConcreteClassifier superInterface = (ConcreteClassifier)typeArg.getTarget();
            if (superInterface == null) continue;
            result.add((Object)superInterface);
            if (!(superInterface instanceof Interface)) continue;
            result.addAll(((Interface)superInterface).getAllSuperClassifiers());
        }
        superClass = me.getSuperClass();
        if (superClass != null && !superClass.eIsProxy() && !me.isJavaLangObject(superClass)) {
            result.addAll(superClass.getAllSuperClassifiers());
        }
        return result;
    }

    public static Class getSuperClass(Class me) {
        TypeReference superClassReference = me.getExtends();
        if (superClassReference == null) {
            superClassReference = me.getDefaultExtends();
        }
        if (superClassReference == null) {
            return null;
        }
        Type result = superClassReference.getTarget();
        if (result instanceof Class) {
            return (Class)result;
        }
        return null;
    }

    public static PrimitiveType unWrapPrimitiveType(Class me) {
        String type;
        String string = type = me.eIsProxy() ? ((InternalEObject)me).eProxyURI().toString() : me.getQualifiedName();
        if (type.contains("java.lang.Boolean")) {
            return TypesFactory.eINSTANCE.createBoolean();
        }
        if (type.contains("java.lang.Byte")) {
            return TypesFactory.eINSTANCE.createByte();
        }
        if (type.contains("java.lang.Character")) {
            return TypesFactory.eINSTANCE.createChar();
        }
        if (type.contains("java.lang.Float")) {
            return TypesFactory.eINSTANCE.createFloat();
        }
        if (type.contains("java.lang.Double")) {
            return TypesFactory.eINSTANCE.createDouble();
        }
        if (type.contains("java.lang.Integer")) {
            return TypesFactory.eINSTANCE.createInt();
        }
        if (type.contains("java.lang.Long")) {
            return TypesFactory.eINSTANCE.createLong();
        }
        if (type.contains("java.lang.Short")) {
            return TypesFactory.eINSTANCE.createShort();
        }
        if (type.contains("java.lang.Void")) {
            return TypesFactory.eINSTANCE.createVoid();
        }
        return null;
    }
}

