/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.model.java.extensions.classifiers;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import tools.mdsd.jamopp.model.java.classifiers.AnonymousClass;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Enumeration;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.instantiations.NewConstructorCall;
import tools.mdsd.jamopp.model.java.members.EnumConstant;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.modifiers.AnnotableAndModifiable;
import tools.mdsd.jamopp.model.java.types.Type;
import tools.mdsd.jamopp.model.java.types.TypeReference;

public class AnonymousClassExtension {
    public static EList<Member> getAllMembers(AnonymousClass me, Commentable context) {
        UniqueEList memberList = new UniqueEList();
        memberList.addAll((Collection)me.getMembers());
        memberList.addAll((Collection)me.getDefaultMembers());
        NewConstructorCall ncCall = null;
        EObject eContainer = me.eContainer();
        if (eContainer instanceof NewConstructorCall) {
            ncCall = (NewConstructorCall)eContainer;
        }
        if (ncCall == null) {
            return memberList;
        }
        TypeReference typeReference = ncCall.getTypeReference();
        Type target = typeReference.getTarget();
        ConcreteClassifier classifier = (ConcreteClassifier)target;
        if (classifier != null) {
            EList<Member> superMemberList = classifier.getAllMembers(context);
            for (Member superMember : superMemberList) {
                if (superMember instanceof AnnotableAndModifiable) {
                    AnnotableAndModifiable modifiable;
                    if (superMember.eIsProxy()) {
                        superMember = (Member)EcoreUtil.resolve((EObject)superMember, (EObject)me);
                    }
                    if ((modifiable = (AnnotableAndModifiable)((Object)superMember)).isHidden(context)) continue;
                    memberList.add((Object)superMember);
                    continue;
                }
                memberList.add((Object)superMember);
            }
        }
        return memberList;
    }

    public static EList<ConcreteClassifier> getAllSuperClassifiers(AnonymousClass me) {
        UniqueEList superClassifierList = new UniqueEList();
        ConcreteClassifier superClassifier = me.getSuperClassifier();
        if (superClassifier != null) {
            superClassifierList.add((Object)superClassifier);
            superClassifierList.addAll(superClassifier.getAllSuperClassifiers());
        } else {
            superClassifierList.add((Object)me.getObjectClass());
        }
        return superClassifierList;
    }

    public static ConcreteClassifier getSuperClassifier(AnonymousClass me) {
        NewConstructorCall ncCall = null;
        EObject eContainer = me.eContainer();
        if (eContainer instanceof NewConstructorCall) {
            ncCall = (NewConstructorCall)eContainer;
            TypeReference typeReference = ncCall.getTypeReference();
            Type target = typeReference.getTarget();
            ConcreteClassifier superClassifier = (ConcreteClassifier)target;
            return superClassifier;
        }
        if (eContainer instanceof EnumConstant && eContainer.eContainer() instanceof Enumeration) {
            return (Enumeration)eContainer.eContainer();
        }
        return null;
    }
}

