/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.model.java.containers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Origin implements Enumerator
{
    FILE(0, "FILE", "FILE"),
    CLASS(1, "CLASS", "CLASS"),
    ARCHIVE(2, "ARCHIVE", "ARCHIVE"),
    BINDING(3, "BINDING", "BINDING");

    public static final int FILE_VALUE = 0;
    public static final int CLASS_VALUE = 1;
    public static final int ARCHIVE_VALUE = 2;
    public static final int BINDING_VALUE = 3;
    private static final Origin[] VALUES_ARRAY;
    public static final List<Origin> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static Origin get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Origin result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static Origin getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Origin result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static Origin get(int value) {
        switch (value) {
            case 0: {
                return FILE;
            }
            case 1: {
                return CLASS;
            }
            case 2: {
                return ARCHIVE;
            }
            case 3: {
                return BINDING;
            }
        }
        return null;
    }

    private Origin(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new Origin[]{FILE, CLASS, ARCHIVE, BINDING};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

