/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.model.java;

import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;
import tools.mdsd.jamopp.model.java.commons.NamespaceAwareElement;

public class LogicalJavaURIGenerator {
    public static final String JAVA_URI_SCHEME = "pathmap";
    public static final String JAVA_URI_SEGMENT_CLASSIFIER = "javaclass";
    public static final String JAVA_URI_SEGMENT_PACKAGE = "javapackage";
    public static final String JAVA_URI_SEGMENT_MODULE = "javamodule";
    public static final String JAVA_CLASSIFIER_PATHMAP = "pathmap:/javaclass/";
    public static final String JAVA_PACKAGE_PATHMAP = "pathmap:/javapackage/";
    public static final String JAVA_MODULE_PATHMAP = "pathmap:/javamodule/";
    public static final String CLASSIFIERS_ROOT_PATH_PREFIX = "@classifiers[name='";
    public static final String CLASSIFIERS_SUB_PATH_PREFIX = "@members[name='";
    public static final String CLASSIFIERS_PATH_SUFIX = "']";
    public static final String PACKAGE_SEPARATOR = ".";
    public static final String CLASSIFIER_SEPARATOR = "$";
    public static final String JAVA_FILE_EXTENSION_NAME = "java";
    public static final String JAVA_FILE_EXTENSION = ".java";
    public static final String JAVA_CLASS_FILE_EXTENSION_NAME = "class";
    public static final String JAVA_CLASS_FILE_EXTENSION = ".class";
    public static final String JAVAXMI_FILE_EXTENSION_NAME = "javaxmi";
    public static final String JAVAXMI_FILE_EXTENSION = ".javaxmi";
    public static final String JAVA_MODULE_FILE_NAME = "module-info.java";
    public static final String JAVA_PACKAGE_FILE_NAME = "package-info.java";
    private static final Pattern CLASSIFIER_SEPARATOR_REGEX_PATTERN = Pattern.compile("\\$");

    public static URI getJavaFileResourceURI(String fullQualifiedName) {
        StringBuilder logicalUriString = new StringBuilder(JAVA_CLASSIFIER_PATHMAP);
        logicalUriString.append(fullQualifiedName);
        logicalUriString.append(JAVA_FILE_EXTENSION);
        return URI.createURI((String)logicalUriString.toString());
    }

    public static URI getClassifierURI(String fullQualifiedName) {
        URI logicalUri = LogicalJavaURIGenerator.getJavaFileResourceURI(fullQualifiedName);
        String classesPart = fullQualifiedName;
        int idx = fullQualifiedName.lastIndexOf(PACKAGE_SEPARATOR);
        if (idx >= 0) {
            classesPart = classesPart.substring(idx + 1);
        }
        String[] classNames = CLASSIFIER_SEPARATOR_REGEX_PATTERN.split(classesPart, -1);
        StringBuilder uriFragment = new StringBuilder();
        for (int i = 0; i < classNames.length; ++i) {
            if (i == 0) {
                uriFragment.append("//");
                uriFragment.append(CLASSIFIERS_ROOT_PATH_PREFIX);
            } else {
                uriFragment.append("/");
                uriFragment.append(CLASSIFIERS_SUB_PATH_PREFIX);
            }
            uriFragment.append(classNames[i]);
            uriFragment.append(CLASSIFIERS_PATH_SUFIX);
        }
        logicalUri = logicalUri.appendFragment(uriFragment.toString());
        return logicalUri;
    }

    public static String getSimpleClassName(String fullQualifiedName) {
        int idx1 = fullQualifiedName.lastIndexOf(PACKAGE_SEPARATOR);
        int idx2 = fullQualifiedName.lastIndexOf(CLASSIFIER_SEPARATOR);
        if (idx1 == -1 && idx2 == -1) {
            return fullQualifiedName;
        }
        if (idx1 > idx2) {
            return fullQualifiedName.substring(idx1 + 1);
        }
        return fullQualifiedName.substring(idx2 + 1);
    }

    public static URI getModuleURI(String moduleName) {
        StringBuilder uri = new StringBuilder();
        uri.append(JAVA_MODULE_PATHMAP);
        uri.append(moduleName);
        uri.append("/");
        uri.append(JAVA_MODULE_FILE_NAME);
        return URI.createURI((String)uri.toString());
    }

    public static URI getPackageURI(String packageName) {
        StringBuilder uri = new StringBuilder();
        uri.append(JAVA_PACKAGE_PATHMAP);
        uri.append(packageName);
        uri.append("/");
        uri.append(JAVA_PACKAGE_FILE_NAME);
        return URI.createURI((String)uri.toString());
    }

    public static String packageName(NamespaceAwareElement nsaElement) {
        StringBuilder builder = new StringBuilder();
        nsaElement.getNamespaces().forEach(s -> {
            builder.append((String)s);
            builder.append(PACKAGE_SEPARATOR);
        });
        return builder.toString();
    }
}

