/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.model.java;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import tools.mdsd.jamopp.model.java.LogicalJavaURIGenerator;
import tools.mdsd.jamopp.model.java.classifiers.Class;
import tools.mdsd.jamopp.model.java.classifiers.ClassifiersFactory;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.containers.CompilationUnit;
import tools.mdsd.jamopp.model.java.containers.JavaRoot;
import tools.mdsd.jamopp.model.java.containers.Module;
import tools.mdsd.jamopp.model.java.containers.Package;
import tools.mdsd.jamopp.model.java.members.Member;

public class JavaClasspath {
    private static JavaClasspath globalClasspath = null;
    private static HashMap<ResourceSet, JavaClasspath> classpaths = new HashMap();
    private ResourceSet resourceSet;
    private boolean registerLocal = false;
    private Map<String, Set<String>> packageClassifierMap = new LinkedHashMap<String, Set<String>>();

    public static JavaClasspath get() {
        if (globalClasspath == null) {
            JavaClasspath localGlobalClasspath = new JavaClasspath(null);
            localGlobalClasspath.registerStdLib();
            globalClasspath = localGlobalClasspath;
        }
        return globalClasspath;
    }

    public static JavaClasspath get(EObject obj) {
        if (obj == null) {
            return JavaClasspath.get();
        }
        return JavaClasspath.get(obj.eResource());
    }

    public static JavaClasspath get(Resource resource) {
        if (resource == null) {
            return JavaClasspath.get();
        }
        return JavaClasspath.get(resource.getResourceSet());
    }

    public static JavaClasspath get(ResourceSet set) {
        if (set == null) {
            return JavaClasspath.get();
        }
        if (!classpaths.containsKey(set)) {
            classpaths.put(set, new JavaClasspath(set));
        }
        return classpaths.get(set);
    }

    public static void remove(EObject obj) {
        if (obj != null) {
            JavaClasspath.remove(obj.eResource());
        }
    }

    public static void remove(Resource resource) {
        if (resource != null) {
            JavaClasspath.remove(resource.getResourceSet());
        }
    }

    public static void remove(ResourceSet set) {
        if (set != null && classpaths.containsKey(set)) {
            classpaths.remove(set);
        }
    }

    private JavaClasspath(ResourceSet set) {
        this.resourceSet = set;
    }

    public void enableLocalRegistration() {
        this.registerLocal = true;
    }

    public void clear() {
        this.packageClassifierMap.clear();
        Iterator<Map.Entry<URI, URI>> iter = this.getURIMap().entrySet().iterator();
        while (iter.hasNext()) {
            String fileExt = iter.next().getKey().fileExtension();
            if (!"java".equals(fileExt) && !"class".equals(fileExt) && !"javaxmi".equals(fileExt)) continue;
            iter.remove();
        }
    }

    public void registerJavaRoot(JavaRoot root, URI physicalUri) {
        if (root instanceof CompilationUnit) {
            this.registerClassifier((CompilationUnit)root, physicalUri);
        } else if (root instanceof Package) {
            this.registerPackage((Package)root, physicalUri);
        } else if (root instanceof Module) {
            this.registerModule((Module)root, physicalUri);
        }
    }

    public void registerPackage(Package pack, URI physicalUri) {
        URI logicalURI = LogicalJavaURIGenerator.getPackageURI(pack.getNamespacesAsString());
        this.updateMapping(logicalURI, physicalUri);
        this.registerPackages((String[])pack.getNamespaces().toArray((Object[])new String[0]));
    }

    public void registerPackage(String packageName, URI physicalUri) {
        this.updateMapping(LogicalJavaURIGenerator.getPackageURI(packageName), physicalUri);
        this.registerPackages(packageName.split("\\."));
    }

    private void registerPackages(String[] packages) {
        StringBuilder parentName = new StringBuilder();
        this.registerPackage("");
        for (String p : packages) {
            parentName.append(p);
            parentName.append(".");
            String parentNameString = parentName.toString();
            this.registerPackage(parentNameString);
        }
    }

    public void registerModule(Module module, URI physicalUri) {
        URI logicalURI = LogicalJavaURIGenerator.getModuleURI(module.getNamespacesAsString());
        this.updateMapping(logicalURI, physicalUri);
    }

    public void registerModule(String moduleName, URI physicalUri) {
        this.updateMapping(LogicalJavaURIGenerator.getModuleURI(moduleName), physicalUri);
    }

    public Package getPackage(String packageName) {
        return null;
    }

    public Module getModule(String moduleName) {
        return null;
    }

    public ConcreteClassifier getConcreteClassifier(String fullQualifiedClassifierName) {
        String actualName = fullQualifiedClassifierName.startsWith(".") ? fullQualifiedClassifierName.substring(1) : fullQualifiedClassifierName;
        return this.getProxyConcreteClassifier(actualName);
    }

    public Collection<ConcreteClassifier> getConcreteClassifiers(String packageName) {
        String actualPackName = this.checkPackageName(packageName);
        List<Map.Entry> contents = this.packageClassifierMap.entrySet().stream().filter(e -> {
            String k = (String)e.getKey();
            if (k.equals(actualPackName)) {
                return true;
            }
            if (actualPackName.equals(".")) {
                return !k.contains(".") && k.contains("$");
            }
            if (k.startsWith(actualPackName)) {
                String kSub = k.substring(actualPackName.length());
                return !kSub.contains(".") && kSub.contains("$");
            }
            return false;
        }).collect(Collectors.toList());
        ArrayList<ConcreteClassifier> result = new ArrayList<ConcreteClassifier>();
        contents.forEach(e -> ((Set)e.getValue()).stream().map(cc -> (String)e.getKey() + cc).map(this::getProxyConcreteClassifiers).filter(p -> p != null && !p.isEmpty()).forEach(p -> result.addAll((Collection<ConcreteClassifier>)p)));
        if (this != JavaClasspath.get()) {
            result.addAll(JavaClasspath.get().getConcreteClassifiers(packageName));
        }
        return result;
    }

    private Collection<ConcreteClassifier> getProxyConcreteClassifiers(String fullQualifiedClassifierName) {
        if (fullQualifiedClassifierName.startsWith(".")) {
            fullQualifiedClassifierName = fullQualifiedClassifierName.substring(1);
        }
        ArrayList<ConcreteClassifier> result = new ArrayList<ConcreteClassifier>();
        int dotIdx = fullQualifiedClassifierName.lastIndexOf(".");
        int dollarIdx = fullQualifiedClassifierName.lastIndexOf("$");
        if (dollarIdx != -1 && dollarIdx > dotIdx) {
            URI logURI = LogicalJavaURIGenerator.getClassifierURI(fullQualifiedClassifierName);
            String outerPack = fullQualifiedClassifierName;
            Object innerClass = "";
            do {
                innerClass = outerPack.substring(dollarIdx + 1) + "$" + (String)innerClass;
                outerPack = outerPack.substring(0, dollarIdx);
                Class proxy = ClassifiersFactory.eINSTANCE.createClass();
                ((InternalEObject)proxy).eSetProxyURI(logURI);
                proxy.setName((String)innerClass);
                result.add(proxy);
            } while ((dollarIdx = outerPack.lastIndexOf("$")) != -1 && dollarIdx > dotIdx);
        } else {
            result.add(this.getProxyConcreteClassifier(fullQualifiedClassifierName));
        }
        return result;
    }

    private ConcreteClassifier getProxyConcreteClassifier(String fullQualifiedClassifierName) {
        Class result = ClassifiersFactory.eINSTANCE.createClass();
        ((InternalEObject)result).eSetProxyURI(LogicalJavaURIGenerator.getClassifierURI(fullQualifiedClassifierName));
        result.setName(LogicalJavaURIGenerator.getSimpleClassName(fullQualifiedClassifierName));
        return result;
    }

    public void registerStdLib() {
        String classpath = System.getProperty("java.home") + File.separator + "lib" + File.separator + "src.zip";
        this.internalRegisterJDK9AndUpSrcZip(URI.createFileURI((String)classpath));
    }

    private void internalRegisterJDK9AndUpSrcZip(URI zipURI) {
        this.registerZip(zipURI, true);
    }

    public void registerZip(URI zipURI) {
        this.registerZip(zipURI, false);
    }

    private void registerZip(URI zipURI, boolean isJDK) {
        try (ZipFile zipFile = new ZipFile(zipURI.toFileString());){
            zipFile.stream().filter(entry -> entry.getName().endsWith(".java") || entry.getName().endsWith(".class")).forEach(entry -> {
                String entryName = entry.getName();
                String uri = "archive:" + zipURI.toString() + "!/" + entryName;
                URI physicalURI = URI.createURI((String)uri);
                if (isJDK && entryName.endsWith("module-info.java")) {
                    String modName = entryName.substring(0, entryName.indexOf("/"));
                    this.registerModule(modName, physicalURI);
                } else if (entryName.endsWith("package-info.java")) {
                    int firstIndex = isJDK ? entryName.indexOf("/") + 1 : 0;
                    int lastIndex = entryName.lastIndexOf("/");
                    String packName = entryName.substring(firstIndex, lastIndex).replace("/", ".");
                    this.registerPackage(packName, physicalURI);
                } else {
                    String fullName = (isJDK ? entryName.substring(entryName.indexOf("/") + 1) : entryName).replace("/", ".");
                    int lastDotIndex = fullName.lastIndexOf(".");
                    fullName = fullName.substring(0, lastDotIndex);
                    int preLastDotIndex = fullName.lastIndexOf(".");
                    String packageName = "";
                    String className = fullName;
                    if (preLastDotIndex >= 0) {
                        packageName = fullName.substring(0, preLastDotIndex);
                        className = fullName.substring(preLastDotIndex + 1);
                    }
                    this.registerClassifier(packageName, className, physicalURI);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("Error in processing the zip file: " + zipURI.toFileString());
        }
    }

    private Set<String> registerPackage(String packageName) {
        Set<String> classesInPackage = this.packageClassifierMap.get(packageName = this.checkPackageName(packageName));
        if (classesInPackage == null) {
            classesInPackage = new HashSet<String>();
            this.packageClassifierMap.put(packageName, classesInPackage);
        }
        return classesInPackage;
    }

    private void registerPackage(String packageName, String className) {
        Set<String> classesInPackage = this.registerPackage(packageName);
        if (!classesInPackage.contains(className)) {
            classesInPackage.add(className);
        }
    }

    private void unRegisterPackage(String packageName, String className) {
        if (this.packageClassifierMap.containsKey(packageName = this.checkPackageName(packageName))) {
            this.packageClassifierMap.get(packageName).remove(className);
        }
    }

    private List<String> getPackageContents(String packageName) {
        packageName = this.checkPackageName(packageName);
        UniqueEList content = new UniqueEList();
        if (this.packageClassifierMap.containsKey(packageName)) {
            content.addAll((Collection)this.packageClassifierMap.get(packageName));
        }
        return content;
    }

    public boolean existsPackage(String packageName) {
        packageName = this.checkPackageName(packageName);
        return this.packageClassifierMap.containsKey(packageName);
    }

    public Map<URI, URI> getURIMap() {
        return this.resourceSet != null && this.registerLocal ? this.resourceSet.getURIConverter().getURIMap() : URIConverter.URI_MAP;
    }

    private void updateMapping(URI logicalURI, URI physicalURI) {
        this.getURIMap().put(logicalURI, physicalURI);
    }

    private void removeMapping(URI logicalURI) {
        this.getURIMap().remove(logicalURI);
    }

    public void registerClassifier(CompilationUnit compilationUnit, URI uri) {
        String packageName = LogicalJavaURIGenerator.packageName(compilationUnit);
        for (ConcreteClassifier classifier : compilationUnit.getClassifiers()) {
            this.registerClassifier(packageName, classifier.getName(), uri);
            this.registerInnerClassifiers(classifier, packageName, classifier.getName(), uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerClassifier(String packageName, String classifierName, URI physicalURI) {
        if (classifierName == null || physicalURI == null) {
            return;
        }
        packageName = this.checkPackageName(packageName);
        String innerName = classifierName;
        String outerName = "";
        Object qualifiedName = packageName;
        int idx = classifierName.lastIndexOf("$");
        if (idx >= 0) {
            int indexPlusOne = idx + 1;
            innerName = classifierName.substring(indexPlusOne);
            outerName = classifierName.substring(0, indexPlusOne);
            qualifiedName = ".".equals(packageName) ? outerName : packageName + outerName;
        }
        JavaClasspath javaClasspath = this;
        synchronized (javaClasspath) {
            this.registerPackage((String)qualifiedName, innerName);
            Object qualifiedClassifierName = ".".equals(packageName) ? classifierName : packageName + classifierName;
            URI logicalURI = LogicalJavaURIGenerator.getJavaFileResourceURI((String)qualifiedClassifierName);
            this.updateMapping(logicalURI, physicalURI);
            Object outerPackage = qualifiedName;
            while (((String)outerPackage).endsWith("$")) {
                idx = ((String)(outerPackage = ((String)outerPackage).substring(0, ((String)outerPackage).length() - 1))).lastIndexOf("$");
                if (idx == -1) {
                    idx = ((String)outerPackage).lastIndexOf(".");
                }
                int indexPlusOne = idx + 1;
                String outerClassifier = ((String)outerPackage).substring(indexPlusOne);
                outerPackage = ((String)outerPackage).substring(0, indexPlusOne);
                outerPackage = this.checkPackageName((String)outerPackage);
                this.registerPackage((String)outerPackage, outerClassifier);
            }
            if (((String)(outerPackage = ((String)outerPackage).substring(0, ((String)outerPackage).length() - 1))).contains(".")) {
                this.registerPackages(((String)outerPackage).split("\\."));
            }
        }
    }

    private void registerInnerClassifiers(ConcreteClassifier classifier, String packageName, String className, URI uri) {
        for (Member innerCand : classifier.getMembers()) {
            if (!(innerCand instanceof ConcreteClassifier)) continue;
            String newClassName = className + "$" + innerCand.getName();
            this.registerClassifier(packageName, newClassName, uri);
            this.registerInnerClassifiers((ConcreteClassifier)innerCand, packageName, newClassName, uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterClassifier(String packageName, String classifierName) {
        if (classifierName == null || classifierName.equals("")) {
            return;
        }
        packageName = this.checkPackageName(packageName);
        String innerName = classifierName;
        String outerName = "";
        Object qualifiedName = packageName;
        int idx = classifierName.lastIndexOf("$");
        if (idx >= 0) {
            innerName = classifierName.substring(idx + 1);
            outerName = classifierName.substring(0, idx + 1);
            qualifiedName = ".".equals(packageName) ? outerName : packageName + outerName;
        }
        JavaClasspath javaClasspath = this;
        synchronized (javaClasspath) {
            this.unRegisterPackage((String)qualifiedName, innerName);
            Object fullName = null;
            fullName = ".".equals(packageName) ? classifierName : packageName + classifierName;
            URI logicalUri = LogicalJavaURIGenerator.getJavaFileResourceURI((String)fullName);
            this.removeMapping(logicalUri);
        }
    }

    public boolean isPackageRegistered(String packageName) {
        packageName = this.checkPackageName(packageName);
        return this.packageClassifierMap.containsKey(packageName);
    }

    public boolean isRegistered(String fullQualifiedName) {
        int idx = fullQualifiedName.lastIndexOf("$");
        if (idx == -1) {
            idx = fullQualifiedName.lastIndexOf(".");
        }
        String containerName = fullQualifiedName.substring(0, idx + 1);
        String classifierName = fullQualifiedName.substring(idx + 1);
        List<String> containerContent = this.getPackageContents(containerName);
        if (containerContent == null) {
            return false;
        }
        return containerContent.contains(classifierName);
    }

    private String checkPackageName(String packageName) {
        if (!packageName.endsWith(".") && !packageName.endsWith("$")) {
            return packageName + ".";
        }
        return packageName;
    }
}

